/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.scheduling;

import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.RecipeTimeoutException;
import org.openrewrite.Result;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.internal.FindRecipeRunException;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.quark.Quark;
import org.openrewrite.scheduling.RecipeStack;
import org.openrewrite.scheduling.WatchableExecutionContext;
import org.openrewrite.table.RecipeRunStats;
import org.openrewrite.table.SourcesFileErrors;
import org.openrewrite.table.SourcesFileResults;

public class RecipeRunCycle<LSS extends LargeSourceSet> {
    private final Recipe recipe;
    private final int cycle;
    private final Cursor rootCursor;
    private final WatchableExecutionContext ctx;
    private final RecipeRunStats recipeRunStats;
    private final SourcesFileResults sourcesFileResults;
    private final SourcesFileErrors errorsTable;
    private final BiFunction<LSS, UnaryOperator<@Nullable SourceFile>, LSS> sourceSetEditor;
    private final RecipeStack allRecipeStack = new RecipeStack();
    private final long cycleStartTime = System.nanoTime();
    private final AtomicBoolean thrownErrorOnTimeout = new AtomicBoolean();
    private final Set<Recipe> madeChangesInThisCycle = Collections.newSetFromMap(new IdentityHashMap());
    private transient @Nullable Boolean isScanningRecipe;

    public int getRecipePosition() {
        return this.allRecipeStack.getRecipePosition();
    }

    public LSS scanSources(LSS sourceSet) {
        if (this.isScanningRequired()) {
            return (LSS)((LargeSourceSet)this.sourceSetEditor.apply(sourceSet, sourceFile -> this.allRecipeStack.reduce((LargeSourceSet)sourceSet, this.recipe, this.ctx, (source, recipeStack) -> {
                Recipe recipe = (Recipe)recipeStack.peek();
                if (source == null) {
                    return null;
                }
                SourceFile after = source;
                if (recipe instanceof ScanningRecipe) {
                    try {
                        ScanningRecipe scanningRecipe = (ScanningRecipe)recipe;
                        Object acc = scanningRecipe.getAccumulator(this.rootCursor, this.ctx);
                        this.recipeRunStats.recordScan(recipe, () -> {
                            TreeVisitor<?, ExecutionContext> scanner = scanningRecipe.getScanner(acc);
                            if (scanner.isAcceptable((SourceFile)source, this.ctx)) {
                                Object maybeMutated = scanner.visit((Tree)source, this.ctx, this.rootCursor);
                                assert (maybeMutated == source || !this.ctx.getMessage("org.openrewrite.test.scanningMutationValidation", false).booleanValue()) : "Edits made from within ScanningRecipe.getScanner() are discarded. The purpose of a scanner is to aggregate information for use in subsequent phases. Use ScanningRecipe.getVisitor() for making edits. To disable this warning set TypeValidation.immutableScanning to false in your tests.";
                            }
                            return source;
                        });
                    }
                    catch (Throwable t) {
                        after = this.handleError(recipe, (SourceFile)source, after, t);
                        assert (after != null);
                        after = RecipeRunCycle.addRecipesThatMadeChanges(recipeStack, after);
                    }
                }
                return after;
            }, sourceFile)));
        }
        return sourceSet;
    }

    public LSS generateSources(LSS sourceSet) {
        if (this.isScanningRequired()) {
            List generatedInThisCycle = this.allRecipeStack.reduce((LargeSourceSet)sourceSet, this.recipe, this.ctx, (acc, recipeStack) -> {
                Recipe recipe = (Recipe)recipeStack.peek();
                if (recipe instanceof ScanningRecipe) {
                    assert (acc != null);
                    ScanningRecipe scanningRecipe = (ScanningRecipe)recipe;
                    if (!acc.isEmpty()) {
                        for (SourceFile source2 : acc) {
                            try {
                                this.recipeRunStats.recordScan(recipe, () -> {
                                    TreeVisitor<?, ExecutionContext> scanner = scanningRecipe.getScanner(scanningRecipe.getAccumulator(this.rootCursor, this.ctx));
                                    if (scanner.isAcceptable(source2, this.ctx)) {
                                        scanner.visit(source2, this.ctx, this.rootCursor);
                                    }
                                    return source2;
                                });
                            }
                            catch (Throwable t) {
                                this.handleError(recipe, source2, source2, t);
                            }
                        }
                    }
                    try {
                        ArrayList<SourceFile> generated = new ArrayList<SourceFile>(scanningRecipe.generate(scanningRecipe.getAccumulator(this.rootCursor, this.ctx), Collections.unmodifiableList(acc), this.ctx));
                        generated.replaceAll(source -> RecipeRunCycle.addRecipesThatMadeChanges(recipeStack, source));
                        if (!generated.isEmpty()) {
                            acc.addAll(generated);
                            generated.forEach(source -> this.recordSourceFileResult(null, (SourceFile)source, (Stack<Recipe>)recipeStack, this.ctx));
                            this.madeChangesInThisCycle.add(recipe);
                        }
                    }
                    catch (Throwable t) {
                        this.handleError(recipe, new Quark(Tree.randomId(), Paths.get("error during generation", new String[0]), Markers.EMPTY, null, null), null, t);
                    }
                }
                return acc;
            }, new ArrayList());
            return (LSS)sourceSet.generate(generatedInThisCycle);
        }
        return sourceSet;
    }

    public LSS editSources(LSS sourceSet) {
        return (LSS)((LargeSourceSet)this.sourceSetEditor.apply(sourceSet, sourceFile -> this.allRecipeStack.reduce((LargeSourceSet)sourceSet, this.recipe, this.ctx, (source, recipeStack) -> {
            Recipe recipe = (Recipe)recipeStack.peek();
            if (source == null) {
                return null;
            }
            SourceFile after = source;
            try {
                Duration duration = Duration.ofNanos(System.nanoTime() - this.cycleStartTime);
                if (duration.compareTo(this.ctx.getMessage("org.openrewrite.runTimeout", Duration.ofMinutes(4L))) > 0) {
                    if (this.thrownErrorOnTimeout.compareAndSet(false, true)) {
                        RecipeTimeoutException t = new RecipeTimeoutException(recipe);
                        this.ctx.getOnError().accept(t);
                        this.ctx.getOnTimeout().accept(t, this.ctx);
                    }
                    return source;
                }
                if (this.ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                    return source;
                }
                TreeVisitor<?, ExecutionContext> visitor = recipe.getVisitor();
                visitor.setCursor(this.rootCursor);
                after = this.recipeRunStats.recordEdit(recipe, () -> {
                    if (visitor.isAcceptable((SourceFile)source, this.ctx)) {
                        return (SourceFile)visitor.visit((Tree)source, this.ctx, this.rootCursor);
                    }
                    return source;
                });
                if (after != source) {
                    this.madeChangesInThisCycle.add(recipe);
                    this.recordSourceFileResult((SourceFile)source, after, (Stack<Recipe>)recipeStack, this.ctx);
                    if (source.getMarkers().findFirst(org.openrewrite.marker.Generated.class).isPresent()) {
                        return source;
                    }
                    this.recipeRunStats.recordSourceFileChanged((SourceFile)source, after);
                } else if (this.ctx.hasNewMessages()) {
                    this.madeChangesInThisCycle.add(recipe);
                    this.ctx.resetHasNewMessages();
                }
            }
            catch (Throwable t) {
                after = this.handleError(recipe, (SourceFile)source, after, t);
            }
            if (after != null && after != source) {
                after = RecipeRunCycle.addRecipesThatMadeChanges(recipeStack, after);
            }
            return after;
        }, sourceFile)));
    }

    private void recordSourceFileResult(@Nullable SourceFile before, @Nullable SourceFile after, Stack<Recipe> recipeStack, ExecutionContext ctx) {
        boolean hierarchical;
        String beforePath = before == null ? "" : before.getSourcePath().toString();
        String afterPath = after == null ? "" : after.getSourcePath().toString();
        Recipe recipe = recipeStack.peek();
        Long effortSeconds = recipe.getEstimatedEffortPerOccurrence() == null || Result.isLocalAndHasNoChanges(before, after) ? 0L : recipe.getEstimatedEffortPerOccurrence().getSeconds();
        String parentName = "";
        boolean bl = hierarchical = recipeStack.size() > 1;
        if (hierarchical) {
            parentName = ((Recipe)recipeStack.get(recipeStack.size() - 2)).getName();
        }
        String recipeName = recipe.getName();
        this.sourcesFileResults.insertRow(ctx, new SourcesFileResults.Row(beforePath, afterPath, parentName, recipeName, effortSeconds, this.cycle));
        if (hierarchical) {
            this.recordSourceFileResult(beforePath, afterPath, recipeStack.subList(0, recipeStack.size() - 1), effortSeconds, ctx);
        }
    }

    private void recordSourceFileResult(@Nullable String beforePath, @Nullable String afterPath, List<Recipe> recipeStack, Long effortSeconds, ExecutionContext ctx) {
        if (recipeStack.size() <= 1) {
            return;
        }
        String parentName = recipeStack.size() == 2 ? "" : recipeStack.get(recipeStack.size() - 2).getName();
        Recipe recipe = recipeStack.get(recipeStack.size() - 1);
        this.sourcesFileResults.insertRow(ctx, new SourcesFileResults.Row(beforePath, afterPath, parentName, recipe.getName(), effortSeconds, this.cycle));
        this.recordSourceFileResult(beforePath, afterPath, recipeStack.subList(0, recipeStack.size() - 1), effortSeconds, ctx);
    }

    private @Nullable SourceFile handleError(Recipe recipe, SourceFile sourceFile, @Nullable SourceFile after, Throwable t) {
        this.ctx.getOnError().accept(t);
        if (t instanceof RecipeRunException) {
            RecipeRunException vt = (RecipeRunException)t;
            after = (SourceFile)new FindRecipeRunException(vt).visitNonNull(Objects.requireNonNull(after, "after is null"), 0);
        }
        this.errorsTable.insertRow(this.ctx, new SourcesFileErrors.Row(sourceFile.getSourcePath().toString(), recipe.getName(), ExceptionUtils.sanitizeStackTrace(t, RecipeScheduler.class)));
        return after;
    }

    private static <S extends SourceFile> S addRecipesThatMadeChanges(List<Recipe> recipeStack, S afterFile) {
        return (S)((SourceFile)afterFile.withMarkers(afterFile.getMarkers().computeByType(RecipesThatMadeChanges.create(recipeStack), (r1, r2) -> {
            r1.getRecipes().addAll(r2.getRecipes());
            return r1;
        })));
    }

    private boolean isScanningRequired() {
        if (this.isScanningRecipe == null) {
            this.isScanningRecipe = RecipeRunCycle.isScanningRequired(this.recipe);
        }
        return this.isScanningRecipe;
    }

    private static boolean isScanningRequired(Recipe recipe) {
        if (recipe instanceof ScanningRecipe) {
            if (recipe instanceof DeclarativeRecipe) {
                for (Recipe precondition : ((DeclarativeRecipe)recipe).getPreconditions()) {
                    if (!RecipeRunCycle.isScanningRequired(precondition)) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        for (Recipe r : recipe.getRecipeList()) {
            if (!RecipeRunCycle.isScanningRequired(r)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public RecipeRunCycle(Recipe recipe, int cycle, Cursor rootCursor, WatchableExecutionContext ctx, RecipeRunStats recipeRunStats, SourcesFileResults sourcesFileResults, SourcesFileErrors errorsTable, BiFunction<LSS, UnaryOperator<@Nullable SourceFile>, LSS> sourceSetEditor) {
        this.recipe = recipe;
        this.cycle = cycle;
        this.rootCursor = rootCursor;
        this.ctx = ctx;
        this.recipeRunStats = recipeRunStats;
        this.sourcesFileResults = sourcesFileResults;
        this.errorsTable = errorsTable;
        this.sourceSetEditor = sourceSetEditor;
    }

    @Generated
    public int getCycle() {
        return this.cycle;
    }

    @Generated
    public Set<Recipe> getMadeChangesInThisCycle() {
        return this.madeChangesInThisCycle;
    }
}

