/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import io.moderne.jsonrpc.JsonRpc;
import io.moderne.jsonrpc.JsonRpcMethod;
import io.moderne.jsonrpc.JsonRpcRequest;
import io.moderne.jsonrpc.JsonRpcSuccess;
import io.moderne.jsonrpc.internal.SnowflakeId;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.rpc.RpcObjectData;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcRecipe;
import org.openrewrite.rpc.request.Generate;
import org.openrewrite.rpc.request.GenerateResponse;
import org.openrewrite.rpc.request.GetObject;
import org.openrewrite.rpc.request.GetObjectResponse;
import org.openrewrite.rpc.request.GetRecipesResponse;
import org.openrewrite.rpc.request.Parse;
import org.openrewrite.rpc.request.ParseResponse;
import org.openrewrite.rpc.request.PrepareRecipe;
import org.openrewrite.rpc.request.PrepareRecipeResponse;
import org.openrewrite.rpc.request.Print;
import org.openrewrite.rpc.request.RpcRequest;
import org.openrewrite.rpc.request.Visit;
import org.openrewrite.rpc.request.VisitResponse;

public class RewriteRpc {
    private final JsonRpc jsonRpc;
    private final AtomicInteger batchSize = new AtomicInteger(10);
    private Duration timeout = Duration.ofMinutes(1L);
    private final AtomicBoolean traceSendPackets = new AtomicBoolean(false);
    private @Nullable PrintStream logFile;
    private final Map<String, Object> remoteObjects = new HashMap<String, Object>();
    @VisibleForTesting
    final Map<String, Object> localObjects = new HashMap<String, Object>();
    final Map<Object, String> localObjectIds = new IdentityHashMap<Object, String>();
    private final Map<Integer, Object> remoteRefs = new HashMap<Integer, Object>();

    public RewriteRpc(JsonRpc jsonRpc, final Environment marketplace) {
        this.jsonRpc = jsonRpc;
        HashMap<String, Recipe> preparedRecipes = new HashMap<String, Recipe>();
        IdentityHashMap<Recipe, Cursor> recipeCursors = new IdentityHashMap<Recipe, Cursor>();
        jsonRpc.rpc("Visit", (JsonRpcMethod)new Visit.Handler(this.localObjects, preparedRecipes, recipeCursors, this::getObject, this::getCursor));
        jsonRpc.rpc("Generate", (JsonRpcMethod)new Generate.Handler(this.localObjects, preparedRecipes, recipeCursors, this::getObject));
        jsonRpc.rpc("GetObject", (JsonRpcMethod)new GetObject.Handler(this.batchSize, this.remoteObjects, this.localObjects, this.traceSendPackets));
        jsonRpc.rpc("GetRecipes", (JsonRpcMethod)new JsonRpcMethod<Void>(){

            protected Object handle(Void noParams) {
                return marketplace.listRecipeDescriptors();
            }
        });
        jsonRpc.rpc("PrepareRecipe", (JsonRpcMethod)new PrepareRecipe.Handler(preparedRecipes));
        jsonRpc.rpc("Print", (JsonRpcMethod)new JsonRpcMethod<Print>(){

            protected Object handle(Print request) {
                Tree tree = (Tree)RewriteRpc.this.getObject(request.getTreeId());
                Cursor cursor = RewriteRpc.this.getCursor(request.getCursor());
                return tree.print(new Cursor(cursor, tree));
            }
        });
        jsonRpc.bind();
    }

    public RewriteRpc batchSize(int batchSize) {
        this.batchSize.set(batchSize);
        return this;
    }

    public RewriteRpc traceGetObjectOutput() {
        this.traceSendPackets.set(true);
        return this;
    }

    public RewriteRpc traceGetObjectInput(PrintStream log) {
        this.logFile = log;
        return this;
    }

    public RewriteRpc timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public void shutdown() {
        this.jsonRpc.shutdown();
    }

    public <P> @Nullable Tree visit(SourceFile sourceFile, String visitorName, P p) {
        return this.visit(sourceFile, visitorName, p, null);
    }

    public <P> @Nullable Tree visit(Tree tree, String visitorName, P p, @Nullable Cursor cursor) {
        VisitResponse response = this.scan(tree, visitorName, p, cursor);
        return response.isModified() ? (Tree)this.getObject(tree.getId().toString()) : tree;
    }

    public <P> VisitResponse scan(SourceFile sourceFile, String visitorName, P p) {
        return this.scan(sourceFile, visitorName, p, null);
    }

    public <P> VisitResponse scan(Tree sourceFile, String visitorName, P p, @Nullable Cursor cursor) {
        this.localObjects.put(sourceFile.getId().toString(), sourceFile);
        String pId = this.maybeUnwrapExecutionContext(p);
        List<String> cursorIds = this.getCursorIds(cursor);
        return this.send("Visit", new Visit(visitorName, null, sourceFile.getId().toString(), pId, cursorIds), VisitResponse.class);
    }

    public Collection<? extends SourceFile> generate(String remoteRecipeId, ExecutionContext ctx) {
        String ctxId = this.maybeUnwrapExecutionContext(ctx);
        List generated = this.send("Generate", new Generate(remoteRecipeId, ctxId), GenerateResponse.class);
        if (!generated.isEmpty()) {
            return generated.stream().map(this::getObject).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private <P> String maybeUnwrapExecutionContext(P p) {
        Object p2 = p;
        while (p2 instanceof DelegatingExecutionContext) {
            p2 = ((DelegatingExecutionContext)p2).getDelegate();
        }
        String pId = this.localObjectIds.computeIfAbsent(p2, p3 -> SnowflakeId.generateId());
        if (p2 instanceof ExecutionContext) {
            ((ExecutionContext)p2).putMessage("org.openrewrite.rpc.id", pId);
        }
        this.localObjects.put(pId, p2);
        return pId;
    }

    public List<RecipeDescriptor> getRecipes() {
        return this.send("GetRecipes", null, GetRecipesResponse.class);
    }

    public Recipe prepareRecipe(String id) {
        return this.prepareRecipe(id, Collections.emptyMap());
    }

    public Recipe prepareRecipe(String id, Map<String, Object> options) {
        PrepareRecipeResponse r = this.send("PrepareRecipe", new PrepareRecipe(id, options), PrepareRecipeResponse.class);
        return new RpcRecipe(this, r.getId(), r.getDescriptor(), r.getEditVisitor(), r.getScanVisitor());
    }

    public List<SourceFile> parse(String parser, Iterable<Parser.Input> inputs, @Nullable Path relativeTo) {
        ArrayList<Parse.Input> mappedInputs = new ArrayList<Parse.Input>();
        for (Parser.Input input : inputs) {
            if (input.isSynthetic() || !Files.isRegularFile(input.getPath(), new LinkOption[0])) {
                mappedInputs.add(new Parse.StringInput(input.getSource(new InMemoryExecutionContext()).readFully(), input.getPath()));
                continue;
            }
            mappedInputs.add(new Parse.PathInput(input.getPath()));
        }
        List parsed = this.send("Parse", new Parse(parser, mappedInputs, relativeTo != null ? relativeTo.toString() : null), ParseResponse.class);
        if (!parsed.isEmpty()) {
            return parsed.stream().map(this::getObject).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String print(SourceFile tree) {
        return this.print(tree, new Cursor(null, "root"));
    }

    public String print(Tree tree, Cursor parent) {
        this.localObjects.put(tree.getId().toString(), tree);
        return this.send("Print", new Print(tree.getId().toString(), this.getCursorIds(parent)), String.class);
    }

    @VisibleForTesting
    @Nullable List<String> getCursorIds(@Nullable Cursor cursor) {
        List cursorIds = null;
        if (cursor != null) {
            cursorIds = cursor.getPathAsStream().map(c -> {
                String id = c instanceof Tree ? ((Tree)c).getId().toString() : this.localObjectIds.computeIfAbsent(c, c2 -> SnowflakeId.generateId());
                this.localObjects.put(id, c);
                return id;
            }).collect(Collectors.toList());
        }
        return cursorIds;
    }

    @VisibleForTesting
    public <T> T getObject(String id) {
        RpcReceiveQueue q = new RpcReceiveQueue(this.remoteRefs, this.logFile, () -> this.send("GetObject", new GetObject(id), GetObjectResponse.class));
        Object remoteObject = q.receive(this.localObjects.get(id), null);
        if (q.take().getState() != RpcObjectData.State.END_OF_OBJECT) {
            throw new IllegalStateException("Expected END_OF_OBJECT");
        }
        this.remoteObjects.put(id, remoteObject);
        this.localObjects.put(id, remoteObject);
        return (T)remoteObject;
    }

    protected <P> P send(String method, @Nullable RpcRequest body, Class<P> responseType) {
        try {
            return (P)((JsonRpcSuccess)this.jsonRpc.send(JsonRpcRequest.newRequest((String)method, (Object)body)).get(this.timeout.getSeconds(), TimeUnit.SECONDS)).getResult(responseType);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    Cursor getCursor(@Nullable List<String> cursorIds) {
        Cursor cursor = new Cursor(null, "root");
        if (cursorIds != null) {
            for (int i = cursorIds.size() - 1; i >= 0; --i) {
                String cursorId = cursorIds.get(i);
                Object cursorObject = this.getObject(cursorId);
                this.remoteObjects.put(cursorId, cursorObject);
                cursor = new Cursor(cursor, cursorObject);
            }
        }
        return cursor;
    }
}

