/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.NonNull;

public class RecipeRunStats
extends DataTable<Row> {
    private final MeterRegistry registry = new SimpleMeterRegistry();
    private final Set<Path> sourceFileChanged = new HashSet<Path>();

    public RecipeRunStats(Recipe recipe) {
        super(recipe, "Recipe performance", "Statistics used in analyzing the performance of recipes.");
    }

    public void recordSourceFileChanged(@Nullable SourceFile before, @Nullable SourceFile after) {
        if (after != null) {
            this.sourceFileChanged.add(after.getSourcePath());
        } else if (before != null) {
            this.sourceFileChanged.add(before.getSourcePath());
        }
    }

    public void recordScan(Recipe recipe, Callable<SourceFile> scan) throws Exception {
        Timer.builder((String)"rewrite.recipe.scan").tag("name", recipe.getName()).publishPercentiles(new double[]{0.99}).register(this.registry).recordCallable(scan);
    }

    public @Nullable SourceFile recordEdit(Recipe recipe, Callable<SourceFile> edit) throws Exception {
        return (SourceFile)Timer.builder((String)"rewrite.recipe.edit").tag("name", recipe.getName()).publishPercentiles(new double[]{0.99}).register(this.registry).recordCallable(edit);
    }

    public void flush(ExecutionContext ctx) {
        String recipeName;
        for (Timer editor : this.registry.find("rewrite.recipe.edit").timers()) {
            recipeName = Objects.requireNonNull(editor.getId().getTag("name"));
            Timer scanner = this.registry.find("rewrite.recipe.scan").tag("name", recipeName).timer();
            Row row = new Row(recipeName, Long.valueOf(editor.count()).intValue(), this.sourceFileChanged.size(), scanner == null ? 0L : (long)scanner.totalTime(TimeUnit.NANOSECONDS), scanner == null ? 0.0 : scanner.takeSnapshot().percentileValues()[0].value(TimeUnit.NANOSECONDS), scanner == null ? 0L : (long)scanner.max(TimeUnit.NANOSECONDS), (long)editor.totalTime(TimeUnit.NANOSECONDS), editor.takeSnapshot().percentileValues()[0].value(TimeUnit.NANOSECONDS), (long)editor.max(TimeUnit.NANOSECONDS));
            this.addRowToDataTable(ctx, row);
        }
        for (Timer scanner : this.registry.find("rewrite.recipe.scan").timers()) {
            recipeName = Objects.requireNonNull(scanner.getId().getTag("name"));
            if (this.registry.find("rewrite.recipe.edit").tag("name", recipeName).timer() != null) continue;
            Row row = new Row(recipeName, Long.valueOf(scanner.count()).intValue(), this.sourceFileChanged.size(), (long)scanner.totalTime(TimeUnit.NANOSECONDS), scanner.takeSnapshot().percentileValues()[0].value(TimeUnit.NANOSECONDS), (long)scanner.max(TimeUnit.NANOSECONDS), 0L, 0.0, 0L);
            this.addRowToDataTable(ctx, row);
        }
    }

    private void addRowToDataTable(ExecutionContext ctx, Row row) {
        ctx.computeMessage("org.openrewrite.dataTables", row, ConcurrentHashMap::new, (extract, allDataTables) -> {
            List dataTablesOfType = (List)allDataTables.computeIfAbsent(this, c -> new ArrayList());
            dataTablesOfType.add(row);
            return allDataTables;
        });
    }

    public static final class Row {
        @Column(displayName="The recipe", description="The recipe whose stats are being measured both individually and cumulatively.")
        private final String recipe;
        @Column(displayName="Source file count", description="The number of source files the recipe ran over.")
        private final Integer sourceFiles;
        @Column(displayName="Source file changed count", description="The number of source files which were changed in the recipe run. Includes files created, deleted, and edited.")
        private final Integer sourceFilesChanged;
        @Column(displayName="Cumulative scanning time (ns)", description="The total time spent across the scanning phase of this recipe.")
        private final Long scanTotalTimeNs;
        @Column(displayName="99th percentile scanning time (ns)", description="99 out of 100 scans completed in this amount of time.")
        private final Double scanP99Ns;
        @Column(displayName="Max scanning time (ns)", description="The max time scanning any one source file.")
        private final Long scanMaxNs;
        @Column(displayName="Cumulative edit time (ns)", description="The total time spent across the editing phase of this recipe.")
        private final Long editTotalTimeNs;
        @Column(displayName="99th percentile edit time (ns)", description="99 out of 100 edits completed in this amount of time.")
        private final Double editP99Ns;
        @Column(displayName="Max edit time (ns)", description="The max time editing any one source file.")
        private final Long editMaxNs;

        @Generated
        public Row(String recipe, Integer sourceFiles, Integer sourceFilesChanged, Long scanTotalTimeNs, Double scanP99Ns, Long scanMaxNs, Long editTotalTimeNs, Double editP99Ns, Long editMaxNs) {
            this.recipe = recipe;
            this.sourceFiles = sourceFiles;
            this.sourceFilesChanged = sourceFilesChanged;
            this.scanTotalTimeNs = scanTotalTimeNs;
            this.scanP99Ns = scanP99Ns;
            this.scanMaxNs = scanMaxNs;
            this.editTotalTimeNs = editTotalTimeNs;
            this.editP99Ns = editP99Ns;
            this.editMaxNs = editMaxNs;
        }

        @Generated
        public String getRecipe() {
            return this.recipe;
        }

        @Generated
        public Integer getSourceFiles() {
            return this.sourceFiles;
        }

        @Generated
        public Integer getSourceFilesChanged() {
            return this.sourceFilesChanged;
        }

        @Generated
        public Long getScanTotalTimeNs() {
            return this.scanTotalTimeNs;
        }

        @Generated
        public Double getScanP99Ns() {
            return this.scanP99Ns;
        }

        @Generated
        public Long getScanMaxNs() {
            return this.scanMaxNs;
        }

        @Generated
        public Long getEditTotalTimeNs() {
            return this.editTotalTimeNs;
        }

        @Generated
        public Double getEditP99Ns() {
            return this.editP99Ns;
        }

        @Generated
        public Long getEditMaxNs() {
            return this.editMaxNs;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$sourceFiles = this.getSourceFiles();
            Integer other$sourceFiles = other.getSourceFiles();
            if (this$sourceFiles == null ? other$sourceFiles != null : !((Object)this$sourceFiles).equals(other$sourceFiles)) {
                return false;
            }
            Integer this$sourceFilesChanged = this.getSourceFilesChanged();
            Integer other$sourceFilesChanged = other.getSourceFilesChanged();
            if (this$sourceFilesChanged == null ? other$sourceFilesChanged != null : !((Object)this$sourceFilesChanged).equals(other$sourceFilesChanged)) {
                return false;
            }
            Long this$scanTotalTimeNs = this.getScanTotalTimeNs();
            Long other$scanTotalTimeNs = other.getScanTotalTimeNs();
            if (this$scanTotalTimeNs == null ? other$scanTotalTimeNs != null : !((Object)this$scanTotalTimeNs).equals(other$scanTotalTimeNs)) {
                return false;
            }
            Double this$scanP99Ns = this.getScanP99Ns();
            Double other$scanP99Ns = other.getScanP99Ns();
            if (this$scanP99Ns == null ? other$scanP99Ns != null : !((Object)this$scanP99Ns).equals(other$scanP99Ns)) {
                return false;
            }
            Long this$scanMaxNs = this.getScanMaxNs();
            Long other$scanMaxNs = other.getScanMaxNs();
            if (this$scanMaxNs == null ? other$scanMaxNs != null : !((Object)this$scanMaxNs).equals(other$scanMaxNs)) {
                return false;
            }
            Long this$editTotalTimeNs = this.getEditTotalTimeNs();
            Long other$editTotalTimeNs = other.getEditTotalTimeNs();
            if (this$editTotalTimeNs == null ? other$editTotalTimeNs != null : !((Object)this$editTotalTimeNs).equals(other$editTotalTimeNs)) {
                return false;
            }
            Double this$editP99Ns = this.getEditP99Ns();
            Double other$editP99Ns = other.getEditP99Ns();
            if (this$editP99Ns == null ? other$editP99Ns != null : !((Object)this$editP99Ns).equals(other$editP99Ns)) {
                return false;
            }
            Long this$editMaxNs = this.getEditMaxNs();
            Long other$editMaxNs = other.getEditMaxNs();
            if (this$editMaxNs == null ? other$editMaxNs != null : !((Object)this$editMaxNs).equals(other$editMaxNs)) {
                return false;
            }
            String this$recipe = this.getRecipe();
            String other$recipe = other.getRecipe();
            return !(this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $sourceFiles = this.getSourceFiles();
            result = result * 59 + ($sourceFiles == null ? 43 : ((Object)$sourceFiles).hashCode());
            Integer $sourceFilesChanged = this.getSourceFilesChanged();
            result = result * 59 + ($sourceFilesChanged == null ? 43 : ((Object)$sourceFilesChanged).hashCode());
            Long $scanTotalTimeNs = this.getScanTotalTimeNs();
            result = result * 59 + ($scanTotalTimeNs == null ? 43 : ((Object)$scanTotalTimeNs).hashCode());
            Double $scanP99Ns = this.getScanP99Ns();
            result = result * 59 + ($scanP99Ns == null ? 43 : ((Object)$scanP99Ns).hashCode());
            Long $scanMaxNs = this.getScanMaxNs();
            result = result * 59 + ($scanMaxNs == null ? 43 : ((Object)$scanMaxNs).hashCode());
            Long $editTotalTimeNs = this.getEditTotalTimeNs();
            result = result * 59 + ($editTotalTimeNs == null ? 43 : ((Object)$editTotalTimeNs).hashCode());
            Double $editP99Ns = this.getEditP99Ns();
            result = result * 59 + ($editP99Ns == null ? 43 : ((Object)$editP99Ns).hashCode());
            Long $editMaxNs = this.getEditMaxNs();
            result = result * 59 + ($editMaxNs == null ? 43 : ((Object)$editMaxNs).hashCode());
            String $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RecipeRunStats.Row(recipe=" + this.getRecipe() + ", sourceFiles=" + this.getSourceFiles() + ", sourceFilesChanged=" + this.getSourceFilesChanged() + ", scanTotalTimeNs=" + this.getScanTotalTimeNs() + ", scanP99Ns=" + this.getScanP99Ns() + ", scanMaxNs=" + this.getScanMaxNs() + ", editTotalTimeNs=" + this.getEditTotalTimeNs() + ", editP99Ns=" + this.getEditP99Ns() + ", editMaxNs=" + this.getEditMaxNs() + ")";
        }
    }
}

