/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.search;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;

public final class RepositoryContainsFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="File pattern", description="A glob expression representing a file path to search for (relative to the project root). Blank/null matches all.Multiple patterns may be specified, separated by a semicolon `;`. If multiple patterns are supplied any of the patterns matching will be interpreted as a match.", required=false, example=".github/workflows/*.yml")
    private final @Nullable String filePattern;

    @Override
    public String getDisplayName() {
        return "Repository contains file";
    }

    @Override
    public String getDescription() {
        return "Intended to be used primarily as a precondition for other recipes, this recipe checks if a repository contains a specific file or files matching a pattern. If present all files in the repository are marked with a `SearchResult` marker. If you want to get only the matching file as a search result, use `FindSourceFiles` instead.";
    }

    @Override
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ZERO;
    }

    @Override
    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (acc.get()) {
                    return tree;
                }
                Object t = new FindSourceFiles(RepositoryContainsFile.this.filePattern).getVisitor().visit(tree, ctx);
                if (t != tree) {
                    acc.set(true);
                }
                return tree;
            }
        };
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean acc) {
        if (!acc.get()) {
            return TreeVisitor.noop();
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(Tree tree, ExecutionContext executionContext) {
                if (tree.getMarkers().findFirst(SearchResult.class).isPresent()) {
                    return tree;
                }
                return tree.withMarkers(tree.getMarkers().add(new SearchResult(Tree.randomId(), "Repository contains file matching pattern: " + RepositoryContainsFile.this.filePattern)));
            }
        };
    }

    @Generated
    public RepositoryContainsFile(@Nullable String filePattern) {
        this.filePattern = filePattern;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RepositoryContainsFile(filePattern=" + this.getFilePattern() + ")";
    }

    @Override
    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryContainsFile)) {
            return false;
        }
        RepositoryContainsFile other = (RepositoryContainsFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RepositoryContainsFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

