/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc.request;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.moderne.jsonrpc.JsonRpcMethod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ObjectMappers;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.rpc.request.RpcRequest;
import org.openrewrite.rpc.request.VisitResponse;
import org.openrewrite.scheduling.RecipeRunCycle;
import org.openrewrite.scheduling.WatchableExecutionContext;
import org.openrewrite.table.RecipeRunStats;
import org.openrewrite.table.SourcesFileErrors;
import org.openrewrite.table.SourcesFileResults;

public final class Visit
implements RpcRequest {
    private final String visitor;
    private final @Nullable Map<String, Object> visitorOptions;
    private final String treeId;
    private final String p;
    private final @Nullable List<String> cursor;

    @Generated
    public Visit(String visitor, @Nullable Map<String, Object> visitorOptions, String treeId, String p, @Nullable List<String> cursor) {
        this.visitor = visitor;
        this.visitorOptions = visitorOptions;
        this.treeId = treeId;
        this.p = p;
        this.cursor = cursor;
    }

    @Generated
    public String getVisitor() {
        return this.visitor;
    }

    @Generated
    public @Nullable Map<String, Object> getVisitorOptions() {
        return this.visitorOptions;
    }

    @Generated
    public String getTreeId() {
        return this.treeId;
    }

    @Generated
    public String getP() {
        return this.p;
    }

    @Generated
    public @Nullable List<String> getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Visit)) {
            return false;
        }
        Visit other = (Visit)o;
        String this$visitor = this.getVisitor();
        String other$visitor = other.getVisitor();
        if (this$visitor == null ? other$visitor != null : !this$visitor.equals(other$visitor)) {
            return false;
        }
        Map<String, Object> this$visitorOptions = this.getVisitorOptions();
        Map<String, Object> other$visitorOptions = other.getVisitorOptions();
        if (this$visitorOptions == null ? other$visitorOptions != null : !((Object)this$visitorOptions).equals(other$visitorOptions)) {
            return false;
        }
        String this$treeId = this.getTreeId();
        String other$treeId = other.getTreeId();
        if (this$treeId == null ? other$treeId != null : !this$treeId.equals(other$treeId)) {
            return false;
        }
        String this$p = this.getP();
        String other$p = other.getP();
        if (this$p == null ? other$p != null : !this$p.equals(other$p)) {
            return false;
        }
        List<String> this$cursor = this.getCursor();
        List<String> other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !((Object)this$cursor).equals(other$cursor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $visitor = this.getVisitor();
        result = result * 59 + ($visitor == null ? 43 : $visitor.hashCode());
        Map<String, Object> $visitorOptions = this.getVisitorOptions();
        result = result * 59 + ($visitorOptions == null ? 43 : ((Object)$visitorOptions).hashCode());
        String $treeId = this.getTreeId();
        result = result * 59 + ($treeId == null ? 43 : $treeId.hashCode());
        String $p = this.getP();
        result = result * 59 + ($p == null ? 43 : $p.hashCode());
        List<String> $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : ((Object)$cursor).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "Visit(visitor=" + this.getVisitor() + ", visitorOptions=" + this.getVisitorOptions() + ", treeId=" + this.getTreeId() + ", p=" + this.getP() + ", cursor=" + this.getCursor() + ")";
    }

    public static class Handler
    extends JsonRpcMethod<Visit> {
        private static final ObjectMapper mapper = ObjectMappers.propertyBasedMapper(null);
        private final Map<String, Object> localObjects;
        private final Map<String, Recipe> preparedRecipes;
        private final Map<Recipe, Cursor> recipeCursors;
        private final Function<String, ?> getObject;
        private final Function<@Nullable List<String>, Cursor> getCursor;

        protected Object handle(Visit request) throws Exception {
            Tree before = (Tree)this.getObject.apply(request.getTreeId());
            this.localObjects.put(before.getId().toString(), before);
            Object p = this.getVisitorP(request);
            TreeVisitor<?, ?> visitor = this.instantiateVisitor(request, p);
            SourceFile after = (SourceFile)visitor.visit(before, p, this.getCursor.apply(request.getCursor()));
            if (after == null) {
                this.localObjects.remove(before.getId().toString());
            } else {
                this.localObjects.put(after.getId().toString(), after);
            }
            this.maybeUpdateExecutionContext(request.getP(), p);
            return new VisitResponse(before != after);
        }

        private TreeVisitor<?, ?> instantiateVisitor(Visit request, Object p) {
            String visitorName = request.getVisitor();
            if (visitorName.startsWith("scan:")) {
                assert (p instanceof ExecutionContext);
                ScanningRecipe recipe = (ScanningRecipe)this.preparedRecipes.get(visitorName.substring("scan:".length()));
                Object acc = recipe.getAccumulator(this.recipeCursors.computeIfAbsent(recipe, r -> new Cursor(null, "root")), (ExecutionContext)p);
                return recipe.getScanner(acc);
            }
            if (visitorName.startsWith("edit:")) {
                Recipe recipe = this.preparedRecipes.get(visitorName.substring("edit:".length()));
                return recipe.getVisitor();
            }
            HashMap<String, String> withJsonType = request.getVisitorOptions() == null ? new HashMap<String, String>() : new HashMap<String, Object>(request.getVisitorOptions());
            withJsonType.put("@c", visitorName);
            try {
                Class visitorType = TypeFactory.defaultInstance().findClass(visitorName);
                return (TreeVisitor)mapper.convertValue(withJsonType, visitorType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private Object getVisitorP(Visit request) {
            String visitorName;
            Object p = this.getObject.apply(request.getP());
            this.localObjects.put(request.getP(), p);
            if (p instanceof ExecutionContext && ((visitorName = request.getVisitor()).startsWith("scan:") || visitorName.startsWith("edit:"))) {
                Recipe recipe = this.preparedRecipes.get(visitorName.substring("edit:".length()));
                WatchableExecutionContext ctx = new WatchableExecutionContext((ExecutionContext)p);
                ctx.putCycle(new RecipeRunCycle<LargeSourceSet>(recipe, 0, new Cursor(null, "root"), ctx, new RecipeRunStats(Recipe.noop()), new SourcesFileResults(Recipe.noop()), new SourcesFileErrors(Recipe.noop()), LargeSourceSet::edit));
                ctx.putCurrentRecipe(recipe);
                return ctx;
            }
            return p;
        }

        private void maybeUpdateExecutionContext(String pId, Object p) {
            if (p instanceof WatchableExecutionContext && ((WatchableExecutionContext)p).hasNewMessages()) {
                ExecutionContext ctx = ((WatchableExecutionContext)p).getDelegate();
                while (ctx instanceof DelegatingExecutionContext) {
                    ctx = ((DelegatingExecutionContext)ctx).getDelegate();
                }
                this.localObjects.put(pId, ((InMemoryExecutionContext)ctx).clone());
            }
        }

        @Generated
        public Handler(Map<String, Object> localObjects, Map<String, Recipe> preparedRecipes, Map<Recipe, Cursor> recipeCursors, Function<String, ?> getObject, Function<@Nullable List<String>, Cursor> getCursor) {
            this.localObjects = localObjects;
            this.preparedRecipes = preparedRecipes;
            this.recipeCursors = recipeCursors;
            this.getObject = getObject;
            this.getCursor = getCursor;
        }
    }
}

