/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc.request;

import io.moderne.jsonrpc.JsonRpcMethod;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcObjectData;
import org.openrewrite.rpc.RpcSendQueue;
import org.openrewrite.rpc.request.RpcRequest;

public final class GetObject
implements RpcRequest {
    private final String id;

    @Generated
    public GetObject(String id) {
        this.id = id;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetObject)) {
            return false;
        }
        GetObject other = (GetObject)o;
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GetObject(id=" + this.getId() + ")";
    }

    public static class Handler
    extends JsonRpcMethod<GetObject> {
        private static final ExecutorService forkJoin = ForkJoinPool.commonPool();
        private final int batchSize;
        private final Map<String, Object> remoteObjects;
        private final Map<String, Object> localObjects;
        private final Map<String, BlockingQueue<List<RpcObjectData>>> inProgressGetRpcObjects = new ConcurrentHashMap<String, BlockingQueue<List<RpcObjectData>>>();
        private final Map<Object, Integer> localRefs = new IdentityHashMap<Object, Integer>();

        protected Object handle(GetObject request) throws Exception {
            Object after = this.localObjects.get(request.getId());
            if (after == null) {
                ArrayList<RpcObjectData> deleted = new ArrayList<RpcObjectData>(2);
                deleted.add(new RpcObjectData(RpcObjectData.State.DELETE, null, null, null));
                deleted.add(new RpcObjectData(RpcObjectData.State.END_OF_OBJECT, null, null, null));
                return deleted;
            }
            BlockingQueue q = this.inProgressGetRpcObjects.computeIfAbsent(request.getId(), id -> {
                ArrayBlockingQueue batch = new ArrayBlockingQueue(1);
                Object before = this.remoteObjects.get(id);
                RpcSendQueue sendQueue = new RpcSendQueue(this.batchSize, batch::put, this.localRefs);
                forkJoin.submit(() -> {
                    try {
                        Runnable onChange = after instanceof RpcCodec ? () -> ((RpcCodec)after).rpcSend(after, sendQueue) : null;
                        sendQueue.send(after, before, onChange);
                        this.remoteObjects.put((String)id, after);
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        sendQueue.put(new RpcObjectData(RpcObjectData.State.END_OF_OBJECT, null, null, null));
                        sendQueue.flush();
                    }
                    return 0;
                });
                return batch;
            });
            List batch = (List)q.take();
            if (((RpcObjectData)batch.get(batch.size() - 1)).getState() == RpcObjectData.State.END_OF_OBJECT) {
                this.inProgressGetRpcObjects.remove(request.getId());
            }
            return batch;
        }

        @Generated
        public Handler(int batchSize, Map<String, Object> remoteObjects, Map<String, Object> localObjects) {
            this.batchSize = batchSize;
            this.remoteObjects = remoteObjects;
            this.localObjects = localObjects;
        }
    }
}

