/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ObjectMappers;

public class RecipeLoader {
    private final @Nullable ClassLoader classLoader;
    private final ObjectMapper mapper;

    public RecipeLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.mapper = ObjectMappers.propertyBasedMapper(classLoader);
    }

    public Recipe load(String recipeName, @Nullable Map<String, Object> recipeArgs) {
        if (recipeArgs == null || recipeArgs.isEmpty()) {
            try {
                return (Recipe)Class.forName(recipeName, true, this.classLoader == null ? this.getClass().getClassLoader() : this.classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                return this.instantiateRecipe(recipeName, new HashMap<String, Object>());
            }
        }
        return this.instantiateRecipe(recipeName, recipeArgs);
    }

    private Recipe instantiateRecipe(String recipeName, Map<String, Object> args) throws IllegalArgumentException {
        HashMap<String, Object> withJsonType = new HashMap<String, Object>(args);
        withJsonType.put("@c", recipeName);
        return (Recipe)this.mapper.convertValue(withJsonType, Recipe.class);
    }

    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

