/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.openrewrite.Option;

public class NullUtils {
    private static final List<String> PACKAGE_LEVEL_NON_NULL_ANNOTATIONS = Arrays.asList("NonNullFields", "NullMarked");
    private static final List<String> FIELD_LEVEL_NON_NULL_ANNOTATIONS = Arrays.asList("NonNull", "Nonnull", "NotNull");
    private static final List<String> FIELD_LEVEL_NULLABLE_ANNOTATIONS = Collections.singletonList("Nullable");

    public static List<Field> findNonNullFields(@NonNull Class<?> _class) {
        boolean defaultNonNull = Arrays.stream(_class.getPackage().getDeclaredAnnotations()).map(a -> a.annotationType().getSimpleName()).anyMatch(PACKAGE_LEVEL_NON_NULL_ANNOTATIONS::contains);
        Field[] fields = _class.getDeclaredFields();
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Field> nonNullFields = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            field.setAccessible(true);
            if ((field.getModifiers() & 8) != 0 || NullUtils.fieldHasNullableAnnotation(field) || !defaultNonNull && !NullUtils.fieldHasNonNullableAnnotation(field) && !NullUtils.fieldIsRequiredOption(field)) continue;
            nonNullFields.add(field);
        }
        nonNullFields.sort(Comparator.comparing(Field::getName));
        return nonNullFields;
    }

    private static boolean fieldIsRequiredOption(Field field) {
        Option annotation = field.getAnnotation(Option.class);
        if (annotation != null) {
            return annotation.required();
        }
        return false;
    }

    private static boolean fieldHasNonNullableAnnotation(Field field) {
        String simpleName;
        for (Annotation a : field.getDeclaredAnnotations()) {
            simpleName = a.annotationType().getSimpleName();
            if (!FIELD_LEVEL_NON_NULL_ANNOTATIONS.contains(simpleName)) continue;
            return true;
        }
        for (Annotation a : field.getAnnotatedType().getDeclaredAnnotations()) {
            simpleName = a.annotationType().getSimpleName();
            if (!FIELD_LEVEL_NON_NULL_ANNOTATIONS.contains(simpleName)) continue;
            return true;
        }
        return false;
    }

    private static boolean fieldHasNullableAnnotation(Field field) {
        String simpleName;
        for (Annotation a : field.getDeclaredAnnotations()) {
            simpleName = a.annotationType().getSimpleName();
            if (!FIELD_LEVEL_NULLABLE_ANNOTATIONS.contains(simpleName)) continue;
            return true;
        }
        for (Annotation a : field.getAnnotatedType().getDeclaredAnnotations()) {
            simpleName = a.annotationType().getSimpleName();
            if (!FIELD_LEVEL_NULLABLE_ANNOTATIONS.contains(simpleName)) continue;
            return true;
        }
        return false;
    }
}

