/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;

@JsonIgnoreType
public class DataTable<Row> {
    @Language(value="markdown")
    private final @NlsRewrite.DisplayName String displayName;
    @Language(value="markdown")
    private final @NlsRewrite.Description String description;

    @Deprecated
    public DataTable(Recipe recipe, Class<Row> type, String name, @NlsRewrite.DisplayName @Language(value="markdown") String displayName, @NlsRewrite.Description @Language(value="markdown") String description) {
        this.displayName = displayName;
        this.description = description;
        recipe.addDataTable(this);
    }

    public DataTable(Recipe recipe, @NlsRewrite.DisplayName @Language(value="markdown") String displayName, @NlsRewrite.Description @Language(value="markdown") String description) {
        this.displayName = displayName;
        this.description = description;
        if (recipe != null) {
            recipe.addDataTable(this);
        }
    }

    public Class<Row> getType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void insertRow(ExecutionContext ctx, Row row) {
        if (ctx.getCycle() > 1) {
            return;
        }
        ctx.computeMessage("org.openrewrite.dataTables", row, ConcurrentHashMap::new, (extract, allDataTables) -> {
            List dataTablesOfType = (List)allDataTables.computeIfAbsent(this, c -> new ArrayList());
            dataTablesOfType.add(row);
            return allDataTables;
        });
    }

    @Language(value="markdown")
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Language(value="markdown")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public DataTable(@Language(value="markdown") String displayName, @Language(value="markdown") String description) {
        this.displayName = displayName;
        this.description = description;
    }
}

