/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openrewrite.Contributor;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeException;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.style.NamedStyles;

public class Environment {
    private final Collection<? extends ResourceLoader> resourceLoaders;
    private final Collection<? extends ResourceLoader> dependencyResourceLoaders;

    public List<Recipe> listRecipes() {
        ArrayList<Recipe> dependencyRecipes = new ArrayList<Recipe>();
        for (ResourceLoader resourceLoader : this.dependencyResourceLoaders) {
            dependencyRecipes.addAll(resourceLoader.listRecipes());
        }
        HashMap<String, List<Contributor>> recipeToContributors = new HashMap<String, List<Contributor>>();
        HashMap<String, List<RecipeExample>> hashMap = new HashMap<String, List<RecipeExample>>();
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            if (!(resourceLoader instanceof YamlResourceLoader)) continue;
            hashMap.putAll(resourceLoader.listRecipeExamples());
            recipeToContributors.putAll(resourceLoader.listContributors());
        }
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            recipes.addAll(resourceLoader.listRecipes());
        }
        for (Recipe recipe : dependencyRecipes) {
            if (!(recipe instanceof DeclarativeRecipe)) continue;
            ((DeclarativeRecipe)recipe).initialize(dependencyRecipes, recipeToContributors);
        }
        for (Recipe recipe : recipes) {
            recipe.setContributors((List)recipeToContributors.get(recipe.getName()));
            if (hashMap.containsKey(recipe.getName())) {
                recipe.setExamples((List)hashMap.get(recipe.getName()));
            }
            if (!(recipe instanceof DeclarativeRecipe)) continue;
            ArrayList<Recipe> availableRecipes = new ArrayList<Recipe>();
            availableRecipes.addAll(dependencyRecipes);
            availableRecipes.addAll(recipes);
            ((DeclarativeRecipe)recipe).initialize(availableRecipes, recipeToContributors);
        }
        return recipes;
    }

    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.resourceLoaders.stream().flatMap(r -> r.listCategoryDescriptors().stream()).collect(Collectors.toList());
    }

    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        HashMap<String, List<Contributor>> recipeToContributors = new HashMap<String, List<Contributor>>();
        HashMap<String, List<RecipeExample>> recipeToExamples = new HashMap<String, List<RecipeExample>>();
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            if (resourceLoader instanceof YamlResourceLoader) {
                recipeToContributors.putAll(resourceLoader.listContributors());
                recipeToExamples.putAll(resourceLoader.listRecipeExamples());
                continue;
            }
            if (!(resourceLoader instanceof ClasspathScanningLoader)) continue;
            ClasspathScanningLoader classpathScanningLoader = (ClasspathScanningLoader)resourceLoader;
            Map<String, List<Contributor>> contributors = classpathScanningLoader.listContributors();
            for (String string : contributors.keySet()) {
                if (recipeToContributors.containsKey(string)) {
                    ((List)recipeToContributors.get(string)).addAll((Collection)contributors.get(string));
                    continue;
                }
                recipeToContributors.put(string, contributors.get(string));
            }
            Map<String, List<RecipeExample>> examplesMap = classpathScanningLoader.listRecipeExamples();
            for (String key3 : examplesMap.keySet()) {
                if (recipeToExamples.containsKey(key3)) {
                    ((List)recipeToExamples.get(key3)).addAll((Collection)examplesMap.get(key3));
                    continue;
                }
                recipeToExamples.put(key3, examplesMap.get(key3));
            }
        }
        ArrayList<RecipeDescriptor> result = new ArrayList<RecipeDescriptor>();
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            if (resourceLoader instanceof YamlResourceLoader) {
                result.addAll(((YamlResourceLoader)resourceLoader).listRecipeDescriptors(Collections.emptyList(), recipeToContributors, recipeToExamples));
                continue;
            }
            Collection<RecipeDescriptor> descriptors = resourceLoader.listRecipeDescriptors();
            for (RecipeDescriptor recipeDescriptor : descriptors) {
                if (recipeDescriptor.getContributors() != null && recipeToContributors.containsKey(recipeDescriptor.getName())) {
                    recipeDescriptor.getContributors().addAll((Collection)recipeToContributors.get(recipeDescriptor.getName()));
                }
                if (recipeDescriptor.getExamples() == null || !recipeToExamples.containsKey(recipeDescriptor.getName())) continue;
                recipeDescriptor.getExamples().addAll((Collection)recipeToExamples.get(recipeDescriptor.getName()));
            }
            result.addAll(descriptors);
        }
        return result;
    }

    public Recipe activateRecipes(Iterable<String> activeRecipes) {
        Map recipesByName = this.listRecipes().stream().collect(Collectors.toMap(Recipe::getName, Function.identity()));
        ArrayList<String> recipesNotFound = new ArrayList<String>();
        ArrayList<Recipe> activatedRecipes = new ArrayList<Recipe>();
        for (String activeRecipe : activeRecipes) {
            Recipe recipe = (Recipe)recipesByName.get(activeRecipe);
            if (recipe == null) {
                recipesNotFound.add(activeRecipe);
                continue;
            }
            activatedRecipes.add(recipe);
        }
        if (!recipesNotFound.isEmpty()) {
            List suggestions = recipesNotFound.stream().map(r -> recipesByName.keySet().stream().min(Comparator.comparingInt(a -> StringUtils.getLevenshteinDistance((CharSequence)a, (CharSequence)r))).orElse((String)r)).collect(Collectors.toList());
            String message = String.format("Recipe(s) not found: %s\nDid you mean: %s", String.join((CharSequence)", ", recipesNotFound), String.join((CharSequence)", ", suggestions));
            throw new RecipeException(message);
        }
        if (activatedRecipes.isEmpty()) {
            return Recipe.noop();
        }
        if (activatedRecipes.size() == 1) {
            return (Recipe)activatedRecipes.get(0);
        }
        return new CompositeRecipe(activatedRecipes);
    }

    public Recipe activateRecipes(String ... activeRecipes) {
        return this.activateRecipes(Arrays.asList(activeRecipes));
    }

    public List<NamedStyles> listStyles() {
        return this.resourceLoaders.stream().flatMap(r -> r.listStyles().stream()).collect(Collectors.toList());
    }

    public List<NamedStyles> activateStyles(Iterable<String> activeStyles) {
        ArrayList<NamedStyles> activated = new ArrayList<NamedStyles>();
        List<NamedStyles> styles = this.listStyles();
        for (String activeStyle : activeStyles) {
            for (NamedStyles style : styles) {
                if (!style.getName().equals(activeStyle)) continue;
                activated.add(style);
            }
        }
        return activated;
    }

    public List<NamedStyles> activateStyles(String ... activeStyles) {
        return this.activateStyles(Arrays.asList(activeStyles));
    }

    public Environment(Collection<? extends ResourceLoader> resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
        this.dependencyResourceLoaders = Collections.emptyList();
    }

    public Environment(Collection<? extends ResourceLoader> resourceLoaders, Collection<? extends ResourceLoader> dependencyResourceLoaders) {
        this.resourceLoaders = resourceLoaders;
        this.dependencyResourceLoaders = dependencyResourceLoaders;
    }

    public static Builder builder(Properties properties) {
        return new Builder(properties);
    }

    public static Builder builder() {
        return new Builder(new Properties());
    }

    public static class Builder {
        private final Properties properties;
        private final Collection<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();
        private final Collection<ResourceLoader> dependencyResourceLoaders = new ArrayList<ResourceLoader>();

        public Builder(Properties properties) {
            this.properties = properties;
        }

        public Builder scanRuntimeClasspath(String ... acceptPackages) {
            return this.load(new ClasspathScanningLoader(this.properties, acceptPackages));
        }

        public Builder scanClassLoader(ClassLoader classLoader) {
            return this.load(new ClasspathScanningLoader(this.properties, classLoader));
        }

        public Builder scanYamlResources() {
            return this.load(ClasspathScanningLoader.onlyYaml(this.properties));
        }

        public Builder scanJar(Path jar, Collection<Path> dependencies, ClassLoader classLoader) {
            ArrayList<ClasspathScanningLoader> firstPassLoaderList = new ArrayList<ClasspathScanningLoader>();
            for (Path dep : dependencies) {
                firstPassLoaderList.add(new ClasspathScanningLoader(dep, this.properties, Collections.emptyList(), classLoader));
            }
            ArrayList<ClasspathScanningLoader> secondPassLoaderList = new ArrayList<ClasspathScanningLoader>();
            for (Path dep : dependencies) {
                secondPassLoaderList.add(new ClasspathScanningLoader(dep, this.properties, firstPassLoaderList, classLoader));
            }
            return this.load(new ClasspathScanningLoader(jar, this.properties, secondPassLoaderList, classLoader), secondPassLoaderList);
        }

        public Builder scanUserHome() {
            File userHomeRewriteConfig = new File(System.getProperty("user.home") + "/.rewrite/rewrite.yml");
            if (userHomeRewriteConfig.exists()) {
                Builder builder;
                FileInputStream is = new FileInputStream(userHomeRewriteConfig);
                try {
                    builder = this.load(new YamlResourceLoader(is, userHomeRewriteConfig.toURI(), this.properties));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                is.close();
                return builder;
            }
            return this;
        }

        public Builder load(ResourceLoader resourceLoader) {
            this.resourceLoaders.add(resourceLoader);
            return this;
        }

        public Builder load(ResourceLoader resourceLoader, Collection<? extends ResourceLoader> dependencyResourceLoaders) {
            this.resourceLoaders.add(resourceLoader);
            this.dependencyResourceLoaders.addAll(dependencyResourceLoaders);
            return this;
        }

        public Environment build() {
            return new Environment(this.resourceLoaders, this.dependencyResourceLoaders);
        }
    }
}

