/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class FileAttributes {
    private final @org.jspecify.annotations.Nullable ZonedDateTime creationTime;
    private final @org.jspecify.annotations.Nullable ZonedDateTime lastModifiedTime;
    private final @org.jspecify.annotations.Nullable ZonedDateTime lastAccessTime;
    private final boolean isReadable;
    private final boolean isWritable;
    private final boolean isExecutable;
    private final long size;

    public static @org.jspecify.annotations.Nullable FileAttributes fromPath(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                return new FileAttributes(ZonedDateTime.from(basicFileAttributes.creationTime().toInstant().atZone(ZoneId.systemDefault())), ZonedDateTime.from(basicFileAttributes.lastAccessTime().toInstant().atZone(ZoneId.systemDefault())), ZonedDateTime.from(basicFileAttributes.lastModifiedTime().toInstant().atZone(ZoneId.systemDefault())), Files.isReadable(path), Files.isWritable(path), Files.isExecutable(path), basicFileAttributes.size());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Generated
    public FileAttributes(@org.jspecify.annotations.Nullable ZonedDateTime creationTime, @org.jspecify.annotations.Nullable ZonedDateTime lastModifiedTime, @org.jspecify.annotations.Nullable ZonedDateTime lastAccessTime, boolean isReadable, boolean isWritable, boolean isExecutable, long size) {
        this.creationTime = creationTime;
        this.lastModifiedTime = lastModifiedTime;
        this.lastAccessTime = lastAccessTime;
        this.isReadable = isReadable;
        this.isWritable = isWritable;
        this.isExecutable = isExecutable;
        this.size = size;
    }

    @Generated
    public @org.jspecify.annotations.Nullable ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public @org.jspecify.annotations.Nullable ZonedDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public @org.jspecify.annotations.Nullable ZonedDateTime getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Generated
    public boolean isReadable() {
        return this.isReadable;
    }

    @Generated
    public boolean isWritable() {
        return this.isWritable;
    }

    @Generated
    public boolean isExecutable() {
        return this.isExecutable;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileAttributes)) {
            return false;
        }
        FileAttributes other = (FileAttributes)o;
        if (this.isReadable() != other.isReadable()) {
            return false;
        }
        if (this.isWritable() != other.isWritable()) {
            return false;
        }
        if (this.isExecutable() != other.isExecutable()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$lastModifiedTime = this.getLastModifiedTime();
        ZonedDateTime other$lastModifiedTime = other.getLastModifiedTime();
        if (this$lastModifiedTime == null ? other$lastModifiedTime != null : !((Object)this$lastModifiedTime).equals(other$lastModifiedTime)) {
            return false;
        }
        ZonedDateTime this$lastAccessTime = this.getLastAccessTime();
        ZonedDateTime other$lastAccessTime = other.getLastAccessTime();
        return !(this$lastAccessTime == null ? other$lastAccessTime != null : !((Object)this$lastAccessTime).equals(other$lastAccessTime));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReadable() ? 79 : 97);
        result = result * 59 + (this.isWritable() ? 79 : 97);
        result = result * 59 + (this.isExecutable() ? 79 : 97);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $lastModifiedTime = this.getLastModifiedTime();
        result = result * 59 + ($lastModifiedTime == null ? 43 : ((Object)$lastModifiedTime).hashCode());
        ZonedDateTime $lastAccessTime = this.getLastAccessTime();
        result = result * 59 + ($lastAccessTime == null ? 43 : ((Object)$lastAccessTime).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FileAttributes(creationTime=" + this.getCreationTime() + ", lastModifiedTime=" + this.getLastModifiedTime() + ", lastAccessTime=" + this.getLastAccessTime() + ", isReadable=" + this.isReadable() + ", isWritable=" + this.isWritable() + ", isExecutable=" + this.isExecutable() + ", size=" + this.getSize() + ")";
    }

    @NonNull
    @Generated
    public FileAttributes withCreationTime(@org.jspecify.annotations.Nullable ZonedDateTime creationTime) {
        return this.creationTime == creationTime ? this : new FileAttributes(creationTime, this.lastModifiedTime, this.lastAccessTime, this.isReadable, this.isWritable, this.isExecutable, this.size);
    }

    @NonNull
    @Generated
    public FileAttributes withLastModifiedTime(@org.jspecify.annotations.Nullable ZonedDateTime lastModifiedTime) {
        return this.lastModifiedTime == lastModifiedTime ? this : new FileAttributes(this.creationTime, lastModifiedTime, this.lastAccessTime, this.isReadable, this.isWritable, this.isExecutable, this.size);
    }

    @NonNull
    @Generated
    public FileAttributes withLastAccessTime(@org.jspecify.annotations.Nullable ZonedDateTime lastAccessTime) {
        return this.lastAccessTime == lastAccessTime ? this : new FileAttributes(this.creationTime, this.lastModifiedTime, lastAccessTime, this.isReadable, this.isWritable, this.isExecutable, this.size);
    }

    @NonNull
    @Generated
    public FileAttributes withReadable(boolean isReadable) {
        return this.isReadable == isReadable ? this : new FileAttributes(this.creationTime, this.lastModifiedTime, this.lastAccessTime, isReadable, this.isWritable, this.isExecutable, this.size);
    }

    @NonNull
    @Generated
    public FileAttributes withWritable(boolean isWritable) {
        return this.isWritable == isWritable ? this : new FileAttributes(this.creationTime, this.lastModifiedTime, this.lastAccessTime, this.isReadable, isWritable, this.isExecutable, this.size);
    }

    @NonNull
    @Generated
    public FileAttributes withExecutable(boolean isExecutable) {
        return this.isExecutable == isExecutable ? this : new FileAttributes(this.creationTime, this.lastModifiedTime, this.lastAccessTime, this.isReadable, this.isWritable, isExecutable, this.size);
    }

    @NonNull
    @Generated
    public FileAttributes withSize(long size) {
        return this.size == size ? this : new FileAttributes(this.creationTime, this.lastModifiedTime, this.lastAccessTime, this.isReadable, this.isWritable, this.isExecutable, size);
    }
}

