/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.UUID;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.Remote;

public final class RemoteResource
implements Remote {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    private final InputStream inputStream;
    private final @Nullable Charset charset;
    private final boolean charsetBomMarked;
    private final @Nullable FileAttributes fileAttributes;
    @Language(value="markdown")
    private final @Nullable String description;
    private final @Nullable Checksum checksum;

    @Override
    public InputStream getInputStream(ExecutionContext ctx) {
        return this.inputStream;
    }

    @Generated
    public RemoteResource(UUID id, Path sourcePath, Markers markers, InputStream inputStream, @Nullable Charset charset, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Language(value="markdown") @Nullable String description, @Nullable Checksum checksum) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.inputStream = inputStream;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
        this.fileAttributes = fileAttributes;
        this.description = description;
        this.checksum = checksum;
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    @Generated
    public Markers getMarkers() {
        return this.markers;
    }

    @Generated
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    @Generated
    public @Nullable Charset getCharset() {
        return this.charset;
    }

    @Override
    @Generated
    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Override
    @Generated
    public @Nullable FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    @Override
    @Language(value="markdown")
    @Generated
    public @Nullable String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public @Nullable Checksum getChecksum() {
        return this.checksum;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoteResource(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", inputStream=" + this.getInputStream() + ", charset=" + this.getCharset() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", fileAttributes=" + this.getFileAttributes() + ", description=" + this.getDescription() + ", checksum=" + this.getChecksum() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteResource)) {
            return false;
        }
        RemoteResource other = (RemoteResource)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public RemoteResource withId(UUID id) {
        return this.id == id ? this : new RemoteResource(id, this.sourcePath, this.markers, this.inputStream, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteResource withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new RemoteResource(this.id, sourcePath, this.markers, this.inputStream, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteResource withMarkers(Markers markers) {
        return this.markers == markers ? this : new RemoteResource(this.id, this.sourcePath, markers, this.inputStream, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteResource withInputStream(InputStream inputStream) {
        return this.inputStream == inputStream ? this : new RemoteResource(this.id, this.sourcePath, this.markers, inputStream, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteResource withCharset(@Nullable Charset charset) {
        return this.charset == charset ? this : new RemoteResource(this.id, this.sourcePath, this.markers, this.inputStream, charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteResource withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new RemoteResource(this.id, this.sourcePath, this.markers, this.inputStream, this.charset, charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteResource withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new RemoteResource(this.id, this.sourcePath, this.markers, this.inputStream, this.charset, this.charsetBomMarked, fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteResource withDescription(@Language(value="markdown") @Nullable String description) {
        return this.description == description ? this : new RemoteResource(this.id, this.sourcePath, this.markers, this.inputStream, this.charset, this.charsetBomMarked, this.fileAttributes, description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteResource withChecksum(@Nullable Checksum checksum) {
        return this.checksum == checksum ? this : new RemoteResource(this.id, this.sourcePath, this.markers, this.inputStream, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, checksum);
    }
}

