/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class StringUtils {
    private static final Pattern LINE_BREAK = Pattern.compile("\\R");
    private static final char wrongFileSeparatorChar = (char)(File.separatorChar == '/' ? 92 : 47);

    private StringUtils() {
    }

    public static @Nullable String trimIndentPreserveCRLF(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return StringUtils.trimIndent((text.endsWith("\r\n") ? text.substring(0, text.length() - 2) : text).replace('\r', '\u23ce')).replace('\u23ce', '\r');
    }

    public static String trimIndent(String text) {
        int end;
        if (text.isEmpty()) {
            return text;
        }
        int indentLevel = StringUtils.minCommonIndentLevel(text);
        char startChar = text.charAt(0);
        int start = 0;
        if (startChar == '\n' || startChar == '\r') {
            for (int i = 1; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (!Character.isWhitespace(c)) {
                    start = 1;
                    break;
                }
                if (c != '\n' && c != '\r') continue;
                if (i - 1 <= indentLevel) {
                    start = i;
                    break;
                }
                start = 1;
                break;
            }
        }
        for (end = text.length() - 1; end > start; --end) {
            char endChar = text.charAt(end);
            if (!Character.isWhitespace(endChar)) {
                end = text.length();
                break;
            }
            if (endChar == '\n' || endChar == '\r') break;
        }
        if (end == start) {
            ++end;
        }
        StringBuilder trimmed = new StringBuilder();
        for (int i = start; i < end; ++i) {
            int j;
            for (j = i; j < end; ++j) {
                char c = text.charAt(j);
                if (c == '\r' || c == '\n') {
                    trimmed.append(c);
                    break;
                }
                if (j - i < indentLevel) continue;
                trimmed.append(c);
            }
            i = j;
        }
        return trimmed.toString();
    }

    public static int minCommonIndentLevel(String text) {
        int minIndent = Integer.MAX_VALUE;
        int whiteSpaceCount = 0;
        boolean contentEncountered = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                if (contentEncountered && (minIndent = Math.min(whiteSpaceCount, minIndent)) == 0) break;
                whiteSpaceCount = 0;
                contentEncountered = false;
                continue;
            }
            if (!contentEncountered && Character.isWhitespace(c)) {
                ++whiteSpaceCount;
                continue;
            }
            contentEncountered = true;
        }
        if (contentEncountered) {
            minIndent = Math.min(whiteSpaceCount, minIndent);
        }
        return minIndent;
    }

    public static boolean isBlank(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable String string) {
        return string != null && !string.isEmpty();
    }

    public static String readFully(@Nullable InputStream inputStream) {
        if (inputStream == null) {
            return "";
        }
        return StringUtils.readFully(inputStream, StandardCharsets.UTF_8);
    }

    public static String readFully(InputStream inputStream, Charset charset) {
        String string;
        block9: {
            InputStream is = inputStream;
            try {
                int n;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((n = is.read(buffer)) != -1) {
                    bos.write(buffer, 0, n);
                }
                byte[] bytes = bos.toByteArray();
                string = new String(bytes, charset);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UnsupportedOperationException(e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String capitalize(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    public static String uncapitalize(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return Character.toLowerCase(value.charAt(0)) + value.substring(1);
    }

    public static boolean containsOnlyWhitespaceAndComments(String text) {
        int i = 0;
        char[] chars = text.toCharArray();
        boolean inSingleLineComment = false;
        boolean inMultilineComment = false;
        block10: while (i < chars.length) {
            char c = chars[i];
            if (inSingleLineComment && c == '\n') {
                inSingleLineComment = false;
                continue;
            }
            if (i < chars.length - 1) {
                String s;
                switch (s = String.valueOf(c) + chars[i + 1]) {
                    case "//": {
                        inSingleLineComment = true;
                        i += 2;
                        continue block10;
                    }
                    case "/*": {
                        inMultilineComment = true;
                        i += 2;
                        continue block10;
                    }
                    case "*/": {
                        inMultilineComment = false;
                        i += 2;
                        continue block10;
                    }
                }
            }
            if (!(inSingleLineComment || inMultilineComment || Character.isWhitespace(c))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int indexOfNonWhitespace(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String text, Predicate<Character> test) {
        for (int i = 0; i < text.length(); ++i) {
            if (!test.test(Character.valueOf(text.charAt(i)))) continue;
            return i;
        }
        return -1;
    }

    public static int countOccurrences(@NonNull String text, @NonNull String substring) {
        if (text.isEmpty() || substring.isEmpty()) {
            return 0;
        }
        int count = 0;
        int index = text.indexOf(substring);
        while (index >= 0) {
            ++count;
            index = text.indexOf(substring, index + substring.length());
        }
        return count;
    }

    public static String replaceFirst(@NonNull String text, @NonNull String match, @NonNull String replacement) {
        int start = text.indexOf(match);
        if (match.isEmpty() || text.isEmpty() || start == -1) {
            return text;
        }
        StringBuilder newValue = new StringBuilder(text.length());
        newValue.append(text, 0, start);
        newValue.append(replacement);
        int end = start + match.length();
        if (end < text.length()) {
            newValue.append(text, end, text.length());
        }
        return newValue.toString();
    }

    public static String repeat(String s, int count) {
        int copied;
        if (count == 1) {
            return s;
        }
        byte[] value = s.getBytes();
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, value[0]);
            return new String(single);
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple);
    }

    public static boolean matchesGlob(@Nullable String value, @Nullable String globPattern) {
        if ("*".equals(globPattern)) {
            return true;
        }
        if (globPattern == null) {
            return false;
        }
        if (value == null) {
            value = "";
        }
        return StringUtils.matchesGlob(globPattern.replace(wrongFileSeparatorChar, File.separatorChar), value.replace(wrongFileSeparatorChar, File.separatorChar), false);
    }

    private static boolean matchesGlob(String pattern, String str, boolean caseSensitive) {
        char ch;
        int strIdxStart;
        int patIdxStart = 0;
        int patIdxEnd = pattern.length() - 1;
        int strIdxEnd = str.length() - 1;
        if (!pattern.contains("*")) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i = 0; i <= patIdxEnd; ++i) {
                char ch2 = pattern.charAt(i);
                if (ch2 == '?' || !StringUtils.different(caseSensitive, ch2, str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && (ch = pattern.charAt(patIdxStart)) != '*'; ++patIdxStart, ++strIdxStart) {
            if (ch == '?' || !StringUtils.different(caseSensitive, ch, str.charAt(strIdxStart))) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            return StringUtils.allStars(pattern, patIdxStart, patIdxEnd);
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && (ch = pattern.charAt(patIdxEnd)) != '*') {
            if (ch != '?' && StringUtils.different(caseSensitive, ch, str.charAt(strIdxEnd))) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            return StringUtils.allStars(pattern, patIdxStart, patIdxEnd);
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (pattern.charAt(i) != '*') continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block5: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    char ch3 = pattern.charAt(patIdxStart + j + 1);
                    if (ch3 != '?' && StringUtils.different(caseSensitive, ch3, str.charAt(strIdxStart + i + j))) continue block5;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        return StringUtils.allStars(pattern, patIdxStart, patIdxEnd);
    }

    private static boolean allStars(String chars, int start, int end) {
        for (int i = start; i <= end; ++i) {
            if (chars.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean different(boolean caseSensitive, char ch, char other) {
        return caseSensitive ? ch != other : Character.toUpperCase(ch) != Character.toUpperCase(other);
    }

    public static String indent(String text) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                return indent.toString();
            }
            if (!Character.isWhitespace(c)) {
                return indent.toString();
            }
            indent.append(c);
        }
        return indent.toString();
    }

    public static String greatestCommonMargin(String multiline) {
        String gcm = null;
        StringBuilder margin = new StringBuilder();
        boolean skipRestOfLine = false;
        char[] charArray = multiline.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\n') {
                if (i < charArray.length - 1 && charArray[i + 1] == '\n') {
                    ++i;
                    continue;
                }
                if (i > 0) {
                    if (margin.length() == 0) {
                        return "";
                    }
                    gcm = StringUtils.commonMargin(gcm, margin);
                    margin = new StringBuilder();
                }
                skipRestOfLine = false;
                continue;
            }
            if (Character.isWhitespace(c) && !skipRestOfLine) {
                margin.append(c);
                continue;
            }
            skipRestOfLine = true;
        }
        return gcm == null ? "" : gcm;
    }

    public static String commonMargin(@Nullable CharSequence s1, CharSequence s2) {
        if (s1 == null) {
            String s = s2.toString();
            return s.substring(s.lastIndexOf(10) + 1);
        }
        for (int i = 0; i < s1.length() && i < s2.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i) && Character.isWhitespace(s1.charAt(i))) continue;
            return s1.toString().substring(0, i);
        }
        return s2.length() < s1.length() ? s2.toString() : s1.toString();
    }

    public static boolean isNumeric(@Nullable String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String aspectjNameToPattern(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder(length);
        int prev = 0;
        for (int i = 0; i < length; ++i) {
            boolean isLast = i == length - 1;
            char c = name.charAt(i);
            switch (c) {
                case '.': {
                    if (prev != 46 && (isLast || name.charAt(i + 1) != '.')) {
                        sb.append("[.$]");
                        break;
                    }
                    if (prev != 46) break;
                    sb.append("\\.(.+\\.)?");
                    break;
                }
                case '*': {
                    sb.append("[^.]*");
                    break;
                }
                case '$': 
                case '[': 
                case ']': {
                    sb.append('\\');
                }
                default: {
                    sb.append(c);
                }
            }
            prev = c;
        }
        return sb.toString();
    }

    public static int greatestCommonSubstringLength(String s1, String s2) {
        if (s1.isEmpty() || s2.isEmpty()) {
            return 0;
        }
        int m = s1.length();
        int n = s2.length();
        int maxLen = 0;
        int[] p = new int[n];
        int[] d = new int[n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int cost = s1.charAt(i) != s2.charAt(j) ? 0 : (i == 0 || j == 0 ? 1 : p[j - 1] + 1);
                d[j] = cost;
                if (cost <= maxLen) continue;
                maxLen = cost;
            }
            int[] swap = p;
            p = d;
            d = swap;
        }
        return maxLen;
    }

    /*
     * Unable to fully structure code
     */
    public static int indexOfNextNonWhitespace(int cursor, String source) {
        inMultiLineComment = false;
        inSingleLineComment = false;
        length = source.length();
        while (cursor < length) {
            block8: {
                block7: {
                    current = source.charAt(cursor);
                    if (!inSingleLineComment) break block7;
                    inSingleLineComment = current != '\n';
                    break block8;
                }
                if (length <= cursor + 1) ** GOTO lbl-1000
                next = source.charAt(cursor + 1);
                if (current == '/' && next == '/') {
                    inSingleLineComment = true;
                    ++cursor;
                } else if (current == '/' && next == '*') {
                    inMultiLineComment = true;
                    ++cursor;
                } else if (current == '*' && next == '/') {
                    inMultiLineComment = false;
                    ++cursor;
                } else if (!inMultiLineComment && !Character.isWhitespace(current)) break;
            }
            ++cursor;
        }
        return cursor;
    }

    public static String formatUriForPropertiesFile(String uri) {
        return uri.replaceAll("(?<!\\\\)://", "\\\\://");
    }

    public static boolean hasLineBreak(@Nullable String s) {
        return s != null && LINE_BREAK.matcher(s).find();
    }

    public static boolean containsWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

