/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;

public class Repeat {
    public static TreeVisitor<?, ExecutionContext> repeatUntilStable(TreeVisitor<?, ExecutionContext> v) {
        return Repeat.repeatUntilStable(v, 3);
    }

    public static TreeVisitor<?, ExecutionContext> repeatUntilStable(final TreeVisitor<?, ExecutionContext> v, final int maxCycles) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile && !v.isAcceptable((SourceFile)tree, ctx)) {
                    return tree;
                }
                if (tree != null && !(tree instanceof SourceFile) && this.getCursor().isRoot()) {
                    throw new IllegalArgumentException(String.format("Repeat visitor called on a non-source file tree without a cursor pointing to the root of the tree. Passed tree type: `%s`. This is likely a bug in the calling code. Use a `visit` method that accepts a cursor instead.", tree.getClass().getName()));
                }
                Tree previous = tree;
                Tree current = null;
                for (int i = 0; i < maxCycles && (current = (Tree)v.visit(previous, ctx)) != previous; ++i) {
                    previous = current;
                }
                return current;
            }

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx, Cursor parent) {
                if (tree instanceof SourceFile && !v.isAcceptable((SourceFile)tree, ctx)) {
                    return tree;
                }
                Tree previous = tree;
                Tree current = null;
                for (int i = 0; i < maxCycles && (current = (Tree)v.visit(previous, ctx, parent)) != previous; ++i) {
                    previous = current;
                }
                return current;
            }
        };
    }
}

