/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ValidationException;
import org.openrewrite.internal.StringUtils;

public interface Validated<T>
extends Iterable<Validated<T>> {
    public boolean isValid();

    default public boolean isInvalid() {
        return !this.isValid();
    }

    default public List<Invalid<T>> failures() {
        ArrayList<Invalid<T>> list = new ArrayList<Invalid<T>>();
        for (Validated v : this) {
            if (!v.isInvalid()) continue;
            list.add((Invalid)v);
        }
        return list;
    }

    public static Secret validSecret(String property, String value) {
        return new Secret(property, value);
    }

    public static <T> None<T> none() {
        return new None();
    }

    public static <T> Valid<T> valid(String property, @Nullable T value) {
        return new Valid<T>(property, value);
    }

    public static <T> Validated<T> test(String property, String message, @Nullable T value, Predicate<T> test) {
        return test.test(value) ? Validated.valid(property, value) : Validated.invalid(property, value, message.replace("{}", value == null ? "null" : value.toString()));
    }

    public static <T, V> Validated<T> testNone(String property, String message, @Nullable V value, Predicate<V> test) {
        return test.test(value) ? new None() : Validated.invalid(property, value, message.replace("{}", value == null ? "null" : value.toString()));
    }

    public static <T> Validated<T> required(String property, @Nullable T value) {
        return value != null ? Validated.valid(property, value) : Validated.missing(property, null, "is required");
    }

    public static Validated<String> notBlank(String property, @Nullable String value) {
        return Validated.test(property, "must not be blank", value, s -> value != null && !StringUtils.isBlank(value));
    }

    public static <T> Missing<T> missing(String property, @Nullable T value, String message) {
        return new Missing<T>(property, value, message);
    }

    public static <T> Invalid<T> invalid(String property, @Nullable Object value, String message) {
        return Validated.invalid(property, value, message, null);
    }

    public static <T> Invalid<T> invalid(String property, @Nullable Object value, String message, @Nullable Throwable exception) {
        return new Invalid(property, value, message, exception);
    }

    default public Validated<T> and(Validated<? extends T> validated) {
        if (validated instanceof None) {
            return this;
        }
        return new Both<T>(this, validated);
    }

    default public Validated<T> or(Validated<? extends T> validated) {
        if (validated instanceof None) {
            return this;
        }
        return new Either<T>(this, validated);
    }

    public @Nullable T getValue();

    public static class Invalid<T>
    implements Validated<T> {
        private final String property;
        private final @Nullable Object value;
        private final String message;
        private final @Nullable Throwable exception;

        public Invalid(String property, @Nullable Object value, String message, @Nullable Throwable exception) {
            this.property = property;
            this.value = value;
            this.message = message;
            this.exception = exception;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public @Nullable T getValue() {
            throw new ValidationException(this);
        }

        @Override
        public Iterator<Validated<T>> iterator() {
            return Stream.of(this).iterator();
        }

        public String getMessage() {
            return this.message;
        }

        public String getProperty() {
            return this.property;
        }

        public @Nullable Object getInvalidValue() {
            return this.value;
        }

        public @Nullable Throwable getException() {
            return this.exception;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{property='" + this.property + '\'' + ", value='" + this.value + '\'' + ", message='" + this.message + '\'' + '}';
        }
    }

    public static class Secret
    extends Valid<String> {
        public Secret(String property, String value) {
            super(property, value);
        }

        @Override
        public String toString() {
            return "Secret{property='" + this.property + '\'' + '}';
        }
    }

    public static class None<T>
    implements Validated<T> {
        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Iterator<Validated<T>> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public T getValue() {
            throw new IllegalStateException("Value does not exist");
        }

        @Override
        public Validated<T> or(Validated<? extends T> validated) {
            if (validated instanceof None) {
                return this;
            }
            return validated;
        }

        @Override
        public Validated<T> and(Validated<? extends T> validated) {
            if (validated instanceof None) {
                return this;
            }
            return validated;
        }
    }

    public static class Valid<T>
    implements Validated<T> {
        protected final String property;
        private final @Nullable T value;

        public Valid(String property, @Nullable T value) {
            this.property = property;
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Iterator<Validated<T>> iterator() {
            return Stream.of(this).iterator();
        }

        public String getProperty() {
            return this.property;
        }

        @Override
        public @Nullable T getValue() {
            return this.value;
        }

        public String toString() {
            return "Valid{property='" + this.property + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static class Missing<T>
    extends Invalid<T> {
        public Missing(String property, @Nullable T value, String message) {
            super(property, value, message, null);
        }
    }

    public static class Both<T>
    implements Validated<T> {
        protected final Validated<T> left;
        protected final Validated<T> right;

        public Both(Validated<T> left, Validated<T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isValid() {
            return this.left.isValid() && this.right.isValid();
        }

        @Override
        public T getValue() {
            return this.right.getValue();
        }

        @Override
        public Iterator<Validated<T>> iterator() {
            return Stream.concat(StreamSupport.stream(this.left.spliterator(), false), StreamSupport.stream(this.right.spliterator(), false)).iterator();
        }
    }

    public static class Either<T>
    implements Validated<T> {
        private final Validated<T> left;
        private final Validated<T> right;

        public Either(Validated<T> left, Validated<T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isValid() {
            return this.left.isValid() || this.right.isValid();
        }

        public Optional<Validated<T>> findAny() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 4096), false).filter(Validated::isValid).findAny();
        }

        @Override
        public T getValue() {
            return (T)this.findAny().map(Validated::getValue).orElseThrow(() -> new IllegalStateException("Value does not exist"));
        }

        @Override
        public Iterator<Validated<T>> iterator() {
            if (this.left.isValid() && this.right.isInvalid()) {
                return StreamSupport.stream(this.left.spliterator(), false).iterator();
            }
            if (this.left.isInvalid() && this.right.isValid()) {
                return StreamSupport.stream(this.right.spliterator(), false).iterator();
            }
            return Stream.concat(StreamSupport.stream(this.left.spliterator(), false), StreamSupport.stream(this.right.spliterator(), false)).iterator();
        }
    }
}

