/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Collection;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class DependencyMatcher {
    public static final String STANDARD_OPTION_DESCRIPTION = "Dependency patterns are a concise way of describing which dependencies are applicable to a recipe. Valid dependency patterns take one of these forms:\n\n* groupId:artifactId\n* groupId:artifactId:versionSelector\n* groupId:artifactId:versionSelector/versionPattern\n\n\"groupId\" and \"artifactId\" accept glob patterns.\n\"versionSelector\" accepts both literal version numbers and semver selectors.\n\"versionPattern\" is used for artifacts that encode variant/platform information in their version.Guava is a common example of such a library. Guava appends \"-jre\" or \"-android\" to its version to indicate platform compatibility.";
    private final String groupPattern;
    private final String artifactPattern;
    private final @Nullable VersionComparator versionComparator;

    public DependencyMatcher(String groupPattern, String artifactPattern, @Nullable VersionComparator versionComparator) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.versionComparator = versionComparator;
    }

    public static Validated<DependencyMatcher> build(String pattern) {
        Validated<VersionComparator> validatedVersion;
        String[] patternPieces = pattern.split(":");
        if (patternPieces.length < 2) {
            return Validated.invalid("pattern", pattern, "missing required components. Must specify at least groupId:artifactId");
        }
        if (patternPieces.length > 3) {
            return Validated.invalid("pattern", pattern, "not a valid pattern. Valid patterns take the form groupId:artifactId, groupId:artifactId:version, or groupId:artifactId:version/versionPattern");
        }
        if (patternPieces.length < 3) {
            return Validated.valid("pattern", new DependencyMatcher(patternPieces[0], patternPieces[1], null));
        }
        if (patternPieces[2].contains("/")) {
            String[] versionPieces = patternPieces[2].split("/");
            if (versionPieces.length != 2) {
                return Validated.invalid("pattern", pattern, "unable to parse version \"" + patternPieces[2] + "\"");
            }
            validatedVersion = Semver.validate(versionPieces[0], versionPieces[1]);
        } else {
            validatedVersion = Semver.validate(patternPieces[2], null);
        }
        if (validatedVersion.isInvalid()) {
            return Validated.invalid("pattern", null, "Unable to parse version");
        }
        return Validated.valid("pattern", new DependencyMatcher(patternPieces[0], patternPieces[1], validatedVersion.getValue()));
    }

    public boolean matches(@Nullable String groupId, String artifactId, String version) {
        return StringUtils.matchesGlob(groupId, this.groupPattern) && StringUtils.matchesGlob(artifactId, this.artifactPattern) && (this.versionComparator == null || this.versionComparator.isValid(null, version));
    }

    public boolean matches(@Nullable String groupId, String artifactId) {
        return StringUtils.matchesGlob(groupId, this.groupPattern) && StringUtils.matchesGlob(artifactId, this.artifactPattern);
    }

    public boolean isValidVersion(@Nullable String currentVersion, String newVersion) {
        return this.versionComparator == null || this.versionComparator.isValid(currentVersion, newVersion);
    }

    public Optional<String> upgrade(String currentVersion, Collection<String> availableVersions) {
        if (this.versionComparator == null) {
            return Optional.empty();
        }
        return this.versionComparator.upgrade(currentVersion, availableVersions);
    }
}

