/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public interface RemoteArtifactCache {
    public @Nullable Path get(URI var1);

    public @Nullable Path put(URI var1, InputStream var2, Consumer<Throwable> var3);

    default public @Nullable Path compute(URI uri, Callable<@Nullable InputStream> artifactStream, Consumer<Throwable> onError) {
        Path artifact = this.get(uri);
        if (artifact == null) {
            try {
                InputStream is = artifactStream.call();
                if (is != null) {
                    artifact = this.put(uri, is, onError);
                }
            }
            catch (Exception e) {
                onError.accept(e);
            }
        }
        return artifact;
    }
}

