/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.ZoneOffset;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.LstProvenance;
import org.openrewrite.table.LstProvenanceTable;

public final class FindLstProvenance
extends ScanningRecipe<Accumulator> {
    private final transient LstProvenanceTable provenanceTable = new LstProvenanceTable(this);

    @Override
    public String getDisplayName() {
        return "Find LST provenance";
    }

    @Override
    public String getDescription() {
        return "Produces a data table showing what versions of OpenRewrite/Moderne tooling was used to produce a given LST.";
    }

    @Override
    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (acc.foundLstProvenance) {
                    return tree;
                }
                LstProvenance lstProvenance = tree.getMarkers().findFirst(LstProvenance.class).orElse(null);
                if (lstProvenance == null) {
                    return tree;
                }
                FindLstProvenance.this.provenanceTable.insertRow(ctx, new LstProvenanceTable.Row(lstProvenance.getBuildToolType(), lstProvenance.getBuildToolVersion(), lstProvenance.getLstSerializerVersion(), lstProvenance.getTimestampUtc() == null ? null : Long.valueOf(lstProvenance.getTimestampUtc().toEpochMilli()), lstProvenance.getTimestampUtc() == null ? null : lstProvenance.getTimestampUtc().atZone(ZoneOffset.UTC).toString()));
                acc.foundLstProvenance = true;
                return tree;
            }
        };
    }

    @Generated
    public FindLstProvenance() {
    }

    @Generated
    public LstProvenanceTable getProvenanceTable() {
        return this.provenanceTable;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindLstProvenance(provenanceTable=" + this.getProvenanceTable() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindLstProvenance)) {
            return false;
        }
        FindLstProvenance other = (FindLstProvenance)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindLstProvenance;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static class Accumulator {
        boolean foundLstProvenance;
    }
}

