/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;

@Incubating(since="8.38.0")
public class AdaptiveRadixTree<V> {
    private transient int size = 0;
    private @Nullable Node root;

    public AdaptiveRadixTree() {
    }

    private AdaptiveRadixTree(AdaptiveRadixTree<V> from) {
        this.root = from.root == null ? null : from.root.copy();
        this.size = from.size;
    }

    public AdaptiveRadixTree<V> copy() {
        return new AdaptiveRadixTree<V>(this);
    }

    public void insert(String key, V value) {
        byte[] bytes = key.getBytes();
        if (this.root == null) {
            this.root = new Node.LeafNode<V>(bytes, value);
            this.size = 1;
            return;
        }
        this.put(bytes, value);
    }

    public void clear() {
        this.size = 0;
        this.root = null;
    }

    public @Nullable V search(String key) {
        Node.LeafNode<V> entry = this.getEntry(key);
        return entry == null ? null : (V)entry.getValue();
    }

    private @Nullable Node.LeafNode<V> getEntry(String key) {
        if (this.root == null) {
            return null;
        }
        byte[] bytes = key.getBytes();
        return this.getEntry(this.root, bytes);
    }

    private static boolean equals(byte @Nullable [] a, int aFromIndex, int aToIndex, byte @Nullable [] b, int bFromIndex, int bToIndex) {
        if (a == null || b == null) {
            return a == b;
        }
        if (aToIndex - aFromIndex != bToIndex - bFromIndex) {
            return false;
        }
        for (int i = 0; i < aToIndex - aFromIndex; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return false;
        }
        return true;
    }

    private @Nullable Node.LeafNode<V> getEntry(Node node, byte[] key) {
        int depth = 0;
        boolean skippedPrefix = false;
        while (true) {
            Node nextNode;
            if (node instanceof Node.LeafNode) {
                int startFrom;
                Node.LeafNode leaf = node;
                byte[] leafBytes = leaf.getKeyBytes();
                int n = startFrom = skippedPrefix ? 0 : depth;
                if (AdaptiveRadixTree.equals(leafBytes, startFrom, leafBytes.length, key, startFrom, key.length)) {
                    return leaf;
                }
                return null;
            }
            Node.InnerNode innerNode = (Node.InnerNode)node;
            if (key.length < depth + innerNode.prefixLen) {
                return null;
            }
            if (innerNode.prefixLen <= 8) {
                for (int i = 0; i < innerNode.prefixLen; ++i) {
                    if (innerNode.prefixKeys[i] == key[depth + i]) continue;
                    return null;
                }
            } else {
                skippedPrefix = true;
            }
            if ((depth += innerNode.prefixLen) == key.length) {
                nextNode = innerNode.getLeaf();
                if (!skippedPrefix) {
                    return nextNode;
                }
            } else {
                nextNode = innerNode.findChild(key[depth]);
                ++depth;
            }
            if (nextNode == null) {
                return null;
            }
            node = nextNode;
        }
    }

    void replace(int depth, byte[] key, @Nullable Node.InnerNode prevDepth, Node replaceWith) {
        if (prevDepth == null) {
            this.root = replaceWith;
        } else {
            prevDepth.replace(key[depth - 1], replaceWith);
        }
    }

    private void put(byte[] keyBytes, V value) {
        byte partialKey;
        Node.InnerNode innerNode;
        int depth = 0;
        Node.InnerNode prevDepth = null;
        Node node = this.root;
        while (true) {
            if (node instanceof Node.LeafNode) {
                Node.LeafNode leaf = (Node.LeafNode)node;
                Node pathCompressedNode = AdaptiveRadixTree.lazyExpansion(leaf, keyBytes, value, depth);
                if (pathCompressedNode == node) {
                    leaf.setValue(value);
                    return;
                }
                this.replace(depth, keyBytes, prevDepth, pathCompressedNode);
                ++this.size;
                return;
            }
            innerNode = (Node.InnerNode)node;
            int newDepth = this.matchCompressedPath(innerNode, keyBytes, value, depth, prevDepth);
            if (newDepth == -1) {
                ++this.size;
                return;
            }
            if (keyBytes.length == newDepth) {
                Node.LeafNode<?> leaf = innerNode.getLeaf();
                leaf.setValue(value);
                return;
            }
            partialKey = keyBytes[newDepth];
            Node child = innerNode.findChild(partialKey);
            if (child == null) break;
            prevDepth = innerNode;
            depth = newDepth + 1;
            node = child;
        }
        Node.LeafNode<V> leaf = new Node.LeafNode<V>(keyBytes, value);
        if (innerNode.isFull()) {
            innerNode = innerNode.grow();
            this.replace(depth, keyBytes, prevDepth, innerNode);
        }
        innerNode.addChild(partialKey, leaf);
        ++this.size;
    }

    private static <V> Node lazyExpansion(Node.LeafNode<V> leaf, byte[] keyBytes, V value, int depth) {
        int lcp = 0;
        byte[] leafKey = leaf.getKeyBytes();
        int end = Math.min(leafKey.length, keyBytes.length);
        while (depth < end && leafKey[depth] == keyBytes[depth]) {
            ++depth;
            ++lcp;
        }
        if (depth == keyBytes.length && depth == leafKey.length) {
            return leaf;
        }
        Node.Node4 pathCompressedNode = new Node.Node4();
        pathCompressedNode.prefixLen = lcp;
        int pessimisticLcp = Math.min(lcp, 8);
        System.arraycopy(keyBytes, depth - lcp, pathCompressedNode.prefixKeys, 0, pessimisticLcp);
        Node.LeafNode<V> newLeaf = new Node.LeafNode<V>(keyBytes, value);
        if (depth == keyBytes.length) {
            pathCompressedNode.setLeaf(newLeaf);
            pathCompressedNode.addChild(leafKey[depth], leaf);
        } else if (depth == leafKey.length) {
            pathCompressedNode.setLeaf(leaf);
            pathCompressedNode.addChild(keyBytes[depth], newLeaf);
        } else {
            pathCompressedNode.addChild(leafKey[depth], leaf);
            pathCompressedNode.addChild(keyBytes[depth], newLeaf);
        }
        return pathCompressedNode;
    }

    static void removeOptimisticLCPFromCompressedPath(Node.InnerNode node, int depth, int lcp, byte[] leafBytes) {
        node.prefixLen = node.prefixLen - lcp - 1;
        int end = Math.min(8, node.prefixLen);
        System.arraycopy(leafBytes, depth + 1, node.prefixKeys, 0, end);
    }

    static void removePessimisticLCPFromCompressedPath(Node.InnerNode node, int depth, int lcp) {
        if (node.prefixLen <= 8) {
            node.prefixLen = node.prefixLen - lcp - 1;
            System.arraycopy(node.prefixKeys, lcp + 1, node.prefixKeys, 0, node.prefixLen);
        } else {
            node.prefixLen = node.prefixLen - lcp - 1;
            byte[] leafBytes = AdaptiveRadixTree.getFirstEntry(node).getKeyBytes();
            int end = Math.min(8, node.prefixLen);
            System.arraycopy(leafBytes, depth + 1, node.prefixKeys, 0, end);
        }
    }

    private int matchCompressedPath(Node.InnerNode node, byte[] keyBytes, V value, int depth, @Nullable Node.InnerNode prevDepth) {
        Node.InnerNode newNode;
        int lcp = 0;
        int end = Math.min(keyBytes.length - depth, Math.min(node.prefixLen, 8));
        while (lcp < end && keyBytes[depth] == node.prefixKeys[lcp]) {
            ++lcp;
            ++depth;
        }
        if (lcp == node.prefixLen) {
            if (depth == keyBytes.length && !node.hasLeaf()) {
                Node.LeafNode<V> leafNode = new Node.LeafNode<V>(keyBytes, value);
                node.setLeaf(leafNode);
                return -1;
            }
            return depth;
        }
        if (lcp == 8) {
            byte[] leafBytes = AdaptiveRadixTree.getFirstEntry(node).getKeyBytes();
            int leftToMatch = node.prefixLen - 8;
            end = Math.min(keyBytes.length, depth + leftToMatch);
            while (depth < end && keyBytes[depth] == leafBytes[depth]) {
                ++depth;
                ++lcp;
            }
            if (lcp == node.prefixLen) {
                if (depth == keyBytes.length && !node.hasLeaf()) {
                    Node.LeafNode<V> leafNode = new Node.LeafNode<V>(keyBytes, value);
                    node.setLeaf(leafNode);
                    return -1;
                }
                return depth;
            }
            newNode = AdaptiveRadixTree.branchOutOptimistic(node, keyBytes, value, lcp, depth, leafBytes);
        } else {
            newNode = AdaptiveRadixTree.branchOutPessimistic(node, keyBytes, value, lcp, depth);
        }
        this.replace(depth - lcp, keyBytes, prevDepth, newNode);
        return -1;
    }

    static <V> Node.InnerNode branchOutOptimistic(Node.InnerNode node, byte[] keyBytes, V value, int lcp, int depth, byte[] leafBytes) {
        int initialDepth = depth - lcp;
        Node.LeafNode<V> leafNode = new Node.LeafNode<V>(keyBytes, value);
        Node.Node4 branchOut = new Node.Node4();
        branchOut.prefixLen = lcp;
        System.arraycopy(keyBytes, initialDepth, branchOut.prefixKeys, 0, 8);
        if (depth == keyBytes.length) {
            branchOut.setLeaf(leafNode);
        } else {
            branchOut.addChild(keyBytes[depth], leafNode);
        }
        branchOut.addChild(leafBytes[depth], node);
        AdaptiveRadixTree.removeOptimisticLCPFromCompressedPath(node, depth, lcp, leafBytes);
        return branchOut;
    }

    static <V> Node.InnerNode branchOutPessimistic(Node.InnerNode node, byte[] keyBytes, V value, int lcp, int depth) {
        int initialDepth = depth - lcp;
        Node.LeafNode<V> leafNode = new Node.LeafNode<V>(keyBytes, value);
        Node.Node4 branchOut = new Node.Node4();
        branchOut.prefixLen = lcp;
        System.arraycopy(keyBytes, initialDepth, branchOut.prefixKeys, 0, lcp);
        if (depth == keyBytes.length) {
            branchOut.setLeaf(leafNode);
        } else {
            branchOut.addChild(keyBytes[depth], leafNode);
        }
        branchOut.addChild(node.prefixKeys[lcp], node);
        AdaptiveRadixTree.removePessimisticLCPFromCompressedPath(node, depth, lcp);
        return branchOut;
    }

    private static <V> Node.LeafNode<V> getFirstEntry(Node startFrom) {
        Node node = startFrom;
        Node next = node.firstOrLeaf();
        while (next != null) {
            node = next;
            next = node.firstOrLeaf();
        }
        return (Node.LeafNode)node;
    }

    public int size() {
        return this.size;
    }

    static abstract class Node {
        static final int BYTE_SHIFT = 128;

        Node() {
        }

        static byte unsigned(byte b) {
            return (byte)(b ^ 0x80);
        }

        static byte signed(byte b) {
            return Node.unsigned(b);
        }

        abstract @Nullable Node first();

        abstract @Nullable Node firstOrLeaf();

        abstract Node copy();

        static class Node256
        extends InnerNode {
            static final int NODE_SIZE = 256;

            Node256(Node48 node) {
                super(node, 256);
                byte[] keyIndex = node.getKeyIndex();
                Node[] child = node.getChild();
                for (int i = 0; i < 256; ++i) {
                    byte index = keyIndex[i];
                    if (index == -1) continue;
                    this.child[i] = child[index];
                }
            }

            private Node256(Node256 from) {
                super(from);
            }

            @Override
            Node copy() {
                return new Node256(this);
            }

            @Override
            public @Nullable Node findChild(byte partialKey) {
                int index = Byte.toUnsignedInt(partialKey);
                return this.child[index];
            }

            @Override
            public void addChild(byte partialKey, Node child) {
                int index = Byte.toUnsignedInt(partialKey);
                this.child[index] = child;
                this.noOfChildren = (short)(this.noOfChildren + 1);
            }

            @Override
            public void replace(byte partialKey, Node newChild) {
                int index = Byte.toUnsignedInt(partialKey);
                this.child[index] = newChild;
            }

            @Override
            public InnerNode grow() {
                throw new UnsupportedOperationException("Span of ART is 8 bits, so Node256 is the largest node type.");
            }

            @Override
            public @Nullable Node first() {
                int i = 0;
                while (this.child[i] == null) {
                    ++i;
                }
                return this.child[i];
            }

            @Override
            public boolean isFull() {
                return this.noOfChildren == 256;
            }
        }

        static class Node48
        extends InnerNode {
            static final int NODE_SIZE = 48;
            static final int KEY_INDEX_SIZE = 256;
            private final byte[] keyIndex = new byte[256];
            static final byte ABSENT = -1;

            Node48(Node16 node) {
                super(node, 48);
                Arrays.fill(this.keyIndex, (byte)-1);
                byte[] keys = node.getKeys();
                Node[] child = node.getChild();
                for (int i = 0; i < 16; ++i) {
                    byte key = Node48.signed(keys[i]);
                    int index = Byte.toUnsignedInt(key);
                    this.keyIndex[index] = (byte)i;
                    this.child[i] = child[i];
                }
            }

            private Node48(Node48 from) {
                super(from);
                System.arraycopy(from.keyIndex, 0, this.keyIndex, 0, 256);
            }

            @Override
            Node copy() {
                return new Node48(this);
            }

            @Override
            public @Nullable Node findChild(byte partialKey) {
                byte index = this.keyIndex[Byte.toUnsignedInt(partialKey)];
                if (index == -1) {
                    return null;
                }
                return this.child[index];
            }

            @Override
            public void addChild(byte partialKey, Node child) {
                int insertPosition;
                int index = Byte.toUnsignedInt(partialKey);
                for (insertPosition = 0; this.child[insertPosition] != null && insertPosition < 48; insertPosition = (int)((byte)(insertPosition + 1))) {
                }
                this.child[insertPosition] = child;
                this.keyIndex[index] = insertPosition;
                this.noOfChildren = (short)(this.noOfChildren + 1);
            }

            @Override
            public void replace(byte partialKey, Node newChild) {
                byte index = this.keyIndex[Byte.toUnsignedInt(partialKey)];
                this.child[index] = newChild;
            }

            @Override
            public InnerNode grow() {
                return new Node256(this);
            }

            @Override
            public @Nullable Node first() {
                int i = 0;
                while (this.keyIndex[i] == -1) {
                    ++i;
                }
                return this.child[this.keyIndex[i]];
            }

            @Override
            public boolean isFull() {
                return this.noOfChildren == 48;
            }

            byte[] getKeyIndex() {
                return this.keyIndex;
            }
        }

        static class Node16
        extends InnerNode {
            static final int NODE_SIZE = 16;
            private final byte[] keys = new byte[16];

            Node16(Node4 node) {
                super(node, 16);
                byte[] keys = node.getKeys();
                Node[] child = node.getChild();
                System.arraycopy(keys, 0, this.keys, 0, node.noOfChildren);
                System.arraycopy(child, 0, this.child, 0, node.noOfChildren);
            }

            private Node16(Node16 from) {
                super(from);
                System.arraycopy(from.keys, 0, this.keys, 0, 16);
            }

            @Override
            Node copy() {
                return new Node16(this);
            }

            @Override
            public @Nullable Node findChild(byte partialKey) {
                partialKey = Node16.unsigned(partialKey);
                for (int i = 0; i < this.noOfChildren; ++i) {
                    if (this.keys[i] != partialKey) continue;
                    return this.child[i];
                }
                return null;
            }

            @Override
            public void addChild(byte partialKey, Node child) {
                byte unsignedPartialKey = Node16.unsigned(partialKey);
                int index = Arrays.binarySearch(this.keys, 0, (int)this.noOfChildren, unsignedPartialKey);
                int insertionPoint = -(index + 1);
                for (int i = this.noOfChildren; i > insertionPoint; --i) {
                    this.keys[i] = this.keys[i - 1];
                    this.child[i] = this.child[i - 1];
                }
                this.keys[insertionPoint] = unsignedPartialKey;
                this.child[insertionPoint] = child;
                this.noOfChildren = (short)(this.noOfChildren + 1);
            }

            @Override
            public void replace(byte partialKey, Node newChild) {
                byte unsignedPartialKey = Node16.unsigned(partialKey);
                int index = Arrays.binarySearch(this.keys, 0, (int)this.noOfChildren, unsignedPartialKey);
                this.child[index] = newChild;
            }

            @Override
            public InnerNode grow() {
                return new Node48(this);
            }

            @Override
            public @Nullable Node first() {
                return this.child[0];
            }

            @Override
            public boolean isFull() {
                return this.noOfChildren == 16;
            }

            byte[] getKeys() {
                return this.keys;
            }
        }

        static class Node4
        extends InnerNode {
            static final int NODE_SIZE = 4;
            private final byte[] keys = new byte[4];

            Node4() {
                super(4);
            }

            private Node4(Node4 node4) {
                super(node4);
            }

            @Override
            Node copy() {
                return new Node4(this);
            }

            @Override
            public @Nullable Node findChild(byte partialKey) {
                partialKey = Node4.unsigned(partialKey);
                for (int i = 0; i < this.noOfChildren; ++i) {
                    if (this.keys[i] != partialKey) continue;
                    return this.child[i];
                }
                return null;
            }

            @Override
            public void addChild(byte partialKey, Node child) {
                byte unsignedPartialKey = Node4.unsigned(partialKey);
                for (int i = this.noOfChildren; i > 0 && unsignedPartialKey < this.keys[i - 1]; --i) {
                    this.keys[i] = this.keys[i - 1];
                    this.child[i] = this.child[i - 1];
                }
                this.keys[i] = unsignedPartialKey;
                this.child[i] = child;
                this.noOfChildren = (short)(this.noOfChildren + 1);
            }

            @Override
            public void replace(byte partialKey, Node newChild) {
                byte unsignedPartialKey = Node4.unsigned(partialKey);
                for (int index = 0; index < this.noOfChildren && this.keys[index] != unsignedPartialKey; ++index) {
                }
                this.child[index] = newChild;
            }

            @Override
            public InnerNode grow() {
                return new Node16(this);
            }

            @Override
            public @Nullable Node first() {
                return this.child[0];
            }

            @Override
            public boolean isFull() {
                return this.noOfChildren == 4;
            }

            byte[] getKeys() {
                return this.keys;
            }
        }

        static class LeafNode<V>
        extends Node {
            private V value;
            private final byte[] keyBytes;

            LeafNode(byte[] keyBytes, V value) {
                this.value = value;
                this.keyBytes = Arrays.copyOf(keyBytes, keyBytes.length);
            }

            @Override
            Node copy() {
                return new LeafNode<V>(this.keyBytes, this.value);
            }

            public void setValue(V value) {
                this.value = value;
            }

            public V getValue() {
                return this.value;
            }

            byte[] getKeyBytes() {
                return this.keyBytes;
            }

            @Override
            public @Nullable Node first() {
                return null;
            }

            @Override
            public @Nullable Node firstOrLeaf() {
                return null;
            }

            public String toString() {
                return Arrays.toString(this.keyBytes) + "=" + this.value;
            }
        }

        static abstract class InnerNode
        extends Node {
            static final int PESSIMISTIC_PATH_COMPRESSION_LIMIT = 8;
            final byte[] prefixKeys = new byte[8];
            int prefixLen;
            short noOfChildren;
            final Node @Nullable [] child;

            InnerNode(int size) {
                this.child = new Node[size + 1];
            }

            InnerNode(InnerNode node, int size) {
                this.child = new Node[size + 1];
                this.noOfChildren = node.noOfChildren;
                this.prefixLen = node.prefixLen;
                System.arraycopy(node.prefixKeys, 0, this.prefixKeys, 0, 8);
                LeafNode<?> leaf = node.getLeaf();
                if (leaf != null) {
                    this.setLeaf(leaf);
                }
            }

            public InnerNode(InnerNode from) {
                System.arraycopy(from.prefixKeys, 0, this.prefixKeys, 0, 8);
                this.prefixLen = from.prefixLen;
                this.noOfChildren = from.noOfChildren;
                this.child = new Node[from.child.length];
                for (int i = 0; i < this.child.length; ++i) {
                    Node fromChild = from.child[i];
                    this.child[i] = fromChild == null ? null : fromChild.copy();
                }
            }

            public void setLeaf(LeafNode<?> leaf) {
                this.child[this.child.length - 1] = leaf;
            }

            public boolean hasLeaf() {
                return this.child[this.child.length - 1] != null;
            }

            public @Nullable LeafNode<?> getLeaf() {
                return (LeafNode)this.child[this.child.length - 1];
            }

            @Override
            public @Nullable Node firstOrLeaf() {
                return this.hasLeaf() ? this.getLeaf() : this.first();
            }

            Node[] getChild() {
                return this.child;
            }

            public short size() {
                return this.noOfChildren;
            }

            abstract @Nullable Node findChild(byte var1);

            abstract void addChild(byte var1, Node var2);

            abstract void replace(byte var1, Node var2);

            abstract InnerNode grow();

            abstract boolean isFull();
        }
    }
}

