/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Objects;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markup;
import org.openrewrite.table.ParseFailures;

public final class FindParseFailures
extends Recipe {
    @Option(displayName="Max snippet length", description="When the failure occurs on a granular tree element, its source code will be included as a column in the data table up to this maximum snippet length.", required=false)
    private final @org.jspecify.annotations.Nullable Integer maxSnippetLength;
    @Option(displayName="Parser type", description="Only display failures from parsers with this fully qualified name.", required=false, example="org.openrewrite.yaml.YamlParser")
    private final @org.jspecify.annotations.Nullable String parserType;
    @Option(example="RuntimeException", displayName="Stack trace", description="Only mark stack traces with a message containing this text.", required=false)
    private final @org.jspecify.annotations.Nullable String stackTrace;
    private final transient ParseFailures failures = new ParseFailures(this);

    @Override
    public String getDisplayName() {
        return "Find source files with `ParseExceptionResult` markers";
    }

    @Override
    public String getDescription() {
        return "This recipe explores parse failures after an LST is produced for classifying the types of failures that can occur and prioritizing fixes according to the most common problems.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree postVisit(Tree tree, ExecutionContext ctx) {
                return tree.getMarkers().findFirst(ParseExceptionResult.class).map(exceptionResult -> {
                    String snippet;
                    if (FindParseFailures.this.parserType != null && !Objects.equals(exceptionResult.getParserType(), FindParseFailures.this.parserType)) {
                        return tree;
                    }
                    if (FindParseFailures.this.stackTrace != null && !exceptionResult.getMessage().contains(FindParseFailures.this.stackTrace)) {
                        return tree;
                    }
                    String string = snippet = tree instanceof SourceFile ? null : tree.printTrimmed(this.getCursor());
                    if (snippet != null && FindParseFailures.this.maxSnippetLength != null && snippet.length() > FindParseFailures.this.maxSnippetLength) {
                        snippet = snippet.substring(0, FindParseFailures.this.maxSnippetLength);
                    }
                    FindParseFailures.this.failures.insertRow(ctx, new ParseFailures.Row(exceptionResult.getParserType(), (tree instanceof SourceFile ? (SourceFile)tree : this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), exceptionResult.getExceptionType(), exceptionResult.getTreeType(), snippet, exceptionResult.getMessage()));
                    return Markup.info(tree, exceptionResult.getMessage());
                }).orElse(tree);
            }
        };
    }

    @Generated
    public FindParseFailures(@org.jspecify.annotations.Nullable Integer maxSnippetLength, @org.jspecify.annotations.Nullable String parserType, @org.jspecify.annotations.Nullable String stackTrace) {
        this.maxSnippetLength = maxSnippetLength;
        this.parserType = parserType;
        this.stackTrace = stackTrace;
    }

    @Generated
    public @org.jspecify.annotations.Nullable Integer getMaxSnippetLength() {
        return this.maxSnippetLength;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getParserType() {
        return this.parserType;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getStackTrace() {
        return this.stackTrace;
    }

    @Generated
    public ParseFailures getFailures() {
        return this.failures;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindParseFailures(maxSnippetLength=" + this.getMaxSnippetLength() + ", parserType=" + this.getParserType() + ", stackTrace=" + this.getStackTrace() + ", failures=" + this.getFailures() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindParseFailures)) {
            return false;
        }
        FindParseFailures other = (FindParseFailures)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxSnippetLength = this.getMaxSnippetLength();
        Integer other$maxSnippetLength = other.getMaxSnippetLength();
        if (this$maxSnippetLength == null ? other$maxSnippetLength != null : !((Object)this$maxSnippetLength).equals(other$maxSnippetLength)) {
            return false;
        }
        String this$parserType = this.getParserType();
        String other$parserType = other.getParserType();
        if (this$parserType == null ? other$parserType != null : !this$parserType.equals(other$parserType)) {
            return false;
        }
        String this$stackTrace = this.getStackTrace();
        String other$stackTrace = other.getStackTrace();
        return !(this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindParseFailures;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxSnippetLength = this.getMaxSnippetLength();
        result = result * 59 + ($maxSnippetLength == null ? 43 : ((Object)$maxSnippetLength).hashCode());
        String $parserType = this.getParserType();
        result = result * 59 + ($parserType == null ? 43 : $parserType.hashCode());
        String $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
        return result;
    }
}

