/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Recipe;
import org.openrewrite.config.DataTableDescriptor;

public class CompositeRecipe
extends Recipe {
    private final List<Recipe> recipeList;

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return "A recipe that consists of a list of other recipes.";
    }

    @Override
    public Duration getEstimatedEffortPerOccurrence() {
        return null;
    }

    @Override
    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    @Override
    public List<DataTableDescriptor> getDataTableDescriptors() {
        List<DataTableDescriptor> dataTableDescriptors = null;
        for (Recipe recipe : this.getRecipeList()) {
            List<DataTableDescriptor> dtds = recipe.getDataTableDescriptors();
            if (dtds.isEmpty()) continue;
            if (dataTableDescriptors == null) {
                dataTableDescriptors = new ArrayList<DataTableDescriptor>();
            }
            for (DataTableDescriptor dtd : dtds) {
                if (dataTableDescriptors.contains(dtd)) continue;
                dataTableDescriptors.add(dtd);
            }
        }
        return dataTableDescriptors == null ? super.getDataTableDescriptors() : dataTableDescriptors;
    }

    @Generated
    public CompositeRecipe(List<Recipe> recipeList) {
        this.recipeList = recipeList;
    }
}

