/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jgit.transport.URIish;

public final class GitRemote {
    private final Service service;
    private final String url;
    private final String origin;
    private final String path;
    private final @org.jspecify.annotations.Nullable String organization;
    private final String repositoryName;

    @Generated
    public GitRemote(Service service, String url, String origin, String path, @org.jspecify.annotations.Nullable String organization, String repositoryName) {
        this.service = service;
        this.url = url;
        this.origin = origin;
        this.path = path;
        this.organization = organization;
        this.repositoryName = repositoryName;
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getOrganization() {
        return this.organization;
    }

    @Generated
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitRemote)) {
            return false;
        }
        GitRemote other = (GitRemote)o;
        Service this$service = this.getService();
        Service other$service = other.getService();
        if (this$service == null ? other$service != null : !((Object)((Object)this$service)).equals((Object)other$service)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$organization = this.getOrganization();
        String other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$repositoryName = this.getRepositoryName();
        String other$repositoryName = other.getRepositoryName();
        return !(this$repositoryName == null ? other$repositoryName != null : !this$repositoryName.equals(other$repositoryName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Service $service = this.getService();
        result = result * 59 + ($service == null ? 43 : ((Object)((Object)$service)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $repositoryName = this.getRepositoryName();
        result = result * 59 + ($repositoryName == null ? 43 : $repositoryName.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GitRemote(service=" + (Object)((Object)this.getService()) + ", url=" + this.getUrl() + ", origin=" + this.getOrigin() + ", path=" + this.getPath() + ", organization=" + this.getOrganization() + ", repositoryName=" + this.getRepositoryName() + ")";
    }

    public static enum Service {
        GitHub,
        GitLab,
        Bitbucket,
        BitbucketCloud,
        AzureDevOps,
        Unknown;

    }

    public static class Parser {
        private final List<RemoteServer> servers = new ArrayList<RemoteServer>();
        private static final Set<String> ALLOWED_PROTOCOLS = new HashSet<String>(Arrays.asList("ssh", "http", "https"));
        private static final Pattern PORT_PATTERN = Pattern.compile(":\\d+");

        public Parser() {
            this.servers.add(new RemoteServer(Service.GitHub, "github.com", URI.create("https://github.com"), URI.create("ssh://git@github.com")));
            this.servers.add(new RemoteServer(Service.GitLab, "gitlab.com", URI.create("https://gitlab.com"), URI.create("ssh://git@gitlab.com")));
            this.servers.add(new RemoteServer(Service.BitbucketCloud, "bitbucket.org", URI.create("https://bitbucket.org"), URI.create("ssh://git@bitbucket.org")));
            this.servers.add(new RemoteServer(Service.AzureDevOps, "dev.azure.com", URI.create("https://dev.azure.com"), URI.create("ssh://git@ssh.dev.azure.com")));
        }

        public URI toUri(GitRemote remote, String protocol) {
            URI selectedBaseUrl;
            if (!ALLOWED_PROTOCOLS.contains(protocol)) {
                throw new IllegalArgumentException("Invalid protocol: " + protocol + ". Must be one of: " + ALLOWED_PROTOCOLS);
            }
            if (remote.service == Service.Unknown) {
                if (PORT_PATTERN.matcher(remote.origin).find()) {
                    throw new IllegalArgumentException("Unable to determine protocol/port combination for an unregistered origin with a port: " + remote.origin);
                }
                selectedBaseUrl = URI.create(protocol + "://" + Parser.stripProtocol(remote.origin));
            } else {
                selectedBaseUrl = this.servers.stream().filter(server -> server.allOrigins().contains(Parser.stripProtocol(remote.origin))).flatMap(server -> server.getUris().stream()).filter(uri -> uri.getScheme().equals(protocol)).findFirst().orElseGet(() -> {
                    URI normalizedUri = Parser.normalize(remote.origin);
                    if (!normalizedUri.getScheme().equals(protocol)) {
                        throw new IllegalStateException("No matching server found that supports ssh for origin: " + remote.origin);
                    }
                    return normalizedUri;
                });
            }
            String path = remote.path.replaceFirst("^/", "");
            boolean ssh = protocol.equals("ssh");
            switch (remote.service) {
                case Bitbucket: {
                    if (ssh) break;
                    path = "scm/" + remote.path;
                    break;
                }
                case AzureDevOps: {
                    path = ssh ? "v3/" + remote.path : remote.path.replaceFirst("([^/]+)/([^/]+)/(.*)", "$1/$2/_git/$3");
                }
            }
            if (remote.service != Service.AzureDevOps) {
                path = path + ".git";
            }
            String maybeSlash = selectedBaseUrl.toString().endsWith("/") ? "" : "/";
            return URI.create(selectedBaseUrl + maybeSlash + path);
        }

        private static String stripProtocol(String origin) {
            return origin.replaceFirst("^\\w+://", "");
        }

        public Parser registerRemote(Service service, URI remoteUri, Collection<URI> alternateUris) {
            URI normalizedUri = Parser.normalize(remoteUri.toString());
            String maybePort = Parser.maybePort(remoteUri.getPort(), remoteUri.getScheme());
            String origin = normalizedUri.getHost() + maybePort + normalizedUri.getPath();
            ArrayList<URI> allUris = new ArrayList<URI>();
            allUris.add(remoteUri);
            allUris.addAll(alternateUris);
            this.add(new RemoteServer(service, origin, allUris));
            return this;
        }

        public Parser registerRemote(Service service, String origin) {
            URI normalizedUri = Parser.normalize(origin);
            String maybePort = Parser.maybePort(normalizedUri.getPort(), normalizedUri.getScheme());
            String normalizedOrigin = normalizedUri.getHost() + maybePort + normalizedUri.getPath();
            this.add(new RemoteServer(service, normalizedOrigin, Parser.normalize(origin)));
            return this;
        }

        private void add(RemoteServer server) {
            if (server.service != Service.Unknown || this.servers.stream().noneMatch(s -> ((RemoteServer)s).origin.equals(server.origin))) {
                this.servers.add(server);
            }
        }

        public GitRemote parse(String url) {
            String repositoryName;
            URI normalizedUri = Parser.normalize(url);
            RemoteServerMatch match = this.matchRemoteServer(normalizedUri);
            String repositoryPath = this.repositoryPath(match, normalizedUri);
            switch (match.service) {
                case AzureDevOps: {
                    if (match.matchedUri.getHost().equals("ssh.dev.azure.com")) {
                        repositoryPath = repositoryPath.replaceFirst("v3/", "");
                        break;
                    }
                    repositoryPath = repositoryPath.replaceFirst("/_git/", "/");
                    break;
                }
                case Bitbucket: {
                    if (!url.startsWith("http")) break;
                    repositoryPath = repositoryPath.replaceFirst("scm/", "");
                }
            }
            String organization = null;
            if (repositoryPath.contains("/")) {
                organization = repositoryPath.substring(0, repositoryPath.lastIndexOf("/"));
                repositoryName = repositoryPath.substring(repositoryPath.lastIndexOf("/") + 1);
            } else {
                repositoryName = repositoryPath;
            }
            return new GitRemote(match.service, url, match.origin, repositoryPath, organization, repositoryName);
        }

        private @org.jspecify.annotations.NonNull RemoteServerMatch matchRemoteServer(URI normalizedUri) {
            return this.servers.stream().map(server -> ((RemoteServer)server).match(normalizedUri)).filter(Objects::nonNull).findFirst().orElseGet(() -> {
                String[] segments = normalizedUri.getPath().split("/");
                String origin = normalizedUri.getHost() + Parser.maybePort(normalizedUri.getPort(), normalizedUri.getScheme());
                if (segments.length > 2) {
                    origin = origin + Arrays.stream(segments, 0, segments.length - 2).collect(Collectors.joining("/"));
                }
                return new RemoteServerMatch(Service.Unknown, origin, URI.create(normalizedUri.getScheme() + "://" + origin));
            });
        }

        private String repositoryPath(RemoteServerMatch match, URI normalizedUri) {
            URI origin = match.matchedUri;
            String uri = normalizedUri.toString();
            String contextPath = origin.getPath();
            String path = normalizedUri.getPath();
            if (!normalizedUri.getHost().equals(origin.getHost()) || normalizedUri.getPort() != origin.getPort() || !path.startsWith(contextPath)) {
                throw new IllegalArgumentException("Origin: " + origin + " does not match the clone url: " + uri);
            }
            return path.substring(contextPath.length()).replaceFirst("^/", "");
        }

        static URI normalize(String url) {
            try {
                URIish uri = new URIish(url);
                String scheme = uri.getScheme();
                String host = uri.getHost();
                if (host == null) {
                    if (scheme == null) {
                        scheme = url.contains(":") ? "ssh" : "https";
                        uri = new URIish(scheme + "://" + url);
                        host = uri.getHost();
                    } else if (!"file".equals(scheme)) {
                        throw new IllegalStateException("No host found in URL " + url);
                    }
                }
                if (scheme == null) {
                    if (PORT_PATTERN.matcher(url).find()) {
                        throw new IllegalArgumentException("Unable to normalize URL: Specifying a port without a scheme is not supported for URL " + url);
                    }
                    scheme = url.contains(":") ? "ssh" : "https";
                }
                String maybePort = Parser.maybePort(uri.getPort(), scheme);
                String path = uri.getPath().replaceFirst("/$", "").replaceFirst("\\.git$", "").replaceFirst("^/", "");
                return URI.create((scheme + "://" + host + maybePort + "/" + path).replaceFirst("/$", ""));
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Unable to parse origin from: " + url, e);
            }
        }

        private static String maybePort(int port, String scheme) {
            if (Parser.isDefaultPort(port, scheme)) {
                return "";
            }
            return ":" + port;
        }

        private static boolean isDefaultPort(int port, String scheme) {
            return port < 1 || "https".equals(scheme) && port == 443 || "http".equals(scheme) && port == 80 || "ssh".equals(scheme) && port == 22;
        }

        private static final class RemoteServer {
            private final Service service;
            private final String origin;
            private final List<URI> uris = new ArrayList<URI>();

            public RemoteServer(Service service, String origin, URI ... uris) {
                this(service, origin, Arrays.asList(uris));
            }

            public RemoteServer(Service service, String origin, Collection<URI> uris) {
                this.service = service;
                this.origin = origin;
                this.uris.addAll(uris);
            }

            private @org.jspecify.annotations.Nullable RemoteServerMatch match(URI normalizedUri) {
                for (URI uri : this.uris) {
                    if (!normalizedUri.toString().startsWith(Parser.normalize(uri.toString()).toString())) continue;
                    return new RemoteServerMatch(this.service, this.origin, uri);
                }
                return null;
            }

            public Set<String> allOrigins() {
                LinkedHashSet<String> origins = new LinkedHashSet<String>();
                origins.add(this.origin);
                for (URI uri : this.uris) {
                    URI normalized = Parser.normalize(uri.toString());
                    origins.add(Parser.stripProtocol(normalized.toString()));
                }
                return origins;
            }

            @Generated
            public Service getService() {
                return this.service;
            }

            @Generated
            public String getOrigin() {
                return this.origin;
            }

            @Generated
            public List<URI> getUris() {
                return this.uris;
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RemoteServer)) {
                    return false;
                }
                RemoteServer other = (RemoteServer)o;
                Service this$service = this.getService();
                Service other$service = other.getService();
                if (this$service == null ? other$service != null : !((Object)((Object)this$service)).equals((Object)other$service)) {
                    return false;
                }
                String this$origin = this.getOrigin();
                String other$origin = other.getOrigin();
                if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                    return false;
                }
                List<URI> this$uris = this.getUris();
                List<URI> other$uris = other.getUris();
                return !(this$uris == null ? other$uris != null : !((Object)this$uris).equals(other$uris));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Service $service = this.getService();
                result = result * 59 + ($service == null ? 43 : ((Object)((Object)$service)).hashCode());
                String $origin = this.getOrigin();
                result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
                List<URI> $uris = this.getUris();
                result = result * 59 + ($uris == null ? 43 : ((Object)$uris).hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "GitRemote.Parser.RemoteServer(service=" + (Object)((Object)this.getService()) + ", origin=" + this.getOrigin() + ", uris=" + this.getUris() + ")";
            }
        }

        private static final class RemoteServerMatch {
            private final Service service;
            private final String origin;
            private final URI matchedUri;

            @Generated
            public RemoteServerMatch(Service service, String origin, URI matchedUri) {
                this.service = service;
                this.origin = origin;
                this.matchedUri = matchedUri;
            }

            @Generated
            public Service getService() {
                return this.service;
            }

            @Generated
            public String getOrigin() {
                return this.origin;
            }

            @Generated
            public URI getMatchedUri() {
                return this.matchedUri;
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RemoteServerMatch)) {
                    return false;
                }
                RemoteServerMatch other = (RemoteServerMatch)o;
                Service this$service = this.getService();
                Service other$service = other.getService();
                if (this$service == null ? other$service != null : !((Object)((Object)this$service)).equals((Object)other$service)) {
                    return false;
                }
                String this$origin = this.getOrigin();
                String other$origin = other.getOrigin();
                if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                    return false;
                }
                URI this$matchedUri = this.getMatchedUri();
                URI other$matchedUri = other.getMatchedUri();
                return !(this$matchedUri == null ? other$matchedUri != null : !((Object)this$matchedUri).equals(other$matchedUri));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Service $service = this.getService();
                result = result * 59 + ($service == null ? 43 : ((Object)((Object)$service)).hashCode());
                String $origin = this.getOrigin();
                result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
                URI $matchedUri = this.getMatchedUri();
                result = result * 59 + ($matchedUri == null ? 43 : ((Object)$matchedUri).hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "GitRemote.Parser.RemoteServerMatch(service=" + (Object)((Object)this.getService()) + ", origin=" + this.getOrigin() + ", matchedUri=" + this.getMatchedUri() + ")";
            }
        }
    }
}

