/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jgit.transport.URIish;

public final class GitRemote {
    private final Service service;
    private final String url;
    private final String origin;
    private final String path;
    @Nullable
    private final String organization;
    private final String repositoryName;

    @Generated
    public GitRemote(Service service, String url, String origin, String path, @Nullable String organization, String repositoryName) {
        this.service = service;
        this.url = url;
        this.origin = origin;
        this.path = path;
        this.organization = organization;
        this.repositoryName = repositoryName;
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Nullable
    @Generated
    public String getOrganization() {
        return this.organization;
    }

    @Generated
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitRemote)) {
            return false;
        }
        GitRemote other = (GitRemote)o;
        Service this$service = this.getService();
        Service other$service = other.getService();
        if (this$service == null ? other$service != null : !((Object)((Object)this$service)).equals((Object)other$service)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$organization = this.getOrganization();
        String other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$repositoryName = this.getRepositoryName();
        String other$repositoryName = other.getRepositoryName();
        return !(this$repositoryName == null ? other$repositoryName != null : !this$repositoryName.equals(other$repositoryName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Service $service = this.getService();
        result = result * 59 + ($service == null ? 43 : ((Object)((Object)$service)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $repositoryName = this.getRepositoryName();
        result = result * 59 + ($repositoryName == null ? 43 : $repositoryName.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GitRemote(service=" + (Object)((Object)this.getService()) + ", url=" + this.getUrl() + ", origin=" + this.getOrigin() + ", path=" + this.getPath() + ", organization=" + this.getOrganization() + ", repositoryName=" + this.getRepositoryName() + ")";
    }

    public static enum Service {
        GitHub,
        GitLab,
        Bitbucket,
        BitbucketCloud,
        AzureDevOps,
        Unknown;

    }

    public static class Parser {
        private final Map<String, Service> origins = new LinkedHashMap<String, Service>();

        public Parser() {
            this.origins.put("github.com", Service.GitHub);
            this.origins.put("gitlab.com", Service.GitLab);
            this.origins.put("bitbucket.org", Service.BitbucketCloud);
            this.origins.put("dev.azure.com", Service.AzureDevOps);
            this.origins.put("ssh.dev.azure.com", Service.AzureDevOps);
        }

        public Parser registerRemote(Service service, String origin) {
            if (origin.startsWith("https://") || origin.startsWith("http://") || origin.startsWith("ssh://")) {
                origin = new HostAndPath(origin).concat();
            }
            if (origin.contains("@")) {
                origin = new HostAndPath("https://" + origin).concat();
            }
            if (service == Service.Unknown) {
                this.origins.putIfAbsent(origin, service);
            } else {
                this.origins.put(origin, service);
            }
            return this;
        }

        public GitRemote parse(String url) {
            String repositoryName;
            Service service;
            HostAndPath hostAndPath = new HostAndPath(url);
            String origin = hostAndPath.host;
            if (hostAndPath.port > 0) {
                origin = origin + ':' + hostAndPath.port;
            }
            if ((service = this.origins.get(origin)) == null) {
                for (String maybeOrigin : this.origins.keySet()) {
                    if (!hostAndPath.concat().startsWith(maybeOrigin)) continue;
                    service = this.origins.get(maybeOrigin);
                    origin = maybeOrigin;
                    break;
                }
            }
            if (service == null) {
                service = Service.Unknown;
                String hostPath = hostAndPath.concat();
                String[] segments = hostPath.split("/");
                origin = segments.length <= 2 ? null : Arrays.stream(segments, 0, segments.length - 2).collect(Collectors.joining("/"));
            }
            String repositoryPath = hostAndPath.repositoryPath(origin);
            switch (service) {
                case AzureDevOps: {
                    if (origin.equals("ssh.dev.azure.com")) {
                        origin = "dev.azure.com";
                        repositoryPath = repositoryPath.replaceFirst("v3/", "");
                        break;
                    }
                    repositoryPath = repositoryPath.replaceFirst("/_git/", "/");
                    break;
                }
                case Bitbucket: {
                    if (!url.startsWith("http")) break;
                    repositoryPath = repositoryPath.replaceFirst("scm/", "");
                }
            }
            String organization = null;
            if (repositoryPath.contains("/")) {
                organization = repositoryPath.substring(0, repositoryPath.lastIndexOf("/"));
                repositoryName = repositoryPath.substring(repositoryPath.lastIndexOf("/") + 1);
            } else {
                repositoryName = repositoryPath;
            }
            return new GitRemote(service, url, origin, repositoryPath, organization, repositoryName);
        }

        private static class HostAndPath {
            String scheme;
            String host;
            int port;
            String path;

            public HostAndPath(String url) {
                try {
                    URIish uri = new URIish(url);
                    this.scheme = uri.getScheme();
                    this.host = uri.getHost();
                    this.port = uri.getPort();
                    if (this.host == null && !"file".equals(this.scheme)) {
                        throw new IllegalStateException("No host in url: " + url);
                    }
                    this.path = uri.getPath().replaceFirst("/$", "").replaceFirst(".git$", "").replaceFirst("^/", "");
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("Unable to parse origin from: " + url, e);
                }
            }

            private String concat() {
                StringBuilder builder = new StringBuilder(64);
                if (this.host != null) {
                    builder.append(this.host);
                }
                if (!this.isDefaultPort()) {
                    builder.append(':').append(this.port);
                }
                if (!this.path.isEmpty()) {
                    if (builder.length() != 0) {
                        builder.append('/');
                    }
                    builder.append(this.path);
                }
                return builder.toString();
            }

            private boolean isDefaultPort() {
                return this.port < 1 || "https".equals(this.scheme) && this.port == 443 || "http".equals(this.scheme) && this.port == 80 || "ssh".equals(this.scheme) && this.port == 22;
            }

            private String repositoryPath(@Nullable String origin) {
                String hostAndPath;
                if (origin == null) {
                    origin = "";
                }
                if (!(hostAndPath = this.concat()).startsWith(origin)) {
                    throw new IllegalArgumentException("Unable to find origin '" + origin + "' in '" + hostAndPath + "'");
                }
                return hostAndPath.substring(origin.length()).replaceFirst("^/", "");
            }
        }
    }
}

