/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.openrewrite.Changeset;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.RecipesThatMadeChanges;

public class InMemoryLargeSourceSet
implements LargeSourceSet {
    @Nullable
    private final InMemoryLargeSourceSet initialState;
    private final List<SourceFile> ls;
    @Nullable
    private Map<SourceFile, List<Recipe>> deletions;
    private List<Recipe> currentRecipeStack;

    public InMemoryLargeSourceSet(List<SourceFile> ls) {
        this(null, null, ls);
    }

    protected InMemoryLargeSourceSet(@Nullable InMemoryLargeSourceSet initialState, @Nullable Map<SourceFile, List<Recipe>> deletions, List<SourceFile> ls) {
        this.initialState = initialState;
        this.ls = ls;
        this.deletions = deletions;
    }

    protected InMemoryLargeSourceSet withChanges(@Nullable Map<SourceFile, List<Recipe>> deletions, List<SourceFile> mapped) {
        return new InMemoryLargeSourceSet(this.getInitialState(), deletions, mapped);
    }

    @Override
    public void setRecipe(List<Recipe> recipeStack) {
        this.currentRecipeStack = recipeStack;
    }

    @Override
    public LargeSourceSet edit(UnaryOperator<SourceFile> map) {
        List<SourceFile> mapped = ListUtils.map(this.ls, before -> {
            SourceFile after = (SourceFile)map.apply((SourceFile)before);
            if (after == null) {
                if (this.deletions == null) {
                    this.deletions = new LinkedHashMap<SourceFile, List<Recipe>>();
                }
                this.deletions.put((SourceFile)before, this.currentRecipeStack);
            }
            return after;
        });
        return mapped != this.ls ? this.withChanges(this.deletions, mapped) : this;
    }

    @Override
    public LargeSourceSet generate(@Nullable Collection<? extends SourceFile> t) {
        if (t == null || t.isEmpty()) {
            return this;
        }
        if (this.ls.isEmpty()) {
            return this.withChanges(this.deletions, (List)t);
        }
        ArrayList<SourceFile> newLs = new ArrayList<SourceFile>(this.ls);
        newLs.addAll(t);
        return this.withChanges(this.deletions, newLs);
    }

    protected InMemoryLargeSourceSet getInitialState() {
        return this.initialState == null ? this : this.initialState;
    }

    @Override
    public Changeset getChangeset() {
        HashMap<UUID, SourceFile> sourceFileIdentities = new HashMap<UUID, SourceFile>();
        for (SourceFile sourceFile : this.getInitialState().ls) {
            sourceFileIdentities.put(sourceFile.getId(), sourceFile);
        }
        ArrayList<Result> changes = new ArrayList<Result>();
        for (SourceFile sourceFile : this.ls) {
            SourceFile original = (SourceFile)sourceFileIdentities.get(sourceFile.getId());
            if (original == sourceFile) continue;
            if (original != null) {
                if (original.getMarkers().findFirst(org.openrewrite.marker.Generated.class).isPresent()) continue;
                changes.add(new Result(original, sourceFile));
                continue;
            }
            Collection recipes = sourceFile.getMarkers().findFirst(RecipesThatMadeChanges.class).map(RecipesThatMadeChanges::getRecipes).orElse(Collections.emptyList());
            changes.add(new Result(null, sourceFile, recipes));
        }
        if (this.deletions != null) {
            for (Map.Entry entry : this.deletions.entrySet()) {
                changes.add(new Result((SourceFile)entry.getKey(), null, Collections.singleton((List)entry.getValue())));
            }
        }
        return new InMemoryChangeset(changes);
    }

    @Override
    @Nullable
    public SourceFile getBefore(Path sourcePath) {
        List<SourceFile> sourceFiles = this.getInitialState().ls;
        for (SourceFile s : sourceFiles) {
            if (!s.getSourcePath().equals(sourcePath)) continue;
            return s;
        }
        return null;
    }

    private static class InMemoryChangeset
    implements Changeset {
        final List<Result> change;

        @Override
        public int size() {
            return this.change.size();
        }

        @Override
        public List<Result> getPage(int start, int count) {
            return this.change.subList(start, Math.min(this.change.size(), start + count));
        }

        @Override
        public List<Result> getAllResults() {
            return this.change;
        }

        @Generated
        public InMemoryChangeset(List<Result> change) {
            this.change = change;
        }
    }
}

