/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Contributor;
import org.openrewrite.Maintainer;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeException;
import org.openrewrite.RecipeSerializer;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DeclarativeNamedStyles;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlResourceLoader
implements ResourceLoader {
    int refCount = 0;
    private static final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}", ":");
    private final URI source;
    private final String yamlSource;
    private final ObjectMapper mapper;
    @Nullable
    private final ClassLoader classLoader;
    private final Collection<? extends ResourceLoader> dependencyResourceLoaders;
    @Nullable
    private Map<String, List<Contributor>> contributors;
    @Nullable
    private Map<String, List<RecipeExample>> recipeNameToExamples;

    public YamlResourceLoader(InputStream yamlInput, URI source, Properties properties) throws UncheckedIOException {
        this(yamlInput, source, properties, null);
    }

    public YamlResourceLoader(InputStream yamlInput, URI source, Properties properties, @Nullable ClassLoader classLoader) throws UncheckedIOException {
        this(yamlInput, source, properties, classLoader, Collections.emptyList());
    }

    public YamlResourceLoader(InputStream yamlInput, URI source, Properties properties, @Nullable ClassLoader classLoader, Collection<? extends ResourceLoader> dependencyResourceLoaders) throws UncheckedIOException {
        this.source = source;
        this.dependencyResourceLoaders = dependencyResourceLoaders;
        this.mapper = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        RecipeSerializer.maybeAddKotlinModule(this.mapper);
        this.classLoader = classLoader;
        if (classLoader != null) {
            TypeFactory tf = TypeFactory.defaultInstance().withClassLoader(classLoader);
            this.mapper.setTypeFactory(tf);
        }
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = yamlInput.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            this.yamlSource = propertyPlaceholderHelper.replacePlaceholders(new String(buffer.toByteArray(), StandardCharsets.UTF_8), properties);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Collection<Map<String, Object>> loadResources(ResourceType resourceType) {
        ArrayList<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        for (Object resource : yaml.loadAll(this.yamlSource)) {
            Map resourceMap;
            if (!(resource instanceof Map) || !resourceType.equals((Object)ResourceType.fromSpec((String)(resourceMap = (Map)resource).get("type")))) continue;
            resources.add(resourceMap);
        }
        return resources;
    }

    @Override
    public Collection<Recipe> listRecipes() {
        Collection<Map<String, Object>> resources = this.loadResources(ResourceType.Recipe);
        ArrayList<Recipe> recipes = new ArrayList<Recipe>(resources.size());
        Map<String, List<Contributor>> contributors = this.listContributors();
        for (Map<String, Object> r : resources) {
            List<Maintainer> maintainers;
            List rawMaintainers;
            if (!r.containsKey("name")) continue;
            String name = (String)r.get("name");
            String displayName = (String)r.get("displayName");
            if (displayName == null) {
                displayName = name;
            }
            String description = (String)r.get("description");
            Set<String> tags = Collections.emptySet();
            List rawTags = (List)r.get("tags");
            if (rawTags != null) {
                tags = new HashSet(rawTags);
            }
            String estimatedEffortPerOccurrenceStr = (String)r.get("estimatedEffortPerOccurrence");
            Duration estimatedEffortPerOccurrence = null;
            if (estimatedEffortPerOccurrenceStr != null) {
                estimatedEffortPerOccurrence = Duration.parse(estimatedEffortPerOccurrenceStr);
            }
            if ((rawMaintainers = r.getOrDefault("maintainers", Collections.emptyList())).isEmpty()) {
                maintainers = Collections.emptyList();
            } else {
                maintainers = new ArrayList(rawMaintainers.size());
                for (Object rawMaintainer : rawMaintainers) {
                    if (!(rawMaintainer instanceof Map)) continue;
                    Map maintainerMap = (Map)rawMaintainer;
                    String maintainerName = (String)maintainerMap.get("maintainer");
                    String logoString = (String)maintainerMap.get("logo");
                    URI logo = logoString == null ? null : URI.create(logoString);
                    maintainers.add(new Maintainer(maintainerName, logo));
                }
            }
            DeclarativeRecipe recipe = new DeclarativeRecipe(name, displayName, description, tags, estimatedEffortPerOccurrence, this.source, (Boolean)r.getOrDefault("causesAnotherCycle", false), maintainers);
            List recipeList = (List)r.get("recipeList");
            if (recipeList == null) {
                throw new RecipeException("Invalid Recipe [" + name + "] recipeList is null");
            }
            for (int i = 0; i < recipeList.size(); ++i) {
                this.loadRecipe(name, i, recipeList.get(i), recipe::addUninitialized, recipe::addUninitialized, recipe::addValidation);
            }
            List preconditions = (List)r.get("preconditions");
            if (preconditions != null) {
                for (int i = 0; i < preconditions.size(); ++i) {
                    this.loadRecipe(name, i, preconditions.get(i), recipe::addUninitializedPrecondition, recipe::addUninitializedPrecondition, recipe::addValidation);
                }
            }
            recipe.setContributors(contributors.get(recipe.getName()));
            recipes.add(recipe);
        }
        return recipes;
    }

    void loadRecipe(@Language(value="markdown") String name, int i, Object recipeData, Consumer<String> addLazyLoadRecipe, Consumer<Recipe> addRecipe, Consumer<Validated<Object>> addValidation) {
        block16: {
            if (recipeData instanceof String) {
                String recipeName = (String)recipeData;
                try {
                    addRecipe.accept((Recipe)Class.forName(recipeName, true, this.classLoader == null ? this.getClass().getClassLoader() : this.classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException e) {
                    try {
                        addRecipe.accept(this.instantiateRecipe(recipeName, new HashMap<String, Object>()));
                    }
                    catch (IllegalArgumentException ignored) {
                        addLazyLoadRecipe.accept(recipeName);
                    }
                }
                catch (NoClassDefFoundError e) {
                    this.addInvalidRecipeValidation(addValidation, recipeName, null, "Recipe class " + recipeName + " cannot be found");
                }
            } else if (recipeData instanceof Map) {
                Map.Entry nameAndConfig = ((Map)recipeData).entrySet().iterator().next();
                String recipeName = (String)nameAndConfig.getKey();
                Object recipeArgs = nameAndConfig.getValue();
                try {
                    if (recipeArgs instanceof Map) {
                        try {
                            addRecipe.accept(this.instantiateRecipe(recipeName, (Map)recipeArgs));
                        }
                        catch (IllegalArgumentException e) {
                            if (e.getCause() instanceof InvalidTypeIdException) {
                                this.addInvalidRecipeValidation(addValidation, recipeName, recipeArgs, "Recipe class " + recipeName + " cannot be found");
                                break block16;
                            }
                            this.addInvalidRecipeValidation(addValidation, recipeName, recipeArgs, "Unable to load Recipe: " + e);
                        }
                        catch (NoClassDefFoundError e) {
                            this.addInvalidRecipeValidation(addValidation, recipeName, recipeArgs, "Recipe class " + (String)nameAndConfig.getKey() + " cannot be found");
                        }
                        break block16;
                    }
                    this.addInvalidRecipeValidation(addValidation, recipeName, recipeArgs, "Declarative recipeList entries are expected to be strings or mappings");
                }
                catch (Exception e) {
                    this.addInvalidRecipeValidation(addValidation, recipeName, recipeArgs, "Unexpected declarative recipe parsing exception " + e.getClass().getName());
                }
            } else {
                addValidation.accept(Validated.invalid(name + ".recipeList[" + i + "] (in " + this.source + ")", recipeData, "is an object type that isn't recognized as a recipe.", null));
            }
        }
    }

    private Recipe instantiateRecipe(String recipeName, Map<String, Object> args) throws IllegalArgumentException {
        HashMap<String, Object> withJsonType = new HashMap<String, Object>(args);
        withJsonType.put("@c", recipeName);
        return (Recipe)this.mapper.convertValue(withJsonType, Recipe.class);
    }

    private void addInvalidRecipeValidation(Consumer<Validated<Object>> addValidation, String recipeName, Object recipeArgs, String message) {
        addValidation.accept(Validated.invalid(recipeName, recipeArgs, message));
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.listRecipeDescriptors(Collections.emptyList(), this.listContributors(), this.listRecipeExamples());
    }

    public Collection<RecipeDescriptor> listRecipeDescriptors(Collection<Recipe> externalRecipes, Map<String, List<Contributor>> recipeNamesToContributors, Map<String, List<RecipeExample>> recipeNamesToExamples) {
        Collection<Recipe> internalRecipes = this.listRecipes();
        Collection allRecipes = Stream.concat(Stream.concat(externalRecipes.stream(), internalRecipes.stream()), this.dependencyResourceLoaders.stream().flatMap(rl -> rl.listRecipes().stream())).collect(Collectors.toList());
        ArrayList<RecipeDescriptor> recipeDescriptors = new ArrayList<RecipeDescriptor>();
        for (Recipe recipe : internalRecipes) {
            DeclarativeRecipe declarativeRecipe = (DeclarativeRecipe)recipe;
            declarativeRecipe.initialize(allRecipes, recipeNamesToContributors);
            declarativeRecipe.setContributors(recipeNamesToContributors.get(recipe.getName()));
            declarativeRecipe.setExamples(recipeNamesToExamples.get(recipe.getName()));
            recipeDescriptors.add(declarativeRecipe.getDescriptor());
        }
        return recipeDescriptors;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.loadResources(ResourceType.Style).stream().filter(r -> r.containsKey("name")).map(s -> {
            ArrayList<Style> styles = new ArrayList<Style>();
            String name = (String)s.get("name");
            String displayName = (String)s.get("displayName");
            if (displayName == null) {
                displayName = name;
            }
            String description = (String)s.get("description");
            Set<String> tags = Collections.emptySet();
            List rawTags = (List)s.get("tags");
            if (rawTags != null) {
                tags = new HashSet(rawTags);
            }
            DeclarativeNamedStyles namedStyles = new DeclarativeNamedStyles(Tree.randomId(), name, displayName, description, tags, styles);
            List styleConfigs = (List)s.get("styleConfigs");
            if (styleConfigs != null) {
                for (int i = 0; i < styleConfigs.size(); ++i) {
                    Object next = styleConfigs.get(i);
                    if (next instanceof String) {
                        String styleClassName = (String)next;
                        try {
                            styles.add((Style)Class.forName(styleClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (Exception e) {
                            namedStyles.addValidation(Validated.invalid(name + ".styleConfigs[" + i + "] (in " + this.source + ")", next, "is a style that cannot be constructed.", e));
                        }
                        continue;
                    }
                    if (next instanceof Map) {
                        Map.Entry nameAndConfig = ((Map)next).entrySet().iterator().next();
                        try {
                            HashMap<String, Object> withJsonType = new HashMap<String, Object>((Map)nameAndConfig.getValue());
                            withJsonType.put("@c", nameAndConfig.getKey());
                            withJsonType.put("@ref", this.refCount++);
                            Style e = (Style)this.mapper.convertValue(withJsonType, Style.class);
                            styles.add(e);
                        }
                        catch (Exception e) {
                            namedStyles.addValidation(Validated.invalid(name + ".styleConfigs[" + i + "] (in " + this.source + ")", next, " encountered an error being loaded as a style.", e));
                        }
                        continue;
                    }
                    namedStyles.addValidation(Validated.invalid(name + ".styleConfigs[" + i + "] (in " + this.source + ")", next, "is an object type that isn't recognized as a style.", null));
                }
            }
            return namedStyles;
        }).collect(Collectors.toList());
    }

    @Override
    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.loadResources(ResourceType.Category).stream().filter(r -> r.containsKey("packageName")).map(c -> {
            String name = (String)c.get("name");
            String packageName = (String)c.get("packageName");
            if (packageName.endsWith(".core") || packageName.contains(".core.")) {
                throw new IllegalArgumentException("The package name 'core' is reserved.");
            }
            if (name == null) {
                name = packageName;
            }
            String description = (String)c.get("description");
            Set<String> tags = Collections.emptySet();
            List rawTags = (List)c.get("tags");
            if (rawTags != null) {
                tags = new HashSet(rawTags);
            }
            boolean root = c.containsKey("root") && (Boolean)c.get("root") != false;
            int priority = c.containsKey("priority") ? (Integer)c.get("priority") : 0;
            return new CategoryDescriptor(name, packageName, description, tags, root, priority, false);
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<RecipeExample>> listRecipeExamples() {
        if (this.recipeNameToExamples == null) {
            this.recipeNameToExamples = new HashMap<String, List<RecipeExample>>();
        }
        Collection<Map<String, Object>> rawExamples = this.loadResources(ResourceType.Example);
        for (Map<String, Object> examplesMap : rawExamples) {
            String recipeName = (String)examplesMap.get("recipeName");
            this.recipeNameToExamples.computeIfAbsent(recipeName, key -> new ArrayList());
            List examples = (List)examplesMap.get("examples");
            List newExamples = examples.stream().map(exam -> {
                RecipeExample recipeExample = new RecipeExample();
                recipeExample.setDescription((String)exam.get("description"));
                if (exam.get("parameters") != null) {
                    recipeExample.setParameters(((List)exam.get("parameters")).stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList()));
                }
                ArrayList<RecipeExample.Source> sources = new ArrayList<RecipeExample.Source>();
                List ss = (List)exam.get("sources");
                if (ss != null) {
                    for (Object s : ss) {
                        HashMap sMap = (HashMap)s;
                        String before = (String)sMap.get("before");
                        String after = (String)sMap.get("after");
                        String path = (String)sMap.get("path");
                        String language = (String)((HashMap)s).get("language");
                        RecipeExample.Source source = new RecipeExample.Source(before, after, path, language);
                        sources.add(source);
                    }
                }
                recipeExample.setSources(sources);
                return recipeExample;
            }).collect(Collectors.toList());
            this.recipeNameToExamples.get(recipeName).addAll(newExamples);
        }
        return this.recipeNameToExamples;
    }

    @Override
    public Map<String, List<Contributor>> listContributors() {
        if (this.contributors == null) {
            Collection<Map<String, Object>> rawAttribution = this.loadResources(ResourceType.Attribution);
            if (rawAttribution.isEmpty()) {
                this.contributors = Collections.emptyMap();
            } else {
                HashMap<String, List<Contributor>> result = new HashMap<String, List<Contributor>>(rawAttribution.size());
                for (Map<String, Object> attribution : rawAttribution) {
                    String recipeName = (String)attribution.get("recipeName");
                    List rawContributors = (List)attribution.get("contributors");
                    ArrayList<Contributor> contributors = new ArrayList<Contributor>(rawContributors.size());
                    for (Map rawContributor : rawContributors) {
                        contributors.add(new Contributor((String)rawContributor.get("name"), (String)rawContributor.get("email"), (Integer)rawContributor.get("lineCount")));
                    }
                    result.put(recipeName, contributors);
                }
                this.contributors = result;
            }
        }
        return this.contributors;
    }

    private static enum ResourceType {
        Recipe("specs.openrewrite.org/v1beta/recipe"),
        Style("specs.openrewrite.org/v1beta/style"),
        Category("specs.openrewrite.org/v1beta/category"),
        Example("specs.openrewrite.org/v1beta/example"),
        Attribution("specs.openrewrite.org/v1beta/attribution");

        private final String spec;

        private ResourceType(String spec) {
            this.spec = spec;
        }

        @Nullable
        public static ResourceType fromSpec(@Nullable String spec) {
            return Arrays.stream(ResourceType.values()).filter(type -> type.getSpec().equals(spec)).findAny().orElse(null);
        }

        @Generated
        public String getSpec() {
            return this.spec;
        }
    }
}

