/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jgit.diff.DiffEntry;
import org.openrewrite.jgit.diff.DiffFormatter;
import org.openrewrite.jgit.diff.RawTextComparator;
import org.openrewrite.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.openrewrite.jgit.internal.storage.dfs.InMemoryRepository;
import org.openrewrite.jgit.lib.AbbreviatedObjectId;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.FileMode;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectInserter;
import org.openrewrite.jgit.lib.Repository;

public class InMemoryDiffEntry
extends DiffEntry
implements AutoCloseable {
    static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId((AnyObjectId)ObjectId.zeroId());
    private final InMemoryRepository repo;
    private final Set<Recipe> recipesThatMadeChanges;

    public InMemoryDiffEntry(@Nullable Path originalFilePath, @Nullable Path filePath, @Nullable Path relativeTo, String oldSource, String newSource, Set<Recipe> recipesThatMadeChanges) {
        this(originalFilePath, filePath, relativeTo, oldSource, newSource, recipesThatMadeChanges, FileMode.REGULAR_FILE, FileMode.REGULAR_FILE);
    }

    public InMemoryDiffEntry(@Nullable Path originalFilePath, @Nullable Path filePath, @Nullable Path relativeTo, String oldSource, String newSource, Set<Recipe> recipesThatMadeChanges, FileMode oldMode, FileMode newMode) {
        this.recipesThatMadeChanges = recipesThatMadeChanges;
        try {
            this.repo = ((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription())).build();
            try (ObjectInserter inserter = this.repo.getObjectDatabase().newInserter();){
                if (originalFilePath != null) {
                    this.oldId = inserter.insert(3, oldSource.getBytes(StandardCharsets.UTF_8)).abbreviate(40);
                    this.oldMode = oldMode;
                    this.oldPath = (relativeTo == null ? originalFilePath : relativeTo.relativize(originalFilePath)).toString().replace("\\", "/");
                } else {
                    this.oldId = A_ZERO;
                    this.oldMode = FileMode.MISSING;
                    this.oldPath = "/dev/null";
                }
                if (filePath != null) {
                    this.newId = inserter.insert(3, newSource.getBytes(StandardCharsets.UTF_8)).abbreviate(40);
                    this.newMode = newMode;
                    this.newPath = (relativeTo == null ? filePath : relativeTo.relativize(filePath)).toString().replace("\\", "/");
                } else {
                    this.newId = A_ZERO;
                    this.newMode = FileMode.MISSING;
                    this.newPath = "/dev/null";
                }
                inserter.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.changeType = this.oldMode == FileMode.MISSING && this.newMode != FileMode.MISSING ? DiffEntry.ChangeType.ADD : (this.oldMode != FileMode.MISSING && this.newMode == FileMode.MISSING ? DiffEntry.ChangeType.DELETE : (!this.oldPath.equals(this.newPath) ? DiffEntry.ChangeType.RENAME : DiffEntry.ChangeType.MODIFY));
    }

    public String getDiff() {
        return this.getDiff(false);
    }

    public String getDiff(@Nullable Boolean ignoreAllWhitespace) {
        if (ignoreAllWhitespace == null) {
            ignoreAllWhitespace = false;
        }
        if (this.oldId.equals((Object)this.newId) && this.oldPath.equals(this.newPath)) {
            return "";
        }
        ByteArrayOutputStream patch = new ByteArrayOutputStream();
        try (DiffFormatter formatter = new DiffFormatter((OutputStream)patch);){
            formatter.setDiffComparator(ignoreAllWhitespace != false ? RawTextComparator.WS_IGNORE_ALL : RawTextComparator.DEFAULT);
            formatter.setRepository((Repository)this.repo);
            formatter.format((DiffEntry)this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String diff = patch.toString();
        AtomicBoolean addedComment = new AtomicBoolean(false);
        return Arrays.stream(diff.split("\n")).map(l -> {
            if (!addedComment.get() && l.startsWith("@@") && l.endsWith("@@")) {
                addedComment.set(true);
                LinkedHashSet<String> sortedRecipeNames = new LinkedHashSet<String>();
                for (Recipe recipesThatMadeChange : this.recipesThatMadeChanges) {
                    sortedRecipeNames.add(recipesThatMadeChange.getName());
                }
                StringJoiner joinedRecipeNames = new StringJoiner(", ", " ", "");
                for (String name : sortedRecipeNames) {
                    joinedRecipeNames.add(name);
                }
                return l + joinedRecipeNames;
            }
            return l;
        }).collect(Collectors.joining("\n")) + "\n";
    }

    @Override
    public void close() {
        this.repo.close();
    }
}

