/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;

public final class JenkinsBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String buildNumber;
    private final String buildId;
    private final String buildUrl;
    private final String host;
    private final String job;
    @Nullable
    private final String localBranch;
    private final String branch;

    public static JenkinsBuildEnvironment build(UnaryOperator<String> environment) {
        return new JenkinsBuildEnvironment(Tree.randomId(), (String)environment.apply("BUILD_NUMBER"), (String)environment.apply("BUILD_ID"), (String)environment.apply("BUILD_URL"), (String)environment.apply("JENKINS_URL"), (String)environment.apply("JOB_NAME"), (String)environment.apply("GIT_LOCAL_BRANCH"), (String)environment.apply("GIT_BRANCH"));
    }

    @Override
    public GitProvenance buildGitProvenance() throws IncompleteGitConfigException {
        throw new IncompleteGitConfigException();
    }

    public JenkinsBuildEnvironment(UUID id, String buildNumber, String buildId, String buildUrl, String host, String job, @Nullable String localBranch, String branch) {
        this.id = id;
        this.buildNumber = buildNumber;
        this.buildId = buildId;
        this.buildUrl = buildUrl;
        this.host = host;
        this.job = job;
        this.localBranch = localBranch;
        this.branch = branch;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getHost() {
        return this.host;
    }

    public String getJob() {
        return this.job;
    }

    @Nullable
    public String getLocalBranch() {
        return this.localBranch;
    }

    public String getBranch() {
        return this.branch;
    }

    @NonNull
    public String toString() {
        return "JenkinsBuildEnvironment(id=" + this.getId() + ", buildNumber=" + this.getBuildNumber() + ", buildId=" + this.getBuildId() + ", buildUrl=" + this.getBuildUrl() + ", host=" + this.getHost() + ", job=" + this.getJob() + ", localBranch=" + this.getLocalBranch() + ", branch=" + this.getBranch() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JenkinsBuildEnvironment)) {
            return false;
        }
        JenkinsBuildEnvironment other = (JenkinsBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$buildNumber = this.getBuildNumber();
        String other$buildNumber = other.getBuildNumber();
        if (this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber)) {
            return false;
        }
        String this$buildId = this.getBuildId();
        String other$buildId = other.getBuildId();
        if (this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId)) {
            return false;
        }
        String this$buildUrl = this.getBuildUrl();
        String other$buildUrl = other.getBuildUrl();
        if (this$buildUrl == null ? other$buildUrl != null : !this$buildUrl.equals(other$buildUrl)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$localBranch = this.getLocalBranch();
        String other$localBranch = other.getLocalBranch();
        if (this$localBranch == null ? other$localBranch != null : !this$localBranch.equals(other$localBranch)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        return !(this$branch == null ? other$branch != null : !this$branch.equals(other$branch));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $buildNumber = this.getBuildNumber();
        result = result * 59 + ($buildNumber == null ? 43 : $buildNumber.hashCode());
        String $buildId = this.getBuildId();
        result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
        String $buildUrl = this.getBuildUrl();
        result = result * 59 + ($buildUrl == null ? 43 : $buildUrl.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $localBranch = this.getLocalBranch();
        result = result * 59 + ($localBranch == null ? 43 : $localBranch.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        return result;
    }

    @NonNull
    public JenkinsBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new JenkinsBuildEnvironment(id, this.buildNumber, this.buildId, this.buildUrl, this.host, this.job, this.localBranch, this.branch);
    }
}

