/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.ipc.http;

import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.lang.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import org.openrewrite.ipc.http.HttpStatusClass;

public interface HttpSender {
    public Response send(Request var1);

    default public Request.Builder post(String uri) {
        return this.newRequest(uri).withMethod(Method.POST);
    }

    default public Request.Builder head(String uri) {
        return this.newRequest(uri).withMethod(Method.HEAD);
    }

    default public Request.Builder put(String uri) {
        return this.newRequest(uri).withMethod(Method.PUT);
    }

    default public Request.Builder get(String uri) {
        return this.newRequest(uri).withMethod(Method.GET);
    }

    default public Request.Builder delete(String uri) {
        return this.newRequest(uri).withMethod(Method.DELETE);
    }

    default public Request.Builder options(String uri) {
        return this.newRequest(uri).withMethod(Method.OPTIONS);
    }

    default public Request.Builder newRequest(String uri) {
        return new Request.Builder(uri, this);
    }

    public static class Request {
        private final URL url;
        private final byte[] entity;
        private final Method method;
        private final Map<String, String> requestHeaders;

        public Request(URL url, byte[] entity, Method method, Map<String, String> requestHeaders) {
            this.url = url;
            this.entity = entity;
            this.method = method;
            this.requestHeaders = requestHeaders;
        }

        public URL getUrl() {
            return this.url;
        }

        public byte[] getEntity() {
            return this.entity;
        }

        public Method getMethod() {
            return this.method;
        }

        public Map<String, String> getRequestHeaders() {
            return this.requestHeaders;
        }

        public static Builder build(String uri, HttpSender sender) {
            return new Builder(uri, sender);
        }

        public String toString() {
            StringBuilder printed = new StringBuilder(this.method.toString()).append(' ').append(this.url.toString()).append("\n");
            if (this.entity.length == 0) {
                printed.append("<no request body>");
            } else {
                printed.append(new String(this.entity));
            }
            return printed.toString();
        }

        public static class Builder {
            private static final String APPLICATION_JSON = "application/json";
            private static final String TEXT_PLAIN = "text/plain";
            private final HttpSender sender;
            private final Map<String, String> requestHeaders = new LinkedHashMap<String, String>();
            private URL url;
            private byte[] entity = new byte[0];
            private Method method;

            Builder(String url, HttpSender sender) {
                try {
                    this.url = URI.create(url).toURL();
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException(e);
                }
                this.sender = sender;
            }

            public final Builder withHeader(String name, String value) {
                this.requestHeaders.put(name, value);
                return this;
            }

            public final Builder withBasicAuthentication(@Nullable String user, @Nullable String password) {
                if (StringUtils.isNotBlank((String)user)) {
                    String encoded = Base64.getEncoder().encodeToString((user.trim() + ":" + (password == null ? "" : password.trim())).getBytes(StandardCharsets.UTF_8));
                    this.withAuthentication("Basic", encoded);
                }
                return this;
            }

            public final Builder withAuthentication(String type, @Nullable String credentials) {
                if (StringUtils.isNotBlank((String)credentials)) {
                    this.withHeader("Authorization", type + " " + credentials);
                }
                return this;
            }

            public final Builder withJsonContent(String content) {
                return this.withContent(APPLICATION_JSON, content);
            }

            public final Builder withPlainText(String content) {
                return this.withContent(TEXT_PLAIN, content);
            }

            public final Builder withContent(String type, String content) {
                return this.withContent(type, content.getBytes(StandardCharsets.UTF_8));
            }

            public final Builder withContent(String type, byte[] content) {
                this.withHeader("Content-Type", type);
                this.entity = content;
                return this;
            }

            public Builder acceptJson() {
                return this.accept(APPLICATION_JSON);
            }

            public Builder accept(String type) {
                return this.withHeader("Accept", type);
            }

            public final Builder withMethod(Method method) {
                this.method = method;
                return this;
            }

            public final Builder compress() throws IOException {
                this.withHeader("Content-Encoding", "gzip");
                this.entity = Builder.gzip(this.entity);
                return this;
            }

            public final Builder compressWhen(Supplier<Boolean> when) throws IOException {
                if (when.get().booleanValue()) {
                    return this.compress();
                }
                return this;
            }

            public final Builder withMultipartFile(File file) throws IOException {
                String boundary = UUID.randomUUID().toString();
                String contentType = "multipart/form-data; boundary=" + boundary;
                byte[] content = this.multipart(boundary, file);
                return this.withContent(contentType, content);
            }

            private byte[] multipart(String boundary, File file) throws IOException {
                int bytesRead;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                String mimeType = Files.probeContentType(file.toPath());
                if (mimeType == null) {
                    mimeType = "application/octet-stream";
                }
                outputStream.write(("--" + boundary + "\r\n").getBytes());
                outputStream.write(("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"\r\n").getBytes());
                outputStream.write(("Content-Type: " + mimeType + "\r\n").getBytes());
                outputStream.write(("\r\n--" + boundary + "--\r\n").getBytes());
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] buffer = new byte[8192];
                while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                fileInputStream.close();
                return outputStream.toByteArray();
            }

            private static byte[] gzip(byte[] data) throws IOException {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
                try (GZIPOutputStream out = new GZIPOutputStream(bos);){
                    out.write(data);
                }
                return bos.toByteArray();
            }

            public final Builder url(String url) {
                try {
                    this.url = URI.create(url).toURL();
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException(e);
                }
                return this;
            }

            public Response send() {
                return this.sender.send(this.build());
            }

            public Request build() {
                return new Request(this.url, this.entity, this.method, this.requestHeaders);
            }
        }
    }

    public static enum Method {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        OPTIONS;

    }

    public static class Response
    implements AutoCloseable {
        private final int code;
        private final InputStream body;
        private final Runnable onClose;

        public Response(int code, @Nullable InputStream body, Runnable onClose) {
            this.code = code;
            this.body = body;
            this.onClose = onClose;
        }

        public int getCode() {
            return this.code;
        }

        public InputStream getBody() {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return body == null ? 0 : body.read();
                }

                @Override
                public void close() throws IOException {
                    if (body != null) {
                        body.close();
                    }
                    onClose.run();
                }
            };
        }

        public byte[] getBodyAsBytes() {
            byte[] byArray;
            block10: {
                if (this.body == null) {
                    return new byte[0];
                }
                InputStream is = this.getBody();
                try {
                    int nRead;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    byte[] data = new byte[4];
                    while ((nRead = is.read(data, 0, data.length)) != -1) {
                        buffer.write(data, 0, nRead);
                    }
                    buffer.flush();
                    byArray = buffer.toByteArray();
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                is.close();
            }
            return byArray;
        }

        public Response onSuccess(Consumer<Response> onSuccess) {
            switch (HttpStatusClass.valueOf(this.code)) {
                case INFORMATIONAL: 
                case SUCCESS: {
                    onSuccess.accept(this);
                }
            }
            return this;
        }

        public Response onError(Consumer<Response> onError) {
            switch (HttpStatusClass.valueOf(this.code)) {
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    onError.accept(this);
                }
            }
            return this;
        }

        public boolean isSuccessful() {
            switch (HttpStatusClass.valueOf(this.code)) {
                case INFORMATIONAL: 
                case SUCCESS: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void close() {
            this.onClose.run();
        }
    }
}

