/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class FindAndReplace
extends Recipe {
    @Option(displayName="Find", description="The text to find (and replace).", example="blacklist")
    private final String find;
    @Option(displayName="Replace", description="The replacement text for `find`.", example="denylist")
    private final String replace;
    @Option(displayName="Regex", description="Default false. If true, `find` will be interpreted as a Regular Expression, and capture group contents will be available in `replace`.", required=false)
    @Nullable
    private final Boolean regex;
    @Option(displayName="Case sensitive", description="If `true` the search will be sensitive to case. Default `false`.", required=false)
    @Nullable
    private final Boolean caseSensitive;
    @Option(displayName="Regex multiline mode", description="When performing a regex search setting this to `true` allows \"^\" and \"$\" to match the beginning and end of lines, respectively. When performing a regex search when this is `false` \"^\" and \"$\" will match only the beginning and ending of the entire source file, respectively.Has no effect when not performing a regex search. Default `false`.", required=false)
    @Nullable
    private final Boolean multiline;
    @Option(displayName="Regex dot all", description="When performing a regex search setting this to `true` allows \".\" to match line terminators.Has no effect when not performing a regex search. Default `false`.", required=false)
    @Nullable
    private final Boolean dotAll;
    @Option(displayName="File pattern", description="A glob expression that can be used to constrain which directories or source files should be searched. Multiple patterns may be specified, separated by a semicolon `;`. If multiple patterns are supplied any of the patterns matching will be interpreted as a match. When not set, all source files are searched. ", example="**/*.java")
    @Nullable
    private final String filePattern;

    @Override
    public String getDisplayName() {
        return "Find and replace";
    }

    @Override
    public String getDescription() {
        return "Simple text find and replace. When the original source file is a language-specific Lossless Semantic Tree, this operation irreversibly converts the source file to a plain text file. Subsequent recipes will not be able to operate on language-specific type.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor<Tree, ExecutionContext> visitor = new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                if (sourceFile.getMarkers().findFirst(AlreadyReplaced.class).isPresent()) {
                    return sourceFile;
                }
                String searchStr = FindAndReplace.this.find;
                if (!Boolean.TRUE.equals(FindAndReplace.this.regex)) {
                    searchStr = Pattern.quote(searchStr);
                }
                int patternOptions = 0;
                if (!Boolean.TRUE.equals(FindAndReplace.this.caseSensitive)) {
                    patternOptions |= 2;
                }
                if (Boolean.TRUE.equals(FindAndReplace.this.multiline)) {
                    patternOptions |= 8;
                }
                if (Boolean.TRUE.equals(FindAndReplace.this.dotAll)) {
                    patternOptions |= 0x20;
                }
                PlainText plainText = PlainTextParser.convert(sourceFile);
                Pattern pattern = Pattern.compile(searchStr, patternOptions);
                Matcher matcher = pattern.matcher(plainText.getText());
                if (!matcher.find()) {
                    return sourceFile;
                }
                String newText = matcher.replaceAll(FindAndReplace.this.replace);
                return plainText.withText(newText).withMarkers(sourceFile.getMarkers().add(new AlreadyReplaced(Tree.randomId())));
            }
        };
        if (this.filePattern != null) {
            TreeVisitor<?, ExecutionContext> check = Preconditions.or((TreeVisitor[])Arrays.stream(this.filePattern.split(";")).map(HasSourcePath::new).toArray(TreeVisitor[]::new));
            visitor = Preconditions.check(check, visitor);
        }
        return visitor;
    }

    public FindAndReplace(String find, String replace, @Nullable Boolean regex, @Nullable Boolean caseSensitive, @Nullable Boolean multiline, @Nullable Boolean dotAll, @Nullable String filePattern) {
        this.find = find;
        this.replace = replace;
        this.regex = regex;
        this.caseSensitive = caseSensitive;
        this.multiline = multiline;
        this.dotAll = dotAll;
        this.filePattern = filePattern;
    }

    public String getFind() {
        return this.find;
    }

    public String getReplace() {
        return this.replace;
    }

    @Nullable
    public Boolean getRegex() {
        return this.regex;
    }

    @Nullable
    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Nullable
    public Boolean getMultiline() {
        return this.multiline;
    }

    @Nullable
    public Boolean getDotAll() {
        return this.dotAll;
    }

    @Nullable
    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    public String toString() {
        return "FindAndReplace(find=" + this.getFind() + ", replace=" + this.getReplace() + ", regex=" + this.getRegex() + ", caseSensitive=" + this.getCaseSensitive() + ", multiline=" + this.getMultiline() + ", dotAll=" + this.getDotAll() + ", filePattern=" + this.getFilePattern() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAndReplace)) {
            return false;
        }
        FindAndReplace other = (FindAndReplace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        Boolean this$caseSensitive = this.getCaseSensitive();
        Boolean other$caseSensitive = other.getCaseSensitive();
        if (this$caseSensitive == null ? other$caseSensitive != null : !((Object)this$caseSensitive).equals(other$caseSensitive)) {
            return false;
        }
        Boolean this$multiline = this.getMultiline();
        Boolean other$multiline = other.getMultiline();
        if (this$multiline == null ? other$multiline != null : !((Object)this$multiline).equals(other$multiline)) {
            return false;
        }
        Boolean this$dotAll = this.getDotAll();
        Boolean other$dotAll = other.getDotAll();
        if (this$dotAll == null ? other$dotAll != null : !((Object)this$dotAll).equals(other$dotAll)) {
            return false;
        }
        String this$find = this.getFind();
        String other$find = other.getFind();
        if (this$find == null ? other$find != null : !this$find.equals(other$find)) {
            return false;
        }
        String this$replace = this.getReplace();
        String other$replace = other.getReplace();
        if (this$replace == null ? other$replace != null : !this$replace.equals(other$replace)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindAndReplace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        Boolean $caseSensitive = this.getCaseSensitive();
        result = result * 59 + ($caseSensitive == null ? 43 : ((Object)$caseSensitive).hashCode());
        Boolean $multiline = this.getMultiline();
        result = result * 59 + ($multiline == null ? 43 : ((Object)$multiline).hashCode());
        Boolean $dotAll = this.getDotAll();
        result = result * 59 + ($dotAll == null ? 43 : ((Object)$dotAll).hashCode());
        String $find = this.getFind();
        result = result * 59 + ($find == null ? 43 : $find.hashCode());
        String $replace = this.getReplace();
        result = result * 59 + ($replace == null ? 43 : $replace.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }

    static final class AlreadyReplaced
    implements Marker {
        private final UUID id;

        public AlreadyReplaced(UUID id) {
            this.id = id;
        }

        @Override
        public UUID getId() {
            return this.id;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlreadyReplaced)) {
                return false;
            }
            AlreadyReplaced other = (AlreadyReplaced)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "FindAndReplace.AlreadyReplaced(id=" + this.getId() + ")";
        }

        @NonNull
        public AlreadyReplaced withId(UUID id) {
            return this.id == id ? this : new AlreadyReplaced(id);
        }
    }
}

