/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;

public class HasSourcePath<P>
extends TreeVisitor<Tree, P> {
    private final String syntax;
    private final String filePattern;

    public HasSourcePath(@Nullable String filePattern) {
        this("glob", filePattern);
    }

    public HasSourcePath(String syntax, @Nullable String filePattern) {
        this.syntax = syntax;
        this.filePattern = filePattern;
    }

    @Override
    @Nullable
    public Tree preVisit(Tree tree, P p) {
        this.stopAfterPreVisit();
        if (StringUtils.isBlank(this.filePattern)) {
            return SearchResult.found(tree, "has file");
        }
        if (tree instanceof SourceFile) {
            SourceFile sourceFile = (SourceFile)tree;
            Path sourcePath = "glob".equals(this.syntax) && this.filePattern.startsWith("**") ? Paths.get(".", new String[0]).resolve(sourceFile.getSourcePath().normalize()) : sourceFile.getSourcePath().normalize();
            PathMatcher pathMatcher = sourcePath.getFileSystem().getPathMatcher(this.syntax + ":" + this.filePattern);
            if (pathMatcher.matches(sourcePath)) {
                return SearchResult.found(sourceFile, "has file");
            }
        }
        return tree;
    }
}

