/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.Collections;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;

public final class CircleCiBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String buildId;
    private final String buildUrl;
    private final String host;
    private final String job;
    private final String branch;
    private final String repositoryURL;
    private final String sha1;
    private final String tag;

    public static CircleCiBuildEnvironment build(UnaryOperator<String> environment) {
        return new CircleCiBuildEnvironment(Tree.randomId(), (String)environment.apply("CIRCLE_BUILD_NUM"), (String)environment.apply("CIRCLE_BUILD_URL"), OperatingSystemProvenance.hostname(), (String)environment.apply("CIRCLE_JOB"), (String)environment.apply("CIRCLE_BRANCH"), (String)environment.apply("CIRCLE_REPOSITORY_URL"), (String)environment.apply("CIRCLE_SHA1"), (String)environment.apply("CIRCLE_TAG"));
    }

    @Override
    public GitProvenance buildGitProvenance() throws IncompleteGitConfigException {
        if (StringUtils.isBlank(this.repositoryURL) || StringUtils.isBlank(this.sha1) || StringUtils.isBlank(this.branch) && StringUtils.isBlank(this.tag)) {
            throw new IncompleteGitConfigException();
        }
        return new GitProvenance(UUID.randomUUID(), this.repositoryURL, StringUtils.isBlank(this.branch) ? this.tag : this.branch, this.sha1, null, null, Collections.emptyList());
    }

    public CircleCiBuildEnvironment(UUID id, String buildId, String buildUrl, String host, String job, String branch, String repositoryURL, String sha1, String tag) {
        this.id = id;
        this.buildId = buildId;
        this.buildUrl = buildUrl;
        this.host = host;
        this.job = job;
        this.branch = branch;
        this.repositoryURL = repositoryURL;
        this.sha1 = sha1;
        this.tag = tag;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getHost() {
        return this.host;
    }

    public String getJob() {
        return this.job;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getTag() {
        return this.tag;
    }

    @NonNull
    public String toString() {
        return "CircleCiBuildEnvironment(id=" + this.getId() + ", buildId=" + this.getBuildId() + ", buildUrl=" + this.getBuildUrl() + ", host=" + this.getHost() + ", job=" + this.getJob() + ", branch=" + this.getBranch() + ", repositoryURL=" + this.getRepositoryURL() + ", sha1=" + this.getSha1() + ", tag=" + this.getTag() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CircleCiBuildEnvironment)) {
            return false;
        }
        CircleCiBuildEnvironment other = (CircleCiBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$buildId = this.getBuildId();
        String other$buildId = other.getBuildId();
        if (this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId)) {
            return false;
        }
        String this$buildUrl = this.getBuildUrl();
        String other$buildUrl = other.getBuildUrl();
        if (this$buildUrl == null ? other$buildUrl != null : !this$buildUrl.equals(other$buildUrl)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$repositoryURL = this.getRepositoryURL();
        String other$repositoryURL = other.getRepositoryURL();
        if (this$repositoryURL == null ? other$repositoryURL != null : !this$repositoryURL.equals(other$repositoryURL)) {
            return false;
        }
        String this$sha1 = this.getSha1();
        String other$sha1 = other.getSha1();
        if (this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $buildId = this.getBuildId();
        result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
        String $buildUrl = this.getBuildUrl();
        result = result * 59 + ($buildUrl == null ? 43 : $buildUrl.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $repositoryURL = this.getRepositoryURL();
        result = result * 59 + ($repositoryURL == null ? 43 : $repositoryURL.hashCode());
        String $sha1 = this.getSha1();
        result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    @NonNull
    public CircleCiBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new CircleCiBuildEnvironment(id, this.buildId, this.buildUrl, this.host, this.job, this.branch, this.repositoryURL, this.sha1, this.tag);
    }
}

