/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.BuildMetadata;
import org.openrewrite.marker.SearchResult;

public final class FindBuildMetadata
extends Recipe {
    @Option(displayName="Build metadata key", description="The key to search for in the build metadata.", example="lstFormatVersion")
    private final String key;
    @Option(displayName="Build metadata value", description="The value to search for in the build metadata.", example="2")
    private final String value;

    @Override
    public String getDisplayName() {
        return "Find build metadata";
    }

    @Override
    public String getDescription() {
        return "Find source files with matching build metadata.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    for (BuildMetadata buildMetadata : tree.getMarkers().findAll(BuildMetadata.class)) {
                        if (!buildMetadata.getMetadata().containsKey(FindBuildMetadata.this.key) || !buildMetadata.getMetadata().get(FindBuildMetadata.this.key).equals(FindBuildMetadata.this.value)) continue;
                        return SearchResult.found(tree, "Found build metadata");
                    }
                }
                return tree;
            }
        };
    }

    public FindBuildMetadata(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @NonNull
    public String toString() {
        return "FindBuildMetadata(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindBuildMetadata)) {
            return false;
        }
        FindBuildMetadata other = (FindBuildMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindBuildMetadata;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

