/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Contributor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Maintainer;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class DeclarativeRecipe
extends Recipe {
    private final String name;
    @Language(value="markdown")
    private final String displayName;
    @Language(value="markdown")
    private final String description;
    private final Set<String> tags;
    @Nullable
    private final Duration estimatedEffortPerOccurrence;
    private final URI source;
    private final boolean causesAnotherCycle;
    private final List<Maintainer> maintainers;
    private final List<Recipe> uninitializedRecipes = new ArrayList<Recipe>();
    private List<Recipe> recipeList = new ArrayList<Recipe>();
    private final List<Recipe> uninitializedPreconditions = new ArrayList<Recipe>();
    private List<Recipe> preconditions = new ArrayList<Recipe>();
    @JsonIgnore
    private Validated<Object> validation = Validated.none();
    @JsonIgnore
    private Validated<Object> initValidation = null;

    @Override
    public boolean causesAnotherCycle() {
        return this.causesAnotherCycle || super.causesAnotherCycle();
    }

    public void addPrecondition(Recipe recipe) {
        this.uninitializedPreconditions.add(recipe);
    }

    @Override
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence == null ? super.getEstimatedEffortPerOccurrence() : this.estimatedEffortPerOccurrence;
    }

    public void initialize(Collection<Recipe> availableRecipes, Map<String, List<Contributor>> recipeToContributors) {
        this.initValidation = Validated.none();
        this.initialize(this.uninitializedRecipes, this.recipeList, availableRecipes, recipeToContributors);
        this.initialize(this.uninitializedPreconditions, this.preconditions, availableRecipes, recipeToContributors);
    }

    private void initialize(List<Recipe> uninitialized, List<Recipe> initialized, Collection<Recipe> availableRecipes, Map<String, List<Contributor>> recipeToContributors) {
        initialized.clear();
        for (int i = 0; i < uninitialized.size(); ++i) {
            Recipe recipe = uninitialized.get(i);
            if (recipe instanceof LazyLoadedRecipe) {
                String recipeFqn = ((LazyLoadedRecipe)recipe).getRecipeFqn();
                Optional<Recipe> next = availableRecipes.stream().filter(r -> recipeFqn.equals(r.getName())).findAny();
                if (next.isPresent()) {
                    Recipe subRecipe = next.get();
                    if (subRecipe instanceof DeclarativeRecipe) {
                        ((DeclarativeRecipe)subRecipe).initialize(availableRecipes, recipeToContributors);
                    }
                    initialized.add(subRecipe);
                    continue;
                }
                this.initValidation = this.initValidation.and(Validated.invalid(this.name + ".recipeList[" + i + "] (in " + this.source + ")", recipeFqn, "recipe '" + recipeFqn + "' does not exist.", null));
                continue;
            }
            recipe.setContributors(recipeToContributors.getOrDefault(recipe.getName(), Collections.emptyList()));
            if (recipe instanceof DeclarativeRecipe) {
                ((DeclarativeRecipe)recipe).initialize(availableRecipes, recipeToContributors);
            }
            initialized.add(recipe);
        }
    }

    @Override
    public final List<Recipe> getRecipeList() {
        if (this.preconditions.isEmpty()) {
            return this.recipeList;
        }
        TreeVisitor<?, ExecutionContext> andPreconditions = null;
        for (Recipe precondition : this.preconditions) {
            if (DeclarativeRecipe.isScanningRecipe(precondition)) {
                throw new IllegalArgumentException(this.getName() + " declares the ScanningRecipe " + precondition.getName() + " as a precondition.ScanningRecipe cannot be used as Preconditions.");
            }
            if (andPreconditions == null) {
                andPreconditions = precondition.getVisitor();
                continue;
            }
            andPreconditions = Preconditions.and(andPreconditions, precondition.getVisitor());
        }
        PreconditionBellwether bellwether = new PreconditionBellwether(andPreconditions);
        ArrayList<Recipe> recipeListWithBellwether = new ArrayList<Recipe>(this.recipeList.size() + 1);
        recipeListWithBellwether.add(bellwether);
        recipeListWithBellwether.addAll(DeclarativeRecipe.decorateWithPreconditionBellwether(bellwether, this.recipeList));
        return recipeListWithBellwether;
    }

    private static boolean isScanningRecipe(Recipe recipe) {
        if (recipe instanceof ScanningRecipe) {
            return true;
        }
        for (Recipe r : recipe.getRecipeList()) {
            if (!DeclarativeRecipe.isScanningRecipe(r)) continue;
            return true;
        }
        return false;
    }

    private static List<Recipe> decorateWithPreconditionBellwether(PreconditionBellwether bellwether, List<Recipe> recipeList) {
        ArrayList<Recipe> mappedRecipeList = new ArrayList<Recipe>(recipeList.size());
        for (Recipe recipe : recipeList) {
            if (recipe instanceof ScanningRecipe) {
                mappedRecipeList.add(new BellwetherDecoratedScanningRecipe(bellwether, (ScanningRecipe)recipe));
                continue;
            }
            mappedRecipeList.add(new BellwetherDecoratedRecipe(bellwether, recipe));
        }
        return mappedRecipeList;
    }

    public void addUninitialized(Recipe recipe) {
        this.uninitializedRecipes.add(recipe);
    }

    public void addUninitialized(String recipeName) {
        this.uninitializedRecipes.add(new LazyLoadedRecipe(recipeName));
    }

    public void addUninitializedPrecondition(Recipe recipe) {
        this.uninitializedPreconditions.add(recipe);
    }

    public void addUninitializedPrecondition(String recipeName) {
        this.uninitializedPreconditions.add(new LazyLoadedRecipe(recipeName));
    }

    public void addValidation(Validated<Object> validated) {
        this.validation = this.validation.and(validated);
    }

    @Override
    public Validated<Object> validate() {
        return Validated.test("initialization", "initialize(..) must be called on DeclarativeRecipe prior to use.", this, r -> this.initValidation != null).and(this.validation).and(this.initValidation);
    }

    @Override
    protected RecipeDescriptor createRecipeDescriptor() {
        ArrayList<RecipeDescriptor> recipeList = new ArrayList<RecipeDescriptor>();
        for (Recipe childRecipe : this.getRecipeList()) {
            recipeList.add(childRecipe.getDescriptor());
        }
        return new RecipeDescriptor(this.getName(), this.getDisplayName(), this.getDescription(), this.getTags(), this.getEstimatedEffortPerOccurrence(), Collections.emptyList(), recipeList, this.getDataTableDescriptors(), this.getMaintainers(), this.getContributors(), this.getExamples(), this.source);
    }

    @Override
    public List<Contributor> getContributors() {
        if (this.contributors == null) {
            HashMap<NameEmail, Integer> contributorToLineCount = new HashMap<NameEmail, Integer>();
            this.contributors = new ArrayList();
            for (Recipe recipe : this.getRecipeList()) {
                for (Contributor contributor : recipe.getContributors()) {
                    NameEmail nameEmail = new NameEmail(contributor.getName(), contributor.getEmail());
                    contributorToLineCount.put(nameEmail, contributorToLineCount.getOrDefault(nameEmail, 0) + contributor.getLineCount());
                }
            }
            for (Map.Entry entry : contributorToLineCount.entrySet()) {
                this.contributors.add(new Contributor(((NameEmail)entry.getKey()).getName(), ((NameEmail)entry.getKey()).getEmail(), (Integer)entry.getValue()));
            }
            this.contributors.sort(Comparator.comparing(Contributor::getLineCount).reversed());
        }
        return this.contributors;
    }

    public DeclarativeRecipe(String name, @Language(value="markdown") String displayName, @Language(value="markdown") String description, Set<String> tags, @Nullable Duration estimatedEffortPerOccurrence, URI source, boolean causesAnotherCycle, List<Maintainer> maintainers) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
        this.estimatedEffortPerOccurrence = estimatedEffortPerOccurrence;
        this.source = source;
        this.causesAnotherCycle = causesAnotherCycle;
        this.maintainers = maintainers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Language(value="markdown")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Language(value="markdown")
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public List<Maintainer> getMaintainers() {
        return this.maintainers;
    }

    public void setRecipeList(List<Recipe> recipeList) {
        this.recipeList = recipeList;
    }

    public void setPreconditions(List<Recipe> preconditions) {
        this.preconditions = preconditions;
    }

    static final class PreconditionBellwether
    extends Recipe {
        private final TreeVisitor<?, ExecutionContext> precondition;
        private transient boolean preconditionApplicable;

        @Override
        public String getDisplayName() {
            return "Precondition bellwether";
        }

        @Override
        public String getDescription() {
            return "Evaluates a precondition and makes that result available to the preconditions of other recipes. \"bellwether\", noun - One that serves as a leader or as a leading indicator of future trends. ";
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new TreeVisitor<Tree, ExecutionContext>(){

                @Override
                public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                    return precondition.isAcceptable(sourceFile, ctx);
                }

                @Override
                @Nullable
                public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                    Object t = precondition.visit(tree, ctx);
                    preconditionApplicable = t != tree;
                    return tree;
                }
            };
        }

        public TreeVisitor<?, ExecutionContext> getPrecondition() {
            return this.precondition;
        }

        public boolean isPreconditionApplicable() {
            return this.preconditionApplicable;
        }

        @NonNull
        public String toString() {
            return "DeclarativeRecipe.PreconditionBellwether(precondition=" + this.getPrecondition() + ", preconditionApplicable=" + this.isPreconditionApplicable() + ")";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PreconditionBellwether)) {
                return false;
            }
            PreconditionBellwether other = (PreconditionBellwether)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TreeVisitor<?, ExecutionContext> this$precondition = this.getPrecondition();
            TreeVisitor<?, ExecutionContext> other$precondition = other.getPrecondition();
            return !(this$precondition == null ? other$precondition != null : !this$precondition.equals(other$precondition));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof PreconditionBellwether;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TreeVisitor<?, ExecutionContext> $precondition = this.getPrecondition();
            result = result * 59 + ($precondition == null ? 43 : $precondition.hashCode());
            return result;
        }

        public PreconditionBellwether(TreeVisitor<?, ExecutionContext> precondition) {
            this.precondition = precondition;
        }
    }

    private static final class LazyLoadedRecipe
    extends Recipe {
        private final String recipeFqn;

        @Override
        public String getDisplayName() {
            return "Lazy loaded recipe";
        }

        @Override
        public String getDescription() {
            return "Recipe that is loaded lazily.";
        }

        public LazyLoadedRecipe(String recipeFqn) {
            this.recipeFqn = recipeFqn;
        }

        public String getRecipeFqn() {
            return this.recipeFqn;
        }

        @NonNull
        public String toString() {
            return "DeclarativeRecipe.LazyLoadedRecipe(recipeFqn=" + this.getRecipeFqn() + ")";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LazyLoadedRecipe)) {
                return false;
            }
            LazyLoadedRecipe other = (LazyLoadedRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$recipeFqn = this.getRecipeFqn();
            String other$recipeFqn = other.getRecipeFqn();
            return !(this$recipeFqn == null ? other$recipeFqn != null : !this$recipeFqn.equals(other$recipeFqn));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof LazyLoadedRecipe;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $recipeFqn = this.getRecipeFqn();
            result = result * 59 + ($recipeFqn == null ? 43 : $recipeFqn.hashCode());
            return result;
        }
    }

    static final class BellwetherDecoratedScanningRecipe<T>
    extends ScanningRecipe<T> {
        private final PreconditionBellwether bellwether;
        private final ScanningRecipe<T> delegate;

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public T getInitialValue(ExecutionContext ctx) {
            return this.delegate.getInitialValue(ctx);
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getScanner(T acc) {
            return Preconditions.check(this.bellwether.isPreconditionApplicable(), this.delegate.getScanner(acc));
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor(T acc) {
            return Preconditions.check(this.bellwether.isPreconditionApplicable(), this.delegate.getVisitor(acc));
        }

        @Override
        public List<Recipe> getRecipeList() {
            return DeclarativeRecipe.decorateWithPreconditionBellwether(this.bellwether, this.delegate.getRecipeList());
        }

        public BellwetherDecoratedScanningRecipe(PreconditionBellwether bellwether, ScanningRecipe<T> delegate) {
            this.bellwether = bellwether;
            this.delegate = delegate;
        }

        public PreconditionBellwether getBellwether() {
            return this.bellwether;
        }

        public ScanningRecipe<T> getDelegate() {
            return this.delegate;
        }

        @NonNull
        public String toString() {
            return "DeclarativeRecipe.BellwetherDecoratedScanningRecipe(bellwether=" + this.getBellwether() + ", delegate=" + this.getDelegate() + ")";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BellwetherDecoratedScanningRecipe)) {
                return false;
            }
            BellwetherDecoratedScanningRecipe other = (BellwetherDecoratedScanningRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PreconditionBellwether this$bellwether = this.getBellwether();
            PreconditionBellwether other$bellwether = other.getBellwether();
            if (this$bellwether == null ? other$bellwether != null : !((Object)this$bellwether).equals(other$bellwether)) {
                return false;
            }
            ScanningRecipe<T> this$delegate = this.getDelegate();
            ScanningRecipe<T> other$delegate = other.getDelegate();
            return !(this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof BellwetherDecoratedScanningRecipe;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PreconditionBellwether $bellwether = this.getBellwether();
            result = result * 59 + ($bellwether == null ? 43 : ((Object)$bellwether).hashCode());
            ScanningRecipe<T> $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
            return result;
        }
    }

    static final class BellwetherDecoratedRecipe
    extends Recipe {
        private final PreconditionBellwether bellwether;
        private final Recipe delegate;

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return Preconditions.check(this.bellwether.isPreconditionApplicable(), this.delegate.getVisitor());
        }

        @Override
        public List<Recipe> getRecipeList() {
            return DeclarativeRecipe.decorateWithPreconditionBellwether(this.bellwether, this.delegate.getRecipeList());
        }

        public BellwetherDecoratedRecipe(PreconditionBellwether bellwether, Recipe delegate) {
            this.bellwether = bellwether;
            this.delegate = delegate;
        }

        public PreconditionBellwether getBellwether() {
            return this.bellwether;
        }

        public Recipe getDelegate() {
            return this.delegate;
        }

        @NonNull
        public String toString() {
            return "DeclarativeRecipe.BellwetherDecoratedRecipe(bellwether=" + this.getBellwether() + ", delegate=" + this.getDelegate() + ")";
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BellwetherDecoratedRecipe)) {
                return false;
            }
            BellwetherDecoratedRecipe other = (BellwetherDecoratedRecipe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PreconditionBellwether this$bellwether = this.getBellwether();
            PreconditionBellwether other$bellwether = other.getBellwether();
            if (this$bellwether == null ? other$bellwether != null : !((Object)this$bellwether).equals(other$bellwether)) {
                return false;
            }
            Recipe this$delegate = this.getDelegate();
            Recipe other$delegate = other.getDelegate();
            return !(this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof BellwetherDecoratedRecipe;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PreconditionBellwether $bellwether = this.getBellwether();
            result = result * 59 + ($bellwether == null ? 43 : ((Object)$bellwether).hashCode());
            Recipe $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
            return result;
        }
    }

    private static final class NameEmail {
        private final String name;
        private final String email;

        public NameEmail(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameEmail)) {
                return false;
            }
            NameEmail other = (NameEmail)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            return !(this$email == null ? other$email != null : !this$email.equals(other$email));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "DeclarativeRecipe.NameEmail(name=" + this.getName() + ", email=" + this.getEmail() + ")";
        }
    }
}

