/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.search;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.table.CommitsByDay;
import org.openrewrite.table.DistinctCommitters;

public final class FindCommitters
extends ScanningRecipe<Map<String, GitProvenance.Committer>> {
    private final transient DistinctCommitters committers = new DistinctCommitters(this);
    private final transient CommitsByDay commitsByDay = new CommitsByDay(this);
    @Option(displayName="From date", required=false, description="Optional. Take into account only commits since this date (inclusive). Default will be the entire history.", example="2023-01-01")
    @Nullable
    private final String fromDate;

    @Override
    public String getDisplayName() {
        return "Find committers on repositories";
    }

    @Override
    public String getDescription() {
        return "List the committers on a repository.";
    }

    @Override
    public Map<String, GitProvenance.Committer> getInitialValue(ExecutionContext ctx) {
        return new TreeMap<String, GitProvenance.Committer>();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Map<String, GitProvenance.Committer> acc) {
        final LocalDate from = StringUtils.isBlank(this.fromDate) ? null : LocalDate.parse(this.fromDate).minusDays(1L);
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    sourceFile.getMarkers().findFirst(GitProvenance.class).ifPresent(provenance -> {
                        if (provenance.getCommitters() != null) {
                            for (GitProvenance.Committer committer : provenance.getCommitters()) {
                                if (from != null && !committer.getCommitsByDay().keySet().stream().anyMatch(day -> day.isAfter(from))) continue;
                                acc.put(committer.getEmail(), committer);
                            }
                        }
                    });
                }
                return tree;
            }
        };
    }

    @Override
    public Collection<? extends SourceFile> generate(Map<String, GitProvenance.Committer> acc, ExecutionContext ctx) {
        for (GitProvenance.Committer committer : acc.values()) {
            this.committers.insertRow(ctx, new DistinctCommitters.Row(committer.getName(), committer.getEmail(), (LocalDate)committer.getCommitsByDay().lastKey(), committer.getCommitsByDay().values().stream().mapToInt(Integer::intValue).sum()));
            committer.getCommitsByDay().forEach((day, commits) -> this.commitsByDay.insertRow(ctx, new CommitsByDay.Row(committer.getName(), committer.getEmail(), (LocalDate)day, (int)commits)));
        }
        return Collections.emptyList();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(final Map<String, GitProvenance.Committer> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    return SearchResult.found(tree, String.join((CharSequence)"\n", acc.keySet()));
                }
                return tree;
            }
        };
    }

    public FindCommitters(@Nullable String fromDate) {
        this.fromDate = fromDate;
    }

    public DistinctCommitters getCommitters() {
        return this.committers;
    }

    public CommitsByDay getCommitsByDay() {
        return this.commitsByDay;
    }

    @Nullable
    public String getFromDate() {
        return this.fromDate;
    }

    @NonNull
    public String toString() {
        return "FindCommitters(committers=" + this.getCommitters() + ", commitsByDay=" + this.getCommitsByDay() + ", fromDate=" + this.getFromDate() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCommitters)) {
            return false;
        }
        FindCommitters other = (FindCommitters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fromDate = this.getFromDate();
        String other$fromDate = other.getFromDate();
        return !(this$fromDate == null ? other$fromDate != null : !this$fromDate.equals(other$fromDate));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindCommitters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : $fromDate.hashCode());
        return result;
    }
}

