/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.Collections;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;

public final class GithubActionsBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String buildNumber;
    private final String buildId;
    private final String host;
    private final String job;
    private final String apiURL;
    private final String repository;
    private final String ghRef;
    private final String sha;
    private final String headRef;

    public static GithubActionsBuildEnvironment build(UnaryOperator<String> environment) {
        return new GithubActionsBuildEnvironment(Tree.randomId(), (String)environment.apply("GITHUB_RUN_NUMBER"), (String)environment.apply("GITHUB_RUN_ID"), (String)environment.apply("GITHUB_SERVER_URL"), (String)environment.apply("GITHUB_ACTION"), (String)environment.apply("GITHUB_API_URL"), (String)environment.apply("GITHUB_REPOSITORY"), (String)environment.apply("GITHUB_REF"), (String)environment.apply("GITHUB_SHA"), (String)environment.apply("GITHUB_HEAD_REF"));
    }

    @Override
    public GitProvenance buildGitProvenance() throws IncompleteGitConfigException {
        String host = this.getApiURL().replaceFirst("api\\.", "");
        String gitRef = this.getGhRef();
        gitRef = gitRef.startsWith("refs/pull") ? this.getHeadRef() : gitRef.replaceFirst("refs/heads/", "");
        if (StringUtils.isBlank(this.ghRef) || StringUtils.isBlank(host) || StringUtils.isBlank(this.repository) || StringUtils.isBlank(this.sha)) {
            throw new IncompleteGitConfigException(String.format("Invalid GitHub environment with host: %s, branch: %s, repository: %s, sha: %s", host, this.ghRef, this.repository, this.sha));
        }
        return new GitProvenance(UUID.randomUUID(), host + "/" + this.getRepository() + ".git", gitRef, this.getSha(), null, null, Collections.emptyList());
    }

    public GithubActionsBuildEnvironment(UUID id, String buildNumber, String buildId, String host, String job, String apiURL, String repository, String ghRef, String sha, String headRef) {
        this.id = id;
        this.buildNumber = buildNumber;
        this.buildId = buildId;
        this.host = host;
        this.job = job;
        this.apiURL = apiURL;
        this.repository = repository;
        this.ghRef = ghRef;
        this.sha = sha;
        this.headRef = headRef;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getHost() {
        return this.host;
    }

    public String getJob() {
        return this.job;
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getGhRef() {
        return this.ghRef;
    }

    public String getSha() {
        return this.sha;
    }

    public String getHeadRef() {
        return this.headRef;
    }

    @NonNull
    public String toString() {
        return "GithubActionsBuildEnvironment(id=" + this.getId() + ", buildNumber=" + this.getBuildNumber() + ", buildId=" + this.getBuildId() + ", host=" + this.getHost() + ", job=" + this.getJob() + ", apiURL=" + this.getApiURL() + ", repository=" + this.getRepository() + ", ghRef=" + this.getGhRef() + ", sha=" + this.getSha() + ", headRef=" + this.getHeadRef() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GithubActionsBuildEnvironment)) {
            return false;
        }
        GithubActionsBuildEnvironment other = (GithubActionsBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$buildNumber = this.getBuildNumber();
        String other$buildNumber = other.getBuildNumber();
        if (this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber)) {
            return false;
        }
        String this$buildId = this.getBuildId();
        String other$buildId = other.getBuildId();
        if (this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$apiURL = this.getApiURL();
        String other$apiURL = other.getApiURL();
        if (this$apiURL == null ? other$apiURL != null : !this$apiURL.equals(other$apiURL)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        String this$ghRef = this.getGhRef();
        String other$ghRef = other.getGhRef();
        if (this$ghRef == null ? other$ghRef != null : !this$ghRef.equals(other$ghRef)) {
            return false;
        }
        String this$sha = this.getSha();
        String other$sha = other.getSha();
        if (this$sha == null ? other$sha != null : !this$sha.equals(other$sha)) {
            return false;
        }
        String this$headRef = this.getHeadRef();
        String other$headRef = other.getHeadRef();
        return !(this$headRef == null ? other$headRef != null : !this$headRef.equals(other$headRef));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $buildNumber = this.getBuildNumber();
        result = result * 59 + ($buildNumber == null ? 43 : $buildNumber.hashCode());
        String $buildId = this.getBuildId();
        result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $apiURL = this.getApiURL();
        result = result * 59 + ($apiURL == null ? 43 : $apiURL.hashCode());
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        String $ghRef = this.getGhRef();
        result = result * 59 + ($ghRef == null ? 43 : $ghRef.hashCode());
        String $sha = this.getSha();
        result = result * 59 + ($sha == null ? 43 : $sha.hashCode());
        String $headRef = this.getHeadRef();
        result = result * 59 + ($headRef == null ? 43 : $headRef.hashCode());
        return result;
    }

    @NonNull
    public GithubActionsBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new GithubActionsBuildEnvironment(id, this.buildNumber, this.buildId, this.host, this.job, this.apiURL, this.repository, this.ghRef, this.sha, this.headRef);
    }
}

