/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Contributor;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Maintainer;
import org.openrewrite.Option;
import org.openrewrite.RecipeRun;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NullUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.table.RecipeRunStats;
import org.openrewrite.table.SourcesFileErrors;
import org.openrewrite.table.SourcesFileResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
@JsonPropertyOrder(value={"@c"})
public abstract class Recipe
implements Cloneable {
    public static final String PANIC = "__AHHH_PANIC!!!__";
    private static final Logger logger = LoggerFactory.getLogger(Recipe.class);
    private transient RecipeDescriptor descriptor;
    @Nullable
    private transient List<DataTableDescriptor> dataTables;
    private static final List<DataTableDescriptor> GLOBAL_DATA_TABLES = Arrays.asList(RecipeIntrospectionUtils.dataTableDescriptorFromDataTable(new SourcesFileResults(Recipe.noop())), RecipeIntrospectionUtils.dataTableDescriptorFromDataTable(new SourcesFileErrors(Recipe.noop())), RecipeIntrospectionUtils.dataTableDescriptorFromDataTable(new RecipeRunStats(Recipe.noop())));
    protected List<Contributor> contributors;
    protected transient List<RecipeExample> examples;

    @JsonProperty(value="@c")
    public String getJacksonPolymorphicTypeTag() {
        return this.getClass().getName();
    }

    public static Recipe noop() {
        return new Noop();
    }

    @Incubating(since="8.0.0")
    public int maxCycles() {
        return Integer.MAX_VALUE;
    }

    @Language(value="markdown")
    public abstract String getDisplayName();

    @Incubating(since="8.12.0")
    @Language(value="markdown")
    public String getInstanceName() {
        String suffix = this.getInstanceNameSuffix();
        if (!StringUtils.isBlank(suffix)) {
            return this.getDisplayName() + " " + suffix;
        }
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>(this.getOptionDescriptors(this.getClass()));
        options.removeIf(opt -> !opt.isRequired());
        if (options.isEmpty()) {
            return this.getDisplayName();
        }
        if (options.size() == 1) {
            try {
                OptionDescriptor option = (OptionDescriptor)options.get(0);
                String name = option.getName();
                Field optionField = this.getClass().getDeclaredField(name);
                optionField.setAccessible(true);
                Object optionValue = optionField.get(this);
                if (optionValue != null && !Iterable.class.isAssignableFrom(optionValue.getClass()) && !optionValue.getClass().isArray()) {
                    return String.format("%s `%s`", this.getDisplayName(), optionValue);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return this.getDisplayName();
    }

    public String getInstanceNameSuffix() {
        return "";
    }

    @Language(value="markdown")
    public abstract String getDescription();

    public Set<String> getTags() {
        return Collections.emptySet();
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public final RecipeDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.createRecipeDescriptor();
        }
        return this.descriptor;
    }

    protected RecipeDescriptor createRecipeDescriptor() {
        URI recipeSource;
        List<OptionDescriptor> options = this.getOptionDescriptors(this.getClass());
        ArrayList<RecipeDescriptor> recipeList1 = new ArrayList<RecipeDescriptor>();
        for (Recipe next : this.getRecipeList()) {
            recipeList1.add(next.getDescriptor());
        }
        try {
            recipeSource = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return new RecipeDescriptor(this.getName(), this.getDisplayName(), this.getDescription(), this.getTags(), this.getEstimatedEffortPerOccurrence(), options, recipeList1, this.getDataTableDescriptors(), this.getMaintainers(), this.getContributors(), this.getExamples(), recipeSource);
    }

    private List<OptionDescriptor> getOptionDescriptors(Class<?> recipeClass) {
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
        for (Field field : recipeClass.getDeclaredFields()) {
            Object value;
            try {
                field.setAccessible(true);
                value = field.get(this);
            }
            catch (IllegalAccessException e) {
                value = null;
            }
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            options.add(new OptionDescriptor(field.getName(), field.getType().getSimpleName(), option.displayName(), option.description(), option.example().isEmpty() ? null : option.example(), (List<String>)(option.valid().length == 1 && option.valid()[0].isEmpty() ? null : Arrays.asList(option.valid())), option.required(), value));
        }
        return options;
    }

    public List<DataTableDescriptor> getDataTableDescriptors() {
        return ListUtils.concatAll(this.dataTables == null ? Collections.emptyList() : this.dataTables, GLOBAL_DATA_TABLES);
    }

    public List<Maintainer> getMaintainers() {
        return new ArrayList<Maintainer>();
    }

    public List<Contributor> getContributors() {
        if (this.contributors == null) {
            return new ArrayList<Contributor>();
        }
        return this.contributors;
    }

    public List<RecipeExample> getExamples() {
        if (this.examples == null) {
            return new ArrayList<RecipeExample>();
        }
        return this.examples;
    }

    public boolean causesAnotherCycle() {
        return false;
    }

    public List<Recipe> getRecipeList() {
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return TreeVisitor.noop();
    }

    public void addDataTable(DataTable<?> dataTable) {
        if (this.dataTables == null) {
            this.dataTables = new ArrayList<DataTableDescriptor>();
        }
        this.dataTables.add(RecipeIntrospectionUtils.dataTableDescriptorFromDataTable(dataTable));
    }

    public final RecipeRun run(LargeSourceSet before, ExecutionContext ctx) {
        return this.run(before, ctx, 3);
    }

    public final RecipeRun run(LargeSourceSet before, ExecutionContext ctx, int maxCycles) {
        return this.run(before, ctx, maxCycles, 1);
    }

    public final RecipeRun run(LargeSourceSet before, ExecutionContext ctx, int maxCycles, int minCycles) {
        return new RecipeScheduler().scheduleRun(this, before, ctx, maxCycles, minCycles);
    }

    public Validated<Object> validate(ExecutionContext ctx) {
        Validated<Object> validated = this.validate();
        for (Recipe recipe : this.getRecipeList()) {
            validated = validated.and(recipe.validate(ctx));
        }
        return validated;
    }

    public Validated<Object> validate() {
        Validated<Object> validated = Validated.none();
        Class<?> clazz = this.getClass();
        List<Field> requiredFields = NullUtils.findNonNullFields(clazz);
        for (Field field : requiredFields) {
            try {
                validated = validated.and(Validated.required(clazz.getSimpleName() + '.' + field.getName(), field.get(this)));
            }
            catch (IllegalAccessException e) {
                logger.warn("Unable to validate the field [{}] on the class [{}]", (Object)field.getName(), (Object)clazz.getName());
            }
        }
        for (Recipe recipe : this.getRecipeList()) {
            validated = validated.and(recipe.validate());
        }
        return validated;
    }

    public final Collection<Validated<Object>> validateAll() {
        return this.validateAll(new InMemoryExecutionContext(), new ArrayList<Validated<Object>>());
    }

    public Collection<Validated<Object>> validateAll(ExecutionContext ctx, Collection<Validated<Object>> acc) {
        acc.add(this.validate(ctx));
        for (Recipe recipe : this.getRecipeList()) {
            recipe.validateAll(ctx, acc);
        }
        return acc;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipe recipe = (Recipe)o;
        return this.getName().equals(recipe.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setContributors(List<Contributor> contributors) {
        this.contributors = contributors;
    }

    public void setExamples(List<RecipeExample> examples) {
        this.examples = examples;
    }

    static class Noop
    extends Recipe {
        Noop() {
        }

        @Override
        public String getDisplayName() {
            return "Do nothing";
        }

        @Override
        public String getDescription() {
            return "Default no-op test, does nothing.";
        }
    }
}

