/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class UnionInputStream
extends InputStream {
    private static final InputStream EOF = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private final LinkedList<InputStream> streams = new LinkedList();

    public UnionInputStream() {
    }

    public UnionInputStream(InputStream ... inputStreams) {
        InputStream[] inputStreamArray = inputStreams;
        int n = inputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            InputStream i = inputStreamArray[n2];
            this.add(i);
            ++n2;
        }
    }

    private InputStream head() {
        return this.streams.isEmpty() ? EOF : this.streams.getFirst();
    }

    private void pop() throws IOException {
        if (!this.streams.isEmpty()) {
            this.streams.removeFirst().close();
        }
    }

    public void add(InputStream in) {
        this.streams.add(in);
    }

    public boolean isEmpty() {
        return this.streams.isEmpty();
    }

    @Override
    public int read() throws IOException {
        InputStream in;
        int r;
        while ((r = (in = this.head()).read()) < 0) {
            if (in == EOF) {
                return -1;
            }
            this.pop();
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        InputStream in;
        int n;
        while ((n = (in = this.head()).read(b, off, len)) <= 0) {
            if (in == EOF) {
                return -1;
            }
            this.pop();
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.head().available();
    }

    @Override
    public long skip(long count) throws IOException {
        long skipped = 0L;
        long cnt = count;
        while (0L < cnt) {
            InputStream in = this.head();
            long n = in.skip(cnt);
            if (0L < n) {
                skipped += n;
                cnt -= n;
                continue;
            }
            if (in == EOF) {
                return skipped;
            }
            int r = in.read();
            if (r < 0) {
                this.pop();
                if (0L >= skipped) continue;
                break;
            }
            ++skipped;
            --cnt;
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        IOException err = null;
        Iterator i = this.streams.iterator();
        while (i.hasNext()) {
            try {
                ((InputStream)i.next()).close();
            }
            catch (IOException closeError) {
                err = closeError;
            }
            i.remove();
        }
        if (err != null) {
            throw err;
        }
    }
}

