/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.internal.storage.file;

import java.text.MessageFormat;
import org.openrewrite.shaded.jgit.errors.CorruptObjectException;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.internal.storage.file.PackIndex;
import org.openrewrite.shaded.jgit.lib.ObjectId;

public class PackReverseIndex {
    private final PackIndex index;
    private final long bucketSize;
    private final int[] offsetIndex;
    private final int[] nth;

    public PackReverseIndex(PackIndex packIndex) {
        this.index = packIndex;
        long cnt = this.index.getObjectCount();
        if (cnt + 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(JGitText.get().hugeIndexesAreNotSupportedByJgitYet);
        }
        if (cnt == 0L) {
            this.bucketSize = Long.MAX_VALUE;
            this.offsetIndex = new int[1];
            this.nth = new int[0];
            return;
        }
        long[] offsetsBySha1 = new long[(int)cnt];
        long maxOffset = 0L;
        int ith = 0;
        for (PackIndex.MutableEntry me : this.index) {
            long o = me.getOffset();
            offsetsBySha1[ith++] = o;
            if (o <= maxOffset) continue;
            maxOffset = o;
        }
        this.bucketSize = maxOffset / cnt + 1L;
        int[] bucketIndex = new int[(int)cnt];
        int[] bucketValues = new int[(int)cnt + 1];
        int oi = 0;
        while (oi < offsetsBySha1.length) {
            long o = offsetsBySha1[oi];
            int bucket = (int)(o / this.bucketSize);
            int bucketValuesPos = oi + 1;
            int current = bucketIndex[bucket];
            bucketIndex[bucket] = bucketValuesPos;
            bucketValues[bucketValuesPos] = current;
            ++oi;
        }
        int nthByOffset = 0;
        this.nth = new int[offsetsBySha1.length];
        this.offsetIndex = bucketIndex;
        int bi = 0;
        while (bi < bucketIndex.length) {
            int start = nthByOffset;
            int vi = bucketIndex[bi];
            while (vi > 0) {
                int nthBySha1 = vi - 1;
                long o = offsetsBySha1[nthBySha1];
                int insertion = nthByOffset++;
                while (start < insertion) {
                    if (o > offsetsBySha1[this.nth[insertion - 1]]) break;
                    this.nth[insertion] = this.nth[insertion - 1];
                    --insertion;
                }
                this.nth[insertion] = nthBySha1;
                vi = bucketValues[vi];
            }
            this.offsetIndex[bi] = nthByOffset;
            ++bi;
        }
    }

    public ObjectId findObject(long offset) {
        int ith = this.binarySearch(offset);
        if (ith < 0) {
            return null;
        }
        return this.index.getObjectId(this.nth[ith]);
    }

    public long findNextOffset(long offset, long maxOffset) throws CorruptObjectException {
        int ith = this.binarySearch(offset);
        if (ith < 0) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().cantFindObjectInReversePackIndexForTheSpecifiedOffset, offset));
        }
        if (ith + 1 == this.nth.length) {
            return maxOffset;
        }
        return this.index.getOffset(this.nth[ith + 1]);
    }

    int findPostion(long offset) {
        return this.binarySearch(offset);
    }

    private int binarySearch(long offset) {
        int bucket = (int)(offset / this.bucketSize);
        int low = bucket == 0 ? 0 : this.offsetIndex[bucket - 1];
        int high = this.offsetIndex[bucket];
        while (low < high) {
            int mid = low + high >>> 1;
            long o = this.index.getOffset(this.nth[mid]);
            if (offset < o) {
                high = mid;
                continue;
            }
            if (offset == o) {
                return mid;
            }
            low = mid + 1;
        }
        return -1;
    }

    ObjectId findObjectByPosition(int nthPosition) {
        return this.index.getObjectId(this.nth[nthPosition]);
    }
}

