/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.search;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.table.CommitsByDay;
import org.openrewrite.table.DistinctCommitters;

public class FindCommitters
extends ScanningRecipe<Map<String, GitProvenance.Committer>> {
    private final transient DistinctCommitters committers = new DistinctCommitters(this);
    private final transient CommitsByDay commitsByDay = new CommitsByDay(this);

    @Override
    public String getDisplayName() {
        return "Find committers on repositories";
    }

    @Override
    public String getDescription() {
        return "List the committers on a repository.";
    }

    @Override
    public Map<String, GitProvenance.Committer> getInitialValue(ExecutionContext ctx) {
        return new TreeMap<String, GitProvenance.Committer>();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Map<String, GitProvenance.Committer> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    sourceFile.getMarkers().findFirst(GitProvenance.class).ifPresent(provenance -> {
                        if (provenance.getCommitters() != null) {
                            for (GitProvenance.Committer committer : provenance.getCommitters()) {
                                acc.put(committer.getEmail(), committer);
                            }
                        }
                    });
                }
                return tree;
            }
        };
    }

    @Override
    public Collection<? extends SourceFile> generate(Map<String, GitProvenance.Committer> acc, ExecutionContext ctx) {
        for (GitProvenance.Committer committer : acc.values()) {
            this.committers.insertRow(ctx, new DistinctCommitters.Row(committer.getName(), committer.getEmail(), (LocalDate)committer.getCommitsByDay().lastKey(), committer.getCommitsByDay().values().stream().mapToInt(Integer::intValue).sum()));
            committer.getCommitsByDay().forEach((day, commits) -> this.commitsByDay.insertRow(ctx, new CommitsByDay.Row(committer.getName(), committer.getEmail(), (LocalDate)day, (int)commits)));
        }
        return Collections.emptyList();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(final Map<String, GitProvenance.Committer> acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    return SearchResult.found(tree, String.join((CharSequence)"\n", acc.keySet()));
                }
                return tree;
            }
        };
    }
}

