/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;

public class Preconditions {
    public static TreeVisitor<?, ExecutionContext> check(Recipe check, TreeVisitor<?, ExecutionContext> v) {
        if (check instanceof ScanningRecipe) {
            throw new IllegalArgumentException("ScanningRecipe is not supported as a check");
        }
        return Preconditions.check(check.getVisitor(), v);
    }

    public static TreeVisitor<?, ExecutionContext> check(final TreeVisitor<?, ExecutionContext> check, final TreeVisitor<?, ExecutionContext> v) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return check.isAcceptable(sourceFile, ctx) && v.isAcceptable(sourceFile, ctx);
            }

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                return !(tree instanceof SourceFile) || check.visit(tree, ctx) != tree ? v.visit(tree, ctx) : tree;
            }

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx, Cursor parent) {
                return !(tree instanceof SourceFile) || check.visit(tree, ctx, parent) != tree ? v.visit(tree, ctx, parent) : tree;
            }
        };
    }

    public static TreeVisitor<?, ExecutionContext> check(boolean check, TreeVisitor<?, ExecutionContext> v) {
        return check ? v : TreeVisitor.noop();
    }

    @SafeVarargs
    @Incubating(since="8.0.0")
    public static TreeVisitor<?, ExecutionContext> firstAcceptable(final TreeVisitor<?, ExecutionContext> ... vs) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    for (TreeVisitor v : vs) {
                        if (!v.isAcceptable((SourceFile)tree, ctx)) continue;
                        return v.visit(tree, ctx);
                    }
                }
                return tree;
            }
        };
    }

    public static TreeVisitor<?, ExecutionContext> not(final TreeVisitor<?, ExecutionContext> v) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Object t2 = v.visit(tree, ctx);
                return tree == t2 && tree != null ? SearchResult.found(tree) : tree;
            }
        };
    }

    @SafeVarargs
    public static TreeVisitor<?, ExecutionContext> or(final TreeVisitor<?, ExecutionContext> ... vs) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                for (TreeVisitor v : vs) {
                    Object t2 = v.visit(tree, ctx);
                    if (tree == t2) continue;
                    return t2;
                }
                return tree;
            }
        };
    }

    @SafeVarargs
    public static TreeVisitor<?, ExecutionContext> and(final TreeVisitor<?, ExecutionContext> ... vs) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree t2 = tree;
                for (TreeVisitor v : vs) {
                    t2 = v.visit(tree, ctx);
                    if (tree != t2) continue;
                    return tree;
                }
                return t2;
            }
        };
    }
}

