/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.RecipeTimeoutException;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.internal.FindRecipeRunException;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.scheduling.WatchableExecutionContext;
import org.openrewrite.table.RecipeRunStats;
import org.openrewrite.table.SourcesFileErrors;
import org.openrewrite.table.SourcesFileResults;

public class RecipeScheduler {
    public RecipeRun scheduleRun(Recipe recipe, LargeSourceSet sourceSet, ExecutionContext ctx, int maxCycles, int minCycles) {
        WatchableExecutionContext ctxWithWatch = new WatchableExecutionContext(ctx);
        RecipeRunStats recipeRunStats = new RecipeRunStats(Recipe.noop());
        SourcesFileErrors errorsTable = new SourcesFileErrors(Recipe.noop());
        SourcesFileResults sourceFileResults = new SourcesFileResults(Recipe.noop());
        LargeSourceSet after = sourceSet;
        for (int i = 1; i <= maxCycles; ++i) {
            ctxWithWatch.putCycle(i);
            after.beforeCycle();
            Cursor rootCursor = new Cursor(null, "root");
            RecipeRunCycle cycle = new RecipeRunCycle(recipe, i, rootCursor, ctxWithWatch, recipeRunStats, sourceFileResults, errorsTable);
            if (this.hasScanningRecipe(recipe)) {
                after = cycle.scanSources(after, i);
            }
            after = cycle.generateSources(after, i);
            after = cycle.editSources(after, i);
            boolean anyRecipeCausingAnotherCycle = false;
            for (Recipe madeChanges : cycle.madeChangesInThisCycle) {
                if (!madeChanges.causesAnotherCycle()) continue;
                anyRecipeCausingAnotherCycle = true;
            }
            if (i >= minCycles && cycle.madeChangesInThisCycle.isEmpty() && !ctxWithWatch.hasNewMessages() && !anyRecipeCausingAnotherCycle) {
                after.afterCycle(true);
                break;
            }
            after.afterCycle(i == maxCycles);
            ctxWithWatch.resetHasNewMessages();
        }
        recipeRunStats.flush(ctx);
        return new RecipeRun(after.getChangeset(), ctx.getMessage("org.openrewrite.dataTables", Collections.emptyMap()));
    }

    private boolean hasScanningRecipe(Recipe recipe) {
        if (recipe instanceof ScanningRecipe) {
            return true;
        }
        for (Recipe r : recipe.getRecipeList()) {
            if (!this.hasScanningRecipe(r)) continue;
            return true;
        }
        return false;
    }

    private static <S extends SourceFile> S addRecipesThatMadeChanges(List<Recipe> recipeStack, S afterFile) {
        return (S)((SourceFile)afterFile.withMarkers(afterFile.getMarkers().computeByType(RecipesThatMadeChanges.create(recipeStack), (r1, r2) -> {
            r1.getRecipes().addAll(r2.getRecipes());
            return r1;
        })));
    }

    static class RecipeRunCycle {
        private final Recipe recipe;
        private final int cycle;
        private final Cursor rootCursor;
        private final ExecutionContext ctx;
        private final RecipeRunStats recipeRunStats;
        private final SourcesFileResults sourcesFileResults;
        private final SourcesFileErrors errorsTable;
        private final Map<Recipe, List<Recipe>> recipeLists = new IdentityHashMap<Recipe, List<Recipe>>();
        private final long cycleStartTime = System.nanoTime();
        private final AtomicBoolean thrownErrorOnTimeout = new AtomicBoolean();
        private final List<Recipe> madeChangesInThisCycle = new ArrayList<Recipe>();

        public LargeSourceSet scanSources(LargeSourceSet sourceSet, int cycle) {
            return this.mapForRecipeRecursively(sourceSet, (recipeStack, sourceFile) -> {
                Recipe recipe = (Recipe)recipeStack.peek();
                if (recipe.maxCycles() < cycle || !recipe.validate(this.ctx).isValid()) {
                    return sourceFile;
                }
                SourceFile after = sourceFile;
                if (recipe instanceof ScanningRecipe) {
                    try {
                        ScanningRecipe scanningRecipe = (ScanningRecipe)recipe;
                        Object acc = scanningRecipe.getAccumulator(this.rootCursor, this.ctx);
                        this.recipeRunStats.recordScan(recipe, () -> {
                            TreeVisitor<?, ExecutionContext> scanner = scanningRecipe.getScanner(acc);
                            if (scanner.isAcceptable((SourceFile)sourceFile, this.ctx)) {
                                scanner.visit((Tree)sourceFile, this.ctx, this.rootCursor);
                            }
                            return sourceFile;
                        });
                    }
                    catch (Throwable t) {
                        after = this.handleError(recipe, (SourceFile)sourceFile, after, t);
                    }
                }
                return after;
            });
        }

        public LargeSourceSet generateSources(LargeSourceSet sourceSet, int cycle) {
            ArrayList<SourceFile> generatedInThisCycle = new ArrayList<SourceFile>();
            Stack<Stack<Recipe>> allRecipesStack = this.initRecipeStack();
            LargeSourceSet acc = sourceSet;
            while (!allRecipesStack.isEmpty()) {
                Stack<Recipe> recipeStack = allRecipesStack.pop();
                Recipe recipe = recipeStack.peek();
                if (recipe.maxCycles() < cycle || !recipe.validate(this.ctx).isValid()) continue;
                if (recipe instanceof ScanningRecipe) {
                    ScanningRecipe scanningRecipe = (ScanningRecipe)recipe;
                    sourceSet.setRecipe(recipeStack);
                    ArrayList<SourceFile> generated = new ArrayList<SourceFile>(scanningRecipe.generate(scanningRecipe.getAccumulator(this.rootCursor, this.ctx), generatedInThisCycle, this.ctx));
                    generated.replaceAll(source -> RecipeScheduler.addRecipesThatMadeChanges(recipeStack, source));
                    generatedInThisCycle.addAll(generated);
                    if (!generated.isEmpty()) {
                        this.madeChangesInThisCycle.add(recipe);
                    }
                }
                this.recurseRecipeList(allRecipesStack, recipeStack);
            }
            acc = acc.generate(generatedInThisCycle);
            return acc;
        }

        public LargeSourceSet editSources(LargeSourceSet sourceSet, int cycle) {
            return this.mapForRecipeRecursively(sourceSet, (recipeStack, sourceFile) -> {
                Recipe recipe = (Recipe)recipeStack.peek();
                if (recipe.maxCycles() < cycle || !recipe.validate(this.ctx).isValid()) {
                    return sourceFile;
                }
                SourceFile after = sourceFile;
                try {
                    Duration duration = Duration.ofNanos(System.nanoTime() - this.cycleStartTime);
                    if (duration.compareTo(this.ctx.getMessage("org.openrewrite.runTimeout", Duration.ofMinutes(4L))) > 0) {
                        if (this.thrownErrorOnTimeout.compareAndSet(false, true)) {
                            RecipeTimeoutException t = new RecipeTimeoutException(recipe);
                            this.ctx.getOnError().accept(t);
                            this.ctx.getOnTimeout().accept(t, this.ctx);
                        }
                        return sourceFile;
                    }
                    if (this.ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                        return sourceFile;
                    }
                    TreeVisitor<?, ExecutionContext> visitor = recipe.getVisitor();
                    visitor.setCursor(this.rootCursor);
                    after = this.recipeRunStats.recordEdit(recipe, () -> {
                        if (visitor.isAcceptable((SourceFile)sourceFile, this.ctx)) {
                            return (SourceFile)visitor.visit((Tree)sourceFile, this.ctx, this.rootCursor);
                        }
                        return sourceFile;
                    });
                    if (after != sourceFile) {
                        this.madeChangesInThisCycle.add((Recipe)recipeStack.peek());
                        this.recordSourceFileResult((SourceFile)sourceFile, after, (Stack<Recipe>)recipeStack, this.ctx);
                        if (sourceFile.getMarkers().findFirst(Generated.class).isPresent()) {
                            return sourceFile;
                        }
                    }
                }
                catch (Throwable t) {
                    after = this.handleError(recipe, (SourceFile)sourceFile, after, t);
                }
                if (after != null && after != sourceFile) {
                    after = RecipeScheduler.addRecipesThatMadeChanges(recipeStack, after);
                }
                return after;
            });
        }

        private void recordSourceFileResult(@Nullable SourceFile before, @Nullable SourceFile after, Stack<Recipe> recipeStack, ExecutionContext ctx) {
            boolean hierarchical;
            String beforePath = before == null ? "" : before.getSourcePath().toString();
            String afterPath = after == null ? "" : after.getSourcePath().toString();
            Recipe recipe = recipeStack.peek();
            Long effortSeconds = recipe.getEstimatedEffortPerOccurrence() == null ? 0L : recipe.getEstimatedEffortPerOccurrence().getSeconds();
            String parentName = "";
            boolean bl = hierarchical = recipeStack.size() > 1;
            if (hierarchical) {
                parentName = ((Recipe)recipeStack.get(recipeStack.size() - 2)).getName();
            }
            String recipeName = recipe.getName();
            this.sourcesFileResults.insertRow(ctx, new SourcesFileResults.Row(beforePath, afterPath, parentName, recipeName, effortSeconds, this.cycle));
            if (hierarchical) {
                this.recordSourceFileResult(beforePath, afterPath, recipeStack.subList(0, recipeStack.size() - 1), effortSeconds, ctx);
            }
        }

        private void recordSourceFileResult(@Nullable String beforePath, @Nullable String afterPath, List<Recipe> recipeStack, Long effortSeconds, ExecutionContext ctx) {
            if (recipeStack.size() <= 1) {
                return;
            }
            String parentName = recipeStack.size() == 2 ? "" : recipeStack.get(recipeStack.size() - 2).getName();
            Recipe recipe = recipeStack.get(recipeStack.size() - 1);
            this.sourcesFileResults.insertRow(ctx, new SourcesFileResults.Row(beforePath, afterPath, parentName, recipe.getName(), effortSeconds, this.cycle));
            this.recordSourceFileResult(beforePath, afterPath, recipeStack.subList(0, recipeStack.size() - 1), effortSeconds, ctx);
        }

        @Nullable
        private SourceFile handleError(Recipe recipe, SourceFile sourceFile, @Nullable SourceFile after, Throwable t) {
            this.ctx.getOnError().accept(t);
            if (t instanceof RecipeRunException) {
                RecipeRunException vt = (RecipeRunException)t;
                after = (SourceFile)new FindRecipeRunException(vt).visitNonNull(Objects.requireNonNull(after, "after is null"), 0);
            }
            this.errorsTable.insertRow(this.ctx, new SourcesFileErrors.Row(sourceFile.getSourcePath().toString(), recipe.getName(), ExceptionUtils.sanitizeStackTrace(t, RecipeScheduler.class)));
            return after;
        }

        private LargeSourceSet mapForRecipeRecursively(LargeSourceSet sourceSet, BiFunction<Stack<Recipe>, SourceFile, SourceFile> mapFn) {
            return sourceSet.edit(sourceFile -> {
                Stack<Stack<Recipe>> allRecipesStack = this.initRecipeStack();
                SourceFile acc = sourceFile;
                while (!allRecipesStack.isEmpty()) {
                    Stack<Recipe> recipeStack = allRecipesStack.pop();
                    sourceSet.setRecipe(recipeStack);
                    acc = (SourceFile)mapFn.apply(recipeStack, acc);
                    this.recurseRecipeList(allRecipesStack, recipeStack);
                }
                return acc;
            });
        }

        private Stack<Stack<Recipe>> initRecipeStack() {
            Stack<Stack<Recipe>> allRecipesStack = new Stack<Stack<Recipe>>();
            Stack<Recipe> rootRecipeStack = new Stack<Recipe>();
            rootRecipeStack.push(this.recipe);
            allRecipesStack.push(rootRecipeStack);
            return allRecipesStack;
        }

        private void recurseRecipeList(Stack<Stack<Recipe>> allRecipesStack, Stack<Recipe> recipeStack) {
            List recipeList = this.recipeLists.computeIfAbsent(recipeStack.peek(), Recipe::getRecipeList);
            for (int i = recipeList.size() - 1; i >= 0; --i) {
                Recipe r = (Recipe)recipeList.get(i);
                if (this.ctx.getMessage("__AHHH_PANIC!!!__") != null) break;
                Stack<Recipe> nextStack = new Stack<Recipe>();
                nextStack.addAll(recipeStack);
                nextStack.push(r);
                allRecipesStack.push(nextStack);
            }
        }

        public RecipeRunCycle(Recipe recipe, int cycle, Cursor rootCursor, ExecutionContext ctx, RecipeRunStats recipeRunStats, SourcesFileResults sourcesFileResults, SourcesFileErrors errorsTable) {
            this.recipe = recipe;
            this.cycle = cycle;
            this.rootCursor = rootCursor;
            this.ctx = ctx;
            this.recipeRunStats = recipeRunStats;
            this.sourcesFileResults = sourcesFileResults;
            this.errorsTable = errorsTable;
        }
    }
}

