/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markup;
import org.openrewrite.table.ParseFailures;

public final class FindParseFailures
extends Recipe {
    @Option(displayName="Max snippet length", description="When the failure occurs on a granular tree element, its source code will be included as a column in the data table up to this maximum snippet length.", required=false)
    @Nullable
    private final Integer maxSnippetLength;
    private final transient ParseFailures failures = new ParseFailures(this);

    @Override
    public String getDisplayName() {
        return "Find source files with `ParseExceptionResult` markers";
    }

    @Override
    public String getDescription() {
        return "This recipe explores parse failures after an LST is produced for classifying the types of failures that can occur and prioritizing fixes according to the most common problems.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree postVisit(Tree tree, ExecutionContext ctx) {
                return tree.getMarkers().findFirst(ParseExceptionResult.class).map(exceptionResult -> {
                    String snippet;
                    String string = snippet = tree instanceof SourceFile ? null : tree.printTrimmed(this.getCursor());
                    if (snippet != null && FindParseFailures.this.maxSnippetLength != null && snippet.length() > FindParseFailures.this.maxSnippetLength) {
                        snippet = snippet.substring(0, FindParseFailures.this.maxSnippetLength);
                    }
                    FindParseFailures.this.failures.insertRow(ctx, new ParseFailures.Row(exceptionResult.getParserType(), (tree instanceof SourceFile ? (SourceFile)tree : this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), exceptionResult.getExceptionType(), exceptionResult.getTreeType(), snippet, exceptionResult.getMessage()));
                    return Markup.info(tree, exceptionResult.getMessage());
                }).orElse(tree);
            }
        };
    }

    public FindParseFailures(@Nullable Integer maxSnippetLength) {
        this.maxSnippetLength = maxSnippetLength;
    }

    @Nullable
    public Integer getMaxSnippetLength() {
        return this.maxSnippetLength;
    }

    public ParseFailures getFailures() {
        return this.failures;
    }

    @NonNull
    public String toString() {
        return "FindParseFailures(maxSnippetLength=" + this.getMaxSnippetLength() + ", failures=" + this.getFailures() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindParseFailures)) {
            return false;
        }
        FindParseFailures other = (FindParseFailures)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$maxSnippetLength = this.getMaxSnippetLength();
        Integer other$maxSnippetLength = other.getMaxSnippetLength();
        return !(this$maxSnippetLength == null ? other$maxSnippetLength != null : !((Object)this$maxSnippetLength).equals(other$maxSnippetLength));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindParseFailures;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $maxSnippetLength = this.getMaxSnippetLength();
        result = result * 59 + ($maxSnippetLength == null ? 43 : ((Object)$maxSnippetLength).hashCode());
        return result;
    }
}

