/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.UUID;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public final class ParseExceptionResult
implements Marker {
    private final UUID id;
    private final String message;

    public static ParseExceptionResult build(Parser parser, Throwable t) {
        return new ParseExceptionResult(Tree.randomId(), ExceptionUtils.sanitizeStackTrace(t, parser.getClass()));
    }

    public ParseExceptionResult(UUID id, String message) {
        this.id = id;
        this.message = message;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseExceptionResult)) {
            return false;
        }
        ParseExceptionResult other = (ParseExceptionResult)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "ParseExceptionResult(id=" + this.getId() + ", message=" + this.getMessage() + ")";
    }

    @NonNull
    public ParseExceptionResult withId(UUID id) {
        return this.id == id ? this : new ParseExceptionResult(id, this.message);
    }

    @NonNull
    public ParseExceptionResult withMessage(String message) {
        return this.message == message ? this : new ParseExceptionResult(this.id, message);
    }
}

