/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class Find
extends Recipe {
    @Option(displayName="Find", description="The text to find.", example="blacklist")
    private final String find;
    @Option(displayName="Regex", description="If true, `find` will be interpreted as a Regular Expression. Default false.", required=false)
    @Nullable
    private final Boolean regex;

    @Override
    public String getDisplayName() {
        return "Find text";
    }

    @Override
    public String getDescription() {
        return "Search for text, treating all textual sources as plain text.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                PlainText plainText = PlainTextParser.convert(sourceFile);
                String searchStr = Find.this.find;
                if (!Boolean.TRUE.equals(Find.this.regex)) {
                    searchStr = Pattern.quote(searchStr);
                }
                Pattern pattern = Pattern.compile(searchStr);
                Matcher matcher = pattern.matcher(plainText.getText());
                String rawText = plainText.getText();
                if (!matcher.find()) {
                    return sourceFile;
                }
                matcher.reset();
                ArrayList<PlainText.Snippet> snippets = new ArrayList<PlainText.Snippet>();
                int previousEnd = 0;
                while (matcher.find()) {
                    int matchStart = matcher.start();
                    snippets.add(Find.snippet(rawText.substring(previousEnd, matchStart)));
                    snippets.add(SearchResult.found(Find.snippet(rawText.substring(matchStart, matcher.end()))));
                    previousEnd = matcher.end();
                }
                snippets.add(Find.snippet(rawText.substring(previousEnd)));
                return plainText.withText("").withSnippets(snippets);
            }
        };
    }

    private static PlainText.Snippet snippet(String text) {
        return new PlainText.Snippet(Tree.randomId(), Markers.EMPTY, text);
    }

    public Find(String find, @Nullable Boolean regex) {
        this.find = find;
        this.regex = regex;
    }

    public String getFind() {
        return this.find;
    }

    @Nullable
    public Boolean getRegex() {
        return this.regex;
    }

    @NonNull
    public String toString() {
        return "Find(find=" + this.getFind() + ", regex=" + this.getRegex() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Find)) {
            return false;
        }
        Find other = (Find)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        String this$find = this.getFind();
        String other$find = other.getFind();
        return !(this$find == null ? other$find != null : !this$find.equals(other$find));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Find;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        String $find = this.getFind();
        result = result * 59 + ($find == null ? 43 : $find.hashCode());
        return result;
    }
}

