/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.binary;

import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.tree.ParsingExecutionContextView;

public class BinaryParser
implements Parser<Binary> {
    @Override
    public Stream<Binary> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        return StreamSupport.stream(sources.spliterator(), false).map(source -> {
            Path path = source.getRelativePath(relativeTo);
            try {
                return new Binary(Tree.randomId(), path, Markers.EMPTY, source.getFileAttributes(), null, StreamUtils.readAllBytes(source.getSource(ctx)));
            }
            catch (Exception e) {
                ParsingExecutionContextView.view(ctx).parseFailure((Parser.Input)source, relativeTo, this, e);
                ctx.getOnError().accept(e);
                return null;
            }
        }).filter(Objects::nonNull);
    }

    @Override
    public boolean accept(Path path) {
        return true;
    }

    @Override
    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file");
    }
}

