/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import de.danielbechler.diff.ObjectDiffer;
import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionResolver;
import de.danielbechler.diff.node.DiffNode;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.beans.Transient;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeObserver;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.internal.TreeVisitorAdapter;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public abstract class TreeVisitor<T extends Tree, P> {
    private static final String STOP_AFTER_PRE_VISIT = "__org.openrewrite.stopVisitor__";
    Cursor cursor = new Cursor(null, "root");
    private List<TreeVisitor<?, P>> afterVisit;
    private int visitCount;
    private final DistributionSummary visitCountSummary = DistributionSummary.builder((String)"rewrite.visitor.visit.method.count").description("Visit methods called per source file visited.").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry);
    private ObjectDiffer differ;

    public static <T extends Tree, P> TreeVisitor<T, P> noop() {
        return new TreeVisitor<T, P>(){

            @Override
            @Nullable
            public T visit(@Nullable Tree tree, P p) {
                return tree;
            }

            @Override
            @Nullable
            public T visit(@Nullable Tree tree, P p, Cursor parent) {
                return tree;
            }
        };
    }

    private ObjectDiffer getObjectDiffer() {
        if (this.differ == null) {
            this.differ = ObjectDifferBuilder.startBuilding().inclusion().resolveUsing(new InclusionResolver(){

                public Inclusion getInclusion(DiffNode node) {
                    if (node.getPropertyAnnotation(Transient.class) != null) {
                        return Inclusion.EXCLUDED;
                    }
                    return Inclusion.DEFAULT;
                }

                public boolean enablesStrictIncludeMode() {
                    return false;
                }
            }).and().build();
        }
        return this.differ;
    }

    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return true;
    }

    public void setCursor(@Nullable Cursor cursor) {
        this.cursor = cursor;
    }

    @Nullable
    public String getLanguage() {
        return null;
    }

    protected void doAfterVisit(TreeVisitor<?, P> visitor) {
        if (this.afterVisit == null) {
            this.afterVisit = new ArrayList(2);
        }
        this.afterVisit.add(visitor);
    }

    protected List<TreeVisitor<?, P>> getAfterVisit() {
        return this.afterVisit == null ? Collections.emptyList() : this.afterVisit;
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    public final Cursor updateCursor(T currentValue) {
        Object old = this.cursor.getValue();
        if (!(old instanceof Tree)) {
            throw new IllegalArgumentException("To update the cursor, it must currently be positioned at a Tree instance");
        }
        if (!((Tree)old).getId().equals(currentValue.getId())) {
            throw new IllegalArgumentException("Updating the cursor in place is only supported for mutations on a Tree instance that maintain the same ID after the mutation.");
        }
        this.cursor = new Cursor(this.cursor.getParentOrThrow(), currentValue);
        return this.cursor;
    }

    @Nullable
    public T preVisit(T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    @Nullable
    public T postVisit(T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p, Cursor parent) {
        this.cursor = parent;
        return this.visit(tree, p);
    }

    public T visitNonNull(Tree tree, P p) {
        T t = this.visit(tree, p);
        assert (t != null);
        return t;
    }

    public T visitNonNull(Tree tree, P p, Cursor parent) {
        T t = this.visit(tree, p, parent);
        assert (t != null);
        return t;
    }

    @Incubating(since="7.31.0")
    public static <R extends Tree, C extends Collection<R>> C collect(TreeVisitor<?, ExecutionContext> visitor, Tree tree, C initial) {
        return TreeVisitor.collect(visitor, tree, initial, Tree.class, t -> t);
    }

    @Incubating(since="7.31.0")
    public static <U extends Tree, R, C extends Collection<R>> C collect(TreeVisitor<?, ExecutionContext> visitor, Tree tree, final C initial, final Class<U> matchOn, final Function<U, R> map) {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext();
        ctx.addObserver(new TreeObserver.Subscription(new TreeObserver(){

            @Override
            public Tree treeChanged(Cursor cursor, Tree newTree) {
                initial.add(map.apply((Tree)matchOn.cast(newTree)));
                return newTree;
            }
        }).subscribeToType(matchOn));
        visitor.visit(tree, (ExecutionContext)ctx);
        return initial;
    }

    @Incubating(since="7.31.0")
    public P reduce(Iterable<? extends Tree> trees, P p) {
        for (Tree tree : trees) {
            this.visit(tree, p);
        }
        return p;
    }

    @Incubating(since="7.31.0")
    public P reduce(Tree tree, P p) {
        this.visit(tree, p);
        return p;
    }

    @Incubating(since="7.31.0")
    public P reduce(Tree tree, P p, Cursor parent) {
        this.visit(tree, p, parent);
        return p;
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return this.defaultValue(null, p);
        }
        Timer.Sample sample = null;
        boolean topLevel = false;
        if (this.visitCount == 0) {
            topLevel = true;
            sample = Timer.start();
        }
        ++this.visitCount;
        this.setCursor(new Cursor(this.cursor, tree));
        Tree t = null;
        boolean isAcceptable = tree.isAcceptable(this, p) && (!(tree instanceof SourceFile) || this.isAcceptable((SourceFile)tree, p));
        try {
            if (isAcceptable) {
                t = this.preVisit(tree, p);
                if (!this.cursor.getMessage(STOP_AFTER_PRE_VISIT, false).booleanValue()) {
                    if (t != null) {
                        t = t.accept(this, p);
                    }
                    if (t != null) {
                        t = this.postVisit(t, p);
                    }
                }
                if (t != tree && t != null && p instanceof ExecutionContext) {
                    ExecutionContext ctx = (ExecutionContext)p;
                    for (TreeObserver.Subscription observer : ctx.getObservers()) {
                        if (!observer.isSubscribed(tree)) continue;
                        observer.getObserver().treeChanged(this.getCursor(), t);
                        DiffNode diff = this.getObjectDiffer().compare((Object)t, (Object)tree);
                        AtomicReference<Tree> t2 = new AtomicReference<Tree>(t);
                        diff.visit((node, visit) -> {
                            if (!node.hasChildren() && node.getPropertyName() != null) {
                                t2.set(observer.getObserver().propertyChanged(node.getPropertyName(), this.getCursor(), (Tree)t2.get(), node.canonicalGet((Object)tree), node.canonicalGet(t2.get())));
                            }
                        });
                        t = t2.get();
                    }
                }
            }
            this.setCursor(this.cursor.getParent());
            if (topLevel) {
                sample.stop(Timer.builder((String)"rewrite.visitor.visit").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry));
                this.visitCountSummary.record((double)this.visitCount);
                if (t != null && this.afterVisit != null) {
                    for (TreeVisitor treeVisitor : this.afterVisit) {
                        if (treeVisitor == null) continue;
                        treeVisitor.setCursor(this.getCursor());
                        t = treeVisitor.visit(t, p);
                    }
                }
                sample.stop(Timer.builder((String)"rewrite.visitor.visit.cumulative").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry));
                this.afterVisit = null;
                this.visitCount = 0;
            }
        }
        catch (Throwable e) {
            if (e instanceof RecipeRunException) {
                throw e;
            }
            throw new RecipeRunException(e, this.getCursor(), this.describeLocation(this.getCursor()));
        }
        return (T)(isAcceptable ? t : tree);
    }

    public void visit(@Nullable List<? extends T> nodes, P p) {
        if (nodes != null) {
            for (Tree node : nodes) {
                this.visit(node, p);
            }
        }
    }

    @Nullable
    public T defaultValue(@Nullable Tree tree, P p) {
        return (T)tree;
    }

    @Incubating(since="7.0.0")
    protected final <T2 extends Tree> T2 visitAndCast(T2 t, P p, BiFunction<T2, P, Tree> callSuper) {
        return (T2)callSuper.apply(t, p);
    }

    @Nullable
    @Incubating(since="7.0.0")
    protected final <T2 extends T> T2 visitAndCast(@Nullable Tree tree, P p) {
        return (T2)this.visit(tree, p);
    }

    public Markers visitMarkers(Markers markers, P p) {
        return markers.withMarkers(ListUtils.map(markers.getMarkers(), marker -> this.visitMarker((Marker)marker, p)));
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        return (M)marker;
    }

    public boolean isAdaptableTo(Class<? extends TreeVisitor> adaptTo) {
        if (adaptTo.isAssignableFrom(this.getClass())) {
            return true;
        }
        Class<Tree> mine = this.visitorTreeType(this.getClass());
        Class<Tree> theirs = this.visitorTreeType(adaptTo);
        return mine.isAssignableFrom(theirs);
    }

    private Class<? extends Tree> visitorTreeType(Class<? extends TreeVisitor> v) {
        for (TypeVariable<Class<? extends TreeVisitor>> tp : v.getTypeParameters()) {
            for (Type bound : tp.getBounds()) {
                if (!(bound instanceof Class) || !Tree.class.isAssignableFrom((Class)bound)) continue;
                return (Class)bound;
            }
        }
        Type sup = v.getGenericSuperclass();
        for (int i = 0; i < 20; ++i) {
            if (sup instanceof ParameterizedType) {
                for (Type bound : ((ParameterizedType)sup).getActualTypeArguments()) {
                    if (!(bound instanceof Class) || !Tree.class.isAssignableFrom((Class)bound)) continue;
                    return (Class)bound;
                }
                sup = ((ParameterizedType)sup).getRawType();
                continue;
            }
            if (!(sup instanceof Class)) continue;
            sup = ((Class)sup).getGenericSuperclass();
        }
        throw new IllegalArgumentException("Expected to find a tree type somewhere in the type parameters of the type hierarchy of visitor " + this.getClass().getName());
    }

    public <R extends Tree, V extends TreeVisitor<R, P>> V adapt(Class<? extends V> adaptTo) {
        if (adaptTo.isAssignableFrom(this.getClass())) {
            return (V)this;
        }
        if (!this.isAdaptableTo(adaptTo)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be adaptable to " + adaptTo.getName() + ".");
        }
        return (V)((TreeVisitor)TreeVisitorAdapter.adapt(this, adaptTo, new TreeVisitor[0]));
    }

    @Nullable
    protected String describeLocation(Cursor cursor) {
        SourceFile sourceFile = cursor.firstEnclosing(SourceFile.class);
        if (sourceFile == null) {
            return null;
        }
        return sourceFile.getSourcePath().toString();
    }

    @Incubating(since="8.0.0")
    public void stopAfterPreVisit() {
        this.getCursor().putMessage(STOP_AFTER_PRE_VISIT, true);
    }
}

