/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeObserver;
import org.openrewrite.internal.lang.Nullable;

public interface ExecutionContext {
    public static final String CURRENT_RECIPE = "org.openrewrite.currentRecipe";
    public static final String UNCAUGHT_EXCEPTION_COUNT = "org.openrewrite.uncaughtExceptionCount";
    public static final String DATA_TABLES = "org.openrewrite.dataTables";
    public static final String RUN_TIMEOUT = "org.openrewrite.runTimeout";

    @Incubating(since="7.20.0")
    default public ExecutionContext addObserver(TreeObserver.Subscription observer) {
        this.putMessageInCollection("org.openrewrite.internal.treeObservers", observer, () -> Collections.newSetFromMap(new IdentityHashMap()));
        return this;
    }

    @Incubating(since="7.20.0")
    default public Set<TreeObserver.Subscription> getObservers() {
        return this.getMessage("org.openrewrite.internal.treeObservers", Collections.emptySet());
    }

    public void putMessage(String var1, @Nullable Object var2);

    @Nullable
    public <T> T getMessage(String var1);

    default public <V, T> T computeMessage(String key, V value, Supplier<T> defaultValue, BiFunction<V, ? super T, ? extends T> remappingFunction) {
        T oldMessage = this.getMessage(key);
        if (oldMessage == null) {
            oldMessage = defaultValue.get();
        }
        T newMessage = remappingFunction.apply(value, oldMessage);
        this.putMessage(key, newMessage);
        return newMessage;
    }

    default public <V, C extends Collection<V>> C putMessageInCollection(String key, V value, Supplier<C> newCollection) {
        return (C)this.computeMessage(key, value, newCollection, (v, acc) -> {
            Collection c = (Collection)newCollection.get();
            c.addAll(acc);
            c.add(value);
            return c;
        });
    }

    default public <T> Set<T> putMessageInSet(String key, T value) {
        return this.putMessageInCollection(key, value, HashSet::new);
    }

    default public <T> T getMessage(String key, @Nullable T defaultValue) {
        T t = this.getMessage(key);
        return t == null ? defaultValue : t;
    }

    @Nullable
    public <T> T pollMessage(String var1);

    default public <T> T pollMessage(String key, T defaultValue) {
        T t = this.pollMessage(key);
        return t == null ? defaultValue : t;
    }

    default public void putCurrentRecipe(Recipe recipe) {
        this.putMessage(CURRENT_RECIPE, recipe);
    }

    default public int incrementAndGetUncaughtExceptionCount() {
        int count = this.getMessage(UNCAUGHT_EXCEPTION_COUNT, 0) + 1;
        this.putMessage(UNCAUGHT_EXCEPTION_COUNT, count);
        return count;
    }

    public Consumer<Throwable> getOnError();

    public BiConsumer<Throwable, ExecutionContext> getOnTimeout();
}

