/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@Incubating(since="7.0.0")
public class Markers
implements Tree {
    public static final Markers EMPTY = new Markers(Tree.randomId(), Collections.emptyList()){

        public String toString() {
            return "Markers{EMPTY}";
        }
    };
    private final UUID id;
    private final List<Marker> markers;

    private Markers(UUID id, List<Marker> markers) {
        this.id = id;
        this.markers = markers;
    }

    @JsonCreator
    public static Markers build(Collection<? extends Marker> markers) {
        ArrayList<Marker> markerList;
        if (markers instanceof List) {
            markerList = (ArrayList<Marker>)markers;
        } else {
            markerList = new ArrayList<Marker>(markers.size());
            markerList.addAll(markers);
        }
        return markers.isEmpty() ? EMPTY : new Markers(Tree.randomId(), markerList);
    }

    public Collection<? extends Marker> entries() {
        return this.markers;
    }

    public Markers add(Marker marker) {
        if (this.markers.stream().anyMatch(marker::equals)) {
            return this;
        }
        ArrayList<Marker> updatedmarker = new ArrayList<Marker>(this.markers);
        updatedmarker.add(marker);
        return new Markers(this.id, updatedmarker);
    }

    public <M extends Marker> Markers computeByType(M identity, BinaryOperator<M> remappingFunction) {
        ArrayList<Marker> updatedmarker = new ArrayList<Marker>(this.markers.size() + 1);
        boolean updated = false;
        for (Marker m : this.markers) {
            if (m.getClass().equals(identity.getClass())) {
                updatedmarker.add((Marker)remappingFunction.apply(m, identity));
                updated = true;
                continue;
            }
            updatedmarker.add(m);
        }
        if (!updated) {
            updatedmarker.add(identity);
        }
        return new Markers(this.id, updatedmarker);
    }

    public <M extends Marker> Markers compute(M identity, BinaryOperator<M> remappingFunction) {
        AtomicBoolean foundEqualMarker = new AtomicBoolean(false);
        List<Marker> updatedMarkers = ListUtils.map(this.markers, m -> {
            if (m.equals(identity)) {
                foundEqualMarker.set(true);
                return (Marker)remappingFunction.apply(m, identity);
            }
            return m;
        });
        if (!foundEqualMarker.get()) {
            updatedMarkers = ListUtils.concat(updatedMarkers, identity);
        }
        return this.withMarkers(updatedMarkers);
    }

    public <M extends Marker> Markers addIfAbsent(M m) {
        return this.compute(m, (m1, m2) -> m1);
    }

    public <M extends Marker> List<M> findAll(Class<M> markerType) {
        return this.markers.stream().filter(markerType::isInstance).map(markerType::cast).collect(Collectors.toList());
    }

    public <M extends Marker> Optional<M> findFirst(Class<M> markerType) {
        return this.markers.stream().filter(markerType::isInstance).map(markerType::cast).findFirst();
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return false;
    }

    @Override
    public <P> String print(TreePrinter<P> printer, P p) {
        return "";
    }

    @NonNull
    public Markers withMarkers(List<Marker> markers) {
        return this.markers == markers ? this : new Markers(this.id, markers);
    }
}

