/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.UUID;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public final class RecipesThatMadeChanges
implements Marker {
    private final UUID id;
    private final Collection<Stack<Recipe>> recipes;

    public static RecipesThatMadeChanges create(Stack<Recipe> recipeStack) {
        ArrayList<Stack<Recipe>> recipeStackList = new ArrayList<Stack<Recipe>>(1);
        recipeStackList.add(recipeStack);
        return new RecipesThatMadeChanges(Tree.randomId(), recipeStackList);
    }

    public RecipesThatMadeChanges(UUID id, Collection<Stack<Recipe>> recipes) {
        this.id = id;
        this.recipes = recipes;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public Collection<Stack<Recipe>> getRecipes() {
        return this.recipes;
    }

    @NonNull
    public String toString() {
        return "RecipesThatMadeChanges(id=" + this.getId() + ", recipes=" + this.getRecipes() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipesThatMadeChanges)) {
            return false;
        }
        RecipesThatMadeChanges other = (RecipesThatMadeChanges)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public RecipesThatMadeChanges withId(UUID id) {
        return this.id == id ? this : new RecipesThatMadeChanges(id, this.recipes);
    }

    @NonNull
    public RecipesThatMadeChanges withRecipes(Collection<Stack<Recipe>> recipes) {
        return this.recipes == recipes ? this : new RecipesThatMadeChanges(this.id, recipes);
    }
}

