/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.RecipeRunStats;
import org.openrewrite.RecipeSchedulerUtils;
import org.openrewrite.RecipeTimeoutException;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.internal.FindRecipeRunException;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markup;
import org.openrewrite.scheduling.WatchableExecutionContext;
import org.openrewrite.table.SourcesFileErrors;

public interface RecipeScheduler {
    default public <T> List<T> mapAsync(List<T> input, UnaryOperator<T> mapFn) {
        CompletableFuture[] futures = new CompletableFuture[input.size()];
        int k = 0;
        for (Object before : input) {
            Callable<Object> updateTreeFn = () -> mapFn.apply(before);
            futures[k++] = this.schedule(updateTreeFn);
        }
        CompletableFuture.allOf(futures).join();
        return ListUtils.map(input, (j, in) -> futures[j].join());
    }

    default public RecipeRun scheduleRun(Recipe recipe, List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles, int minCycles) {
        List<? extends SourceFile> acc;
        org.openrewrite.table.RecipeRunStats runStatsTable = new org.openrewrite.table.RecipeRunStats(Recipe.noop());
        RecipeRunStats runStats = new RecipeRunStats(recipe);
        RecipeRun recipeRun = new RecipeRun(runStats, Collections.emptyList(), Collections.emptyMap());
        HashSet sourceFileIds = new HashSet();
        before = ListUtils.map(before, sourceFile -> {
            if (!sourceFileIds.add(sourceFile.getId())) {
                return (SourceFile)sourceFile.withId(Tree.randomId());
            }
            return sourceFile;
        });
        DistributionSummary.builder((String)"rewrite.recipe.run").tag("recipe", recipe.getDisplayName()).description("The distribution of recipe runs and the size of source file batches given to them to process.").baseUnit("source files").register((MeterRegistry)Metrics.globalRegistry).record((double)before.size());
        HashMap<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile = new HashMap<UUID, Stack<Recipe>>();
        List<? extends SourceFile> after = acc = before;
        WatchableExecutionContext ctxWithWatch = new WatchableExecutionContext(ctx);
        for (int i = 0; i < maxCycles && ctx.getMessage("__AHHH_PANIC!!!__") == null; ++i) {
            Stack<Recipe> recipeStack = new Stack<Recipe>();
            recipeStack.push(recipe);
            after = this.scheduleVisit(runStats, recipeStack, acc, ctxWithWatch, null, recipeThatAddedOrDeletedSourceFile, false);
            if (i + 1 >= minCycles && (after == acc && !ctxWithWatch.hasNewMessages() || !recipe.causesAnotherCycle())) break;
            acc = after;
            ctxWithWatch.resetHasNewMessages();
        }
        if (after == before) {
            runStatsTable.record(ctx, runStats);
            return recipeRun.withDataTables(ctx.getMessage("org.openrewrite.dataTables", Collections.emptyMap()));
        }
        List<Result> results = RecipeSchedulerUtils.createAndProcessResults(before, after, ctx, recipeThatAddedOrDeletedSourceFile);
        runStatsTable.record(ctx, runStats);
        return recipeRun.withResults(results).withDataTables(ctx.getMessage("org.openrewrite.dataTables", Collections.emptyMap()));
    }

    default public <S extends SourceFile> List<S> scheduleVisit(RecipeRunStats runStats, Stack<Recipe> recipeStack, List<S> before, ExecutionContext ctx, @Nullable Map<UUID, Boolean> singleSourceApplicableTestResult, Map<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile, boolean isApplicableTest) {
        List<SourceFile> afterWidened;
        List<SourceFile> after;
        boolean hasSingleSourceApplicableTest;
        runStats.markCall();
        long startTime = System.nanoTime();
        Recipe recipe = recipeStack.peek();
        if (!1.$assertionsDisabled && recipe != runStats.getRecipe()) {
            throw new AssertionError((Object)"Recipe stack should always contain the recipe being run");
        }
        Cursor rootCursor = new Cursor(null, "root");
        ctx.putCurrentRecipe(recipe);
        if (ctx instanceof WatchableExecutionContext) {
            ((WatchableExecutionContext)ctx).resetHasNewMessages();
        }
        try {
            List<Recipe> singleSourceApplicableTests;
            List<Recipe> applicableTests = recipe.getApplicableTests();
            if (!applicableTests.isEmpty()) {
                boolean anySourceMatch = false;
                for (SourceFile s2 : before) {
                    if (!RecipeSchedulerUtils.testAllApplicableTestsMatchSourceFile(s2, applicableTests, runStats, this, recipeStack, ctx)) continue;
                    anySourceMatch = true;
                    break;
                }
                if (!anySourceMatch) {
                    return before;
                }
            }
            if (!(singleSourceApplicableTests = recipe.getSingleSourceApplicableTests()).isEmpty()) {
                if ((singleSourceApplicableTestResult == null || singleSourceApplicableTestResult.isEmpty()) && singleSourceApplicableTestResult == null) {
                    singleSourceApplicableTestResult = new HashMap<UUID, Boolean>(before.size());
                }
                for (SourceFile s2 : before) {
                    if (singleSourceApplicableTestResult.containsKey(s2.getId()) && !singleSourceApplicableTestResult.get(s2.getId()).booleanValue()) continue;
                    singleSourceApplicableTestResult.put(s2.getId(), RecipeSchedulerUtils.testAllApplicableTestsMatchSourceFile(s2, singleSourceApplicableTests, runStats, this, recipeStack, ctx));
                }
            }
        }
        catch (Throwable t) {
            return RecipeSchedulerUtils.handleUncaughtException(recipeStack, recipeThatAddedOrDeletedSourceFile, before, ctx, recipe, t);
        }
        SourcesFileErrors errorsTable = new SourcesFileErrors(Recipe.noop());
        AtomicBoolean thrownErrorOnTimeout = new AtomicBoolean(false);
        Map<UUID, Boolean> singleSourceApplicableTestResultRef = singleSourceApplicableTestResult;
        boolean bl = hasSingleSourceApplicableTest = singleSourceApplicableTestResult != null && !singleSourceApplicableTestResult.isEmpty();
        if (!recipe.validate(ctx).isValid()) {
            after = before;
        } else {
            long getVisitorStartTime = System.nanoTime();
            after = this.mapAsync(before, s -> {
                SourceFile afterFile;
                Timer.Sample sample;
                Timer.Builder timer;
                block14: {
                    timer = Timer.builder((String)"rewrite.recipe.visit").tag("recipe", recipe.getDisplayName());
                    sample = Timer.start();
                    afterFile = s;
                    try {
                        if (hasSingleSourceApplicableTest && singleSourceApplicableTestResultRef.containsKey(s.getId()) && !((Boolean)singleSourceApplicableTestResultRef.get(s.getId())).booleanValue()) {
                            return s;
                        }
                        Duration duration = Duration.ofNanos(System.nanoTime() - startTime);
                        if (duration.compareTo(ctx.getRunTimeout(before.size())) > 0) {
                            if (thrownErrorOnTimeout.compareAndSet(false, true)) {
                                RecipeTimeoutException t = new RecipeTimeoutException(recipe);
                                ctx.getOnError().accept(t);
                                ctx.getOnTimeout().accept(t, ctx);
                            }
                            sample.stop(MetricsHelper.successTags(timer, "timeout").register((MeterRegistry)Metrics.globalRegistry));
                            return s;
                        }
                        if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                            sample.stop(MetricsHelper.successTags(timer, "panic").register((MeterRegistry)Metrics.globalRegistry));
                            return s;
                        }
                        TreeVisitor<?, ExecutionContext> visitor = recipe.getVisitor();
                        visitor.cursor = rootCursor;
                        afterFile = (SourceFile)visitor.visitSourceFile((SourceFile)s, ctx);
                        if (afterFile != null && visitor.isAcceptable(afterFile, ctx)) {
                            afterFile = (SourceFile)visitor.visit(afterFile, ctx);
                        }
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags(timer, t).register((MeterRegistry)Metrics.globalRegistry));
                        ctx.getOnError().accept(t);
                        if (t instanceof RecipeRunException) {
                            RecipeRunException vt = (RecipeRunException)t;
                            afterFile = (SourceFile)new FindRecipeRunException(vt).visitNonNull(Objects.requireNonNull(afterFile, "afterFile is null"), 0);
                        } else if (afterFile != null) {
                            afterFile = Markup.error(afterFile, t);
                        }
                        if (s == null) break block14;
                        errorsTable.insertRow(ctx, new SourcesFileErrors.Row(s.getSourcePath().toString(), recipe.getName(), ExceptionUtils.sanitizeStackTrace(t, RecipeScheduler.class)));
                    }
                }
                if (afterFile != null && afterFile != s && !isApplicableTest) {
                    afterFile = RecipeSchedulerUtils.addRecipesThatMadeChanges(recipeStack, afterFile);
                    sample.stop(MetricsHelper.successTags(timer, "changed").register((MeterRegistry)Metrics.globalRegistry));
                } else if (afterFile == null) {
                    recipeThatAddedOrDeletedSourceFile.put(Objects.requireNonNull(s).getId(), recipeStack);
                    sample.stop(MetricsHelper.successTags(timer, "deleted").register((MeterRegistry)Metrics.globalRegistry));
                } else {
                    sample.stop(MetricsHelper.successTags(timer, "unchanged").register((MeterRegistry)Metrics.globalRegistry));
                }
                return afterFile;
            });
            runStats.ownGetVisitorCompleted(getVisitorStartTime);
        }
        Map<UUID, Boolean> lastSingleSourceApplicableTestResult = singleSourceApplicableTestResult;
        HashMap newSingleSourceApplicableTestResult = new HashMap();
        try {
            long ownVisitStartTime = System.nanoTime();
            if (hasSingleSourceApplicableTest && singleSourceApplicableTestResult.values().stream().noneMatch(b -> b)) {
                runStats.recipeVisitCompleted(startTime);
                return after;
            }
            afterWidened = recipe.visit(after, ctx);
            if (hasSingleSourceApplicableTest) {
                HashMap<UUID, SourceFile> originalMap = new HashMap<UUID, SourceFile>(after.size());
                for (SourceFile sourceFile : after) {
                    originalMap.put(sourceFile.getId(), sourceFile);
                }
                afterWidened = ListUtils.map(afterWidened, s -> {
                    Boolean singleSourceTestResult = (Boolean)lastSingleSourceApplicableTestResult.get(s.getId());
                    if (singleSourceTestResult != null) {
                        newSingleSourceApplicableTestResult.put(s.getId(), singleSourceTestResult);
                        if (!singleSourceTestResult.booleanValue()) {
                            return (SourceFile)originalMap.get(s.getId());
                        }
                    } else {
                        newSingleSourceApplicableTestResult.put(s.getId(), true);
                    }
                    return s;
                });
            }
            runStats.ownVisitCompleted(ownVisitStartTime);
        }
        catch (Throwable t) {
            runStats.recipeVisitCompleted(startTime);
            return RecipeSchedulerUtils.handleUncaughtException(recipeStack, recipeThatAddedOrDeletedSourceFile, before, ctx, recipe, t);
        }
        if (afterWidened != after) {
            HashMap<UUID, SourceFile> originalMap = new HashMap<UUID, SourceFile>(after.size());
            for (SourceFile file : after) {
                originalMap.put(file.getId(), file);
            }
            afterWidened = ListUtils.map(afterWidened, s -> {
                SourceFile original = (SourceFile)originalMap.get(s.getId());
                if (original == null) {
                    recipeThatAddedOrDeletedSourceFile.put(s.getId(), recipeStack);
                } else if (s != original && !isApplicableTest) {
                    return RecipeSchedulerUtils.addRecipesThatMadeChanges(recipeStack, s);
                }
                return s;
            });
            for (SourceFile maybeDeleted : after) {
                if (afterWidened.contains(maybeDeleted)) continue;
                recipeThatAddedOrDeletedSourceFile.put(maybeDeleted.getId(), recipeStack);
            }
        }
        for (Recipe r : recipe.getRecipeList()) {
            if (ctx.getMessage("__AHHH_PANIC!!!__") != null) break;
            Stack<Recipe> nextStack = new Stack<Recipe>();
            nextStack.addAll(recipeStack);
            nextStack.push(r);
            RecipeRunStats nextStats = null;
            for (RecipeRunStats called : runStats.getCalled()) {
                if (called.recipe != r) continue;
                nextStats = called;
                break;
            }
            if (nextStats == null) {
                nextStats = runStats.addCalledRecipe(r);
            }
            HashMap<UUID, Boolean> hashMap = new HashMap<UUID, Boolean>(newSingleSourceApplicableTestResult);
            afterWidened = this.scheduleVisit(nextStats, nextStack, afterWidened, ctx, hashMap, recipeThatAddedOrDeletedSourceFile, isApplicableTest);
        }
        runStats.recipeVisitCompleted(startTime);
        return afterWidened;
    }

    public <T> CompletableFuture<T> schedule(Callable<T> var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

